<?php
global $post, $wp_embed;

# Project settings
$project = StockieObjectParser::parse_to_project_object($post);

if (is_array($project['images_full']) && count($project['images_full']) > 0) {
    $project['images'] = $project['images_full'];
}

if ($project['show_navigation'] == 'prev_n_next' && ($project['prev'] || $project['next'])
    && $project['navigation_position'] == 'top') {
    get_template_part('parts/elements/next-n-prev-projects');
}


# Page container settings
$show_breadcrumbs = StockieSettings::breadcrumbs_is_displayed();
$page_wrapped = StockieSettings::page_is_wrapped();
$add_content_padding = StockieSettings::page_add_top_padding();

$page_container_class = '';
$custom_page_container_class = '';
if (!$show_breadcrumbs && $add_content_padding) {
    $page_container_class .= ' without-breadcrumbs';
}
if (!$page_wrapped) {
    $page_container_class .= ' full';
    $custom_page_container_class .= ' full';
}
if ($add_content_padding) {
    $page_container_class .= ' bottom-offset';
}

if ($show_breadcrumbs) {
    get_template_part('parts/elements/breadcrumbs');
}

?>

<?php if ($project['custom_content_position'] == 'top') : ?>
    <div class="page-container <?php echo esc_attr($custom_page_container_class); ?>">
        <div class="portfolio-page-custom-content">
            <?php echo do_shortcode(get_post_field('post_content', $post->ID)); ?>
        </div>
    </div>
<?php endif; ?>

    <div class="page-container portfolio-page layout-type4 fullwidth content-invert<?php echo esc_attr($page_container_class); ?>"
         id="scroll-portfolio">
        <div class="vc_col-lg-1"></div>
        <div class="vc_col-lg-4 vc_col-md-6 vc_col-sm-12">
            <div class="portfolio-scroll-block" data-stockie-content-scroll="#scroll-portfolio">
                <div class="portfolio-content">
                    <div class="portfolio-title">
                        
                        <?php if ( $project['categories_plain'] ) : ?>
                            <?php $categories = explode( ', ', $project['categories_plain'] ) ?>
                            <?php foreach ( $categories as $category ) : ?>
                                <span class="tag brand-bg-color"><?php echo esc_html( $category ); ?></span>
                            <?php endforeach; ?>
                        <?php endif; ?>

                        <?php the_title( '<h1 class="headline">', '</h1>'); ?>
                    </div>
                    <div class="portfolio-description">
                        <?php echo $wp_embed->run_shortcode( do_shortcode( wp_kses_post( $project['description'] ) ) ); ?>
                        <?php 
                            if ( $project['custom_content_position'] == 'after_description' ) {
                                echo do_shortcode( get_post_field( 'post_content', $post->ID ) );
                            }
                        ?>
                        <?php if ( $project['task'] ) :?>
                        <div class="task">
                            <h6 class="title task-title"><?php esc_html_e( 'Task', 'stockie' ); ?></h6>
                            <p class="task-description font-titles"><?php echo wp_kses( $project['task'], 'default' ); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="info">
                        <ul class="info-list">
                            <?php if ( $project['date'] ) : ?>
                            <li>
                                <div class="title"><?php esc_html_e( 'Date:', 'stockie' ); ?></div>
                                <p><?php echo esc_html( $project['date'] ); ?></p>
                            </li>
                            <?php endif; ?>

                            <?php if ( $project['skills'] ) : ?>
                            <li>
                                <div class="title"><?php esc_html_e( 'Skills:', 'stockie' ); ?></div>
                                <p><?php echo wp_kses( $project['skills'], 'default' ); ?></p>
                            </li>
                            <?php endif; ?>

                            <?php if ( $project['client'] ) : ?>
                            <li>
                                <div class="title"><?php esc_html_e( 'Client:', 'stockie' ); ?></div>
                                <p><?php echo wp_kses( $project['client'], 'default' ); ?></p>
                            </li>
                            <?php endif; ?>

                            <?php
                            $tags = wp_get_post_terms($post->ID, 'stockie_portfolio_tags', array('fields' => 'names'));
                            if (!empty($tags)) {
                                ?>
                                <li>
                                    <div class="title"><?php esc_html_e( 'Tags', 'stockie' ); ?></div>
                                    <p>
                                        <?php
                                        echo esc_html(implode(', ', $tags));?>
                                    </p>
                                </li>
                                <?php
                            }
                            ?>

                            <?php if ( $project['custom_fields'] ) : ?>
                                <?php foreach ( $project['custom_fields'] as $custom_field ) : ?>
                                <li>
                                    <div class="title"><?php echo esc_html( $custom_field['title'] ); ?>:</div>
                                    <p><?php echo esc_html( $custom_field['value'] ); ?></p>
                                </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </ul>
                        
                        <?php if ( ! $project['hide_sharing'] && $project['sharing_links'] && count( $project['sharing_links'] ) > 0 ) : ?>
                        <div class="prjct-share-bar">
                            <h6 class="title task-title"><?php esc_html_e( 'Share this project', 'stockie' ); ?>:</h6>
                            <div class="socialbar inline">
                                <?php echo wp_kses($project['sharing_links_html'], 'post'); ?>
                            </div>  
                        </div>
                        <?php endif; ?>

                        <?php if ( $project['link'] ) : ?>
                        <a href="<?php echo esc_url( $project['link'] ); ?>" class="open-website btn" target="_blank">
                            <span class="text">
                                <?php esc_html_e( 'Open Project', 'stockie' ); ?>
                            </span>
                            <i class="ion ion-right ion-ios-arrow-forward"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="vc_col-lg-1"></div>
        <div class="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 images-wrap">
            <?php if (is_array($project['images'])) : ?>
                <?php foreach ($project['images'] as $art) :
                    $alt = get_post_meta(StockieHelper::get_attachment_id($art), '_wp_attachment_image_alt', TRUE); ?>
                    <img src="<?php echo esc_url($art); ?>" alt="<?php echo esc_attr($alt) ?>">
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

    </div><!--.portfolio-page-->

<?php if ($project['custom_content_position'] == 'bottom') : ?>
    <div class="page-container <?php echo esc_attr($custom_page_container_class); ?>">
        <div class="portfolio-page-custom-content">
            <?php echo do_shortcode(get_post_field('post_content', $post->ID)); ?>
        </div>
    </div>
<?php endif; ?>

<?php
if ($project['show_navigation'] == 'prev_n_next' && ($project['prev'] || $project['next'])
    && $project['navigation_position'] == 'bottom') {
    get_template_part('parts/elements/next-n-prev-projects');
}
?>

<?php if (comments_open() || get_comments_number()) : ?>
    <div class="portfolio-comments">
        <?php comments_template(); ?>
    </div>
<?php endif; ?>