<?php
// Settings
$show_subheader = StockieSettings::subheader_is_displayed();
$use_wrapper = StockieSettings::header_use_wrapper();
$is_fixed = StockieSettings::header_is_fixed();
$header_menu_style = StockieSettings::header_menu_style();

if ( $header_menu_style == 'style2' ) {
    $use_wrapper = true;
} 
if ( $header_menu_style == 'style6' ) {
    $use_wrapper = false;
}

$subheader_have_items_left = have_rows('global_header_menu_subheader_items_left', 'option');
$subheader_have_items_right = have_rows('global_header_menu_subheader_items_right', 'option');
$currency_switcher = StockieSettings::get('woocommerce_header_currency_switcher', 'global');
$language_switcher = StockieSettings::get('woocommerce_header_lanhuage_switcher', 'global');
$have_wpml = function_exists('icl_get_languages');
?>

<?php if ($show_subheader) : ?>

    <div class="subheader<?php if ($is_fixed) {
        echo esc_attr(' fixed');
    } ?>">
        <div class="content">

            <div class="page-container<?php if ( !$use_wrapper ) {
                echo esc_attr(' full');
            } ?>">

                <?php if ($subheader_have_items_left) : ?>
                    <ul class="left">
                        <?php while (have_rows('global_header_menu_subheader_items_left', 'option')): the_row(); ?>
                            <li><?php echo get_sub_field('items'); ?></li>
                        <?php endwhile; ?>
                    </ul>
                <?php endif; ?>


                <ul class="right">
                    <?php if ($currency_switcher && shortcode_exists('woocs')): ?>
                        <li>
                            <div class="currency_switcher">
                                <?php echo do_shortcode('[woocs]'); ?>
                            </div>
                        </li>
                    <?php endif; ?>

                    <?php if ( $have_wpml && $language_switcher ) : ?>
                        <li>
                            <!-- Lang switcher -->
                            <?php get_template_part('parts/elements/language-dropdown');?>
                        </li>
                    <?php endif; ?>

                    <?php if ($subheader_have_items_right) : ?>
                        <?php while (have_rows('global_header_menu_subheader_items_right', 'option')): the_row(); ?>
                            <li><?php echo get_sub_field('items'); ?></li>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </ul>

            </div>
        </div>
    </div><!-- .subheader -->

<?php endif; ?>