<?php
// Settings
$is_fixed = StockieSettings::header_is_fixed();
$mobile_is_fixed = StockieSettings::get('header_mobile_menu_fixed', 'global');
$fixed_initial_offset = StockieSettings::get('header_fixed_initial_offset', 'global');
$show_subheader = StockieSettings::subheader_is_displayed();

$mobile_search_visibility = StockieSettings::get('mobile_search_visibility', 'global');

$header_classes = '';

if ($show_subheader) {
    $header_classes .= ' subheader_included';
}
if ($mobile_search_visibility == false) {
    $header_classes .= ' without-mobile-search';
}

$menu_type = StockieSettings::menu_type();

if ($menu_type == "both") {
    $header_classes .= ' both_type';
}

?>

<?php if (function_exists('woocommerce_mini_cart')) { ?>
    <div class="submenu_cart cart <?php if (!WC()->cart->is_empty()) echo esc_attr('cart'); ?>">
        <div class="cart_header">
            <div class="cart_heading">
                <h6 class="cart_heading_title"><?php esc_html_e('Review Cart', 'stockie'); ?></h6>
            </div>
            <div class="close close-bar">
                <div class="close-bar-btn btn-round round-animation" tabindex="0">
                    <i class="ion ion-android-close"></i>
                </div>
            </div>
        </div>
        <div class="widget_shopping_cart_content">
            <?php woocommerce_mini_cart(); ?>
        </div>
    </div>
    <div class="cart-overlay"></div>
<?php } ?>

    <header id="masthead" class="site-header header-7<?php echo esc_attr( $header_classes ); ?>"
        <?php if ($mobile_is_fixed) {
            echo ' data-mobile-header-fixed="true"';
        } ?>
        <?php if ($fixed_initial_offset) {
            echo ' data-fixed-initial-offset="' . $fixed_initial_offset . '"';
        } ?>>

        <div class="header-wrap">
            <div class="header-wrap-inner vertical-inner">

                <div class="top-part">
                    <div class="top-part-inner">
                        <!-- Hamburger menu -->
                        <div class="hamburger-menu" id="hamburger-fullscreen-menu">
                            <a href="#" class="hamburger" aria-controls="site-navigation" aria-expanded="false">
                                <span class="hamburger_line_1"></span>
                                <span class="hamburger_line_2"></span>
                                <span class="hamburger_line_3"></span>
                            </a>
                        </div>

                        <!-- Mobile menu -->
                        <div class="hamburger-menu" id="hamburger-menu">
                            <a href="#" class="hamburger" aria-controls="site-navigation" aria-expanded="false">
                                <span class="hamburger_line_1"></span>
                                <span class="hamburger_line_2"></span>
                                <span class="hamburger_line_3"></span>
                            </a>
                        </div>
                        <?php get_template_part('parts/elements/header-menu-nav'); ?>
                        <?php get_template_part('parts/elements/header-menu-logo'); ?>
                    </div>
                </div>

                <div class="bottom-part">
                    <?php get_template_part('parts/elements/header-menu-optional-nav'); ?>
                    <div class="close-menu"></div>
                </div>
            </div>
        </div>
    </header>
<?php get_template_part('parts/elements/header-menu-fullscreen-nav'); ?>