<?php
    // Settings
    $is_fixed = StockieSettings::header_is_fixed();
    $header_style= StockieSettings::get( 'header_menu_style', 'global' );
    $mobile_is_fixed = StockieSettings::get( 'header_mobile_menu_fixed', 'global' );
    $fixed_initial_offset = StockieSettings::get( 'header_fixed_initial_offset', 'global' );
    $use_wrapper = StockieSettings::header_use_wrapper();
    $show_search = ! StockieSettings::get( 'header_hide_search', 'global' );
    $show_subheader = StockieSettings::subheader_is_displayed();
    $cart_visible = StockieSettings::get( 'woocommerce_cart_icon', 'global' );
    $account_visible = StockieSettings::get( 'woocommerce_account_icon', 'global' );
    $mobile_search_visibility = StockieSettings::get( 'mobile_search_visibility', 'global' );
    $have_woocomerce = function_exists( 'WC' );
    $have_woocomerce_wl = function_exists( 'YITH_WCWL' );
    $wpml_show_in_header = StockieSettings::get( 'wpml_show_in_header', 'global' );
    $header_classes = '';

    if ( $show_subheader ) { 
        $header_classes .= ' subheader_included'; 
    }
    if ( $mobile_search_visibility == false ) {
        $header_classes .= ' without-mobile-search';
    }

    $menu_type = StockieSettings::menu_type();

    if ( $menu_type == "both" ) {
        $header_classes .= ' both_type';
    }

    $menu_position = StockieSettings::get( 'page_header_menu_position', 'global' );
	$mobile_menu_position = StockieSettings::get( 'page_header_mobile_menu_position', 'global' );
?>

<header id="masthead" class="site-header dark-text header-5<?php echo esc_attr( $header_classes ); ?>"
    <?php if ( $is_fixed ) { echo ' data-header-fixed="true"'; } ?>
    <?php if ( $mobile_is_fixed ) { echo ' data-mobile-header-fixed="true"'; } ?>
    <?php if ( $fixed_initial_offset ) { echo ' data-fixed-initial-offset="' . $fixed_initial_offset . '"'; } ?>>
        
    <div class="header-wrap">
        <div class="top-part<?php if ( $use_wrapper ) { echo ' page-container'; } ?>">
            <div class="left-part"> 
                <?php 
                if ($menu_position == 'left') {
                    if ( ! StockieSettings::hamburger() ) { get_template_part( 'parts/elements/header-menu-hamburger' );}
                }
                ?>

                <?php if ($mobile_menu_position == 'left' || $mobile_menu_position == NULL): ?>
                    <div class="hamburger-menu" id="hamburger-menu">
                        <a href="#" class="hamburger" aria-controls="site-navigation" aria-expanded="false">
                            <span class="hamburger_line_1"></span>
                            <span class="hamburger_line_2"></span>
                            <span class="hamburger_line_3"></span>
                        </a>
                    </div>
                <?php endif; ?>

                <?php get_template_part( 'parts/elements/header-menu-logo' ); ?>

                <ul class="menu-other text-left">

                    <?php if ( $wpml_show_in_header ) : ?>

                        <li class="lang-switcher">
                            <?php get_template_part( 'parts/elements/language-dropdown' ); ?>
                        </li>

                    <?php endif; ?>

                    <li>
                        <?php get_template_part( 'parts/elements/header-button' ); ?>
                    </li>

                    <?php if ( $show_search ) : ?>
                        
                        <li class="search">
                            <a href="#" data-nav-search="true">
                                <i class="icon ion ion-android-search"></i>
                            </a>
                        </li>

                    <?php endif; ?>

                </ul>
            </div>
            <?php get_template_part( 'parts/elements/header-menu-nav' ); ?>

            <ul class="menu-other text-right right-part">

                <?php if ( $show_search ) : ?>
                    <li class="search">
                        <a href="#" data-nav-search="true">
                            <i class="icon ion ion-android-search"></i>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ( $have_woocomerce ) : ?>

                    <?php if ( $account_visible !== false ) : ?>
                        <li>
                            <a class="user" href="<?php echo wc_get_page_permalink( 'myaccount' ); ?>">
                                <i class="icon ion ion-android-person brand-color-hover-i"></i>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if ( $cart_visible !== false ) : ?>

                        <?php if ($have_woocomerce_wl) : ?>
                            <li>
                                <a href="<?php echo esc_url(YITH_WCWL()->get_wishlist_url('user' . '/' . get_current_user_id())); ?>"
                                   class="wishlist">
                                    <i class="icon ion ion-android-heart-empty brand-color-hover-i"></i>
                                    <?php if ($header_style == 'style6') {
                                        esc_html_e('Wishlist', 'stockie');
                                    } ?>
                                </a>
                            </li>
                        <?php endif; ?>

                        <li class="header-cart">
                            <span class="cart-total">
                                <a class="cart-customlocation -unlink" href="<?php echo wc_get_cart_url(); ?>"><?php echo WC()->cart->get_cart_total(); ?></a>
                            </span>
                            <a href="#" class="cart">
                                <span class="icon">
                                    <svg version="1.1"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 12 16" xml:space="preserve">
                                    <path class="st0" d="M9,4V3c0-1.7-1.3-3-3-3S3,1.3,3,3v1H0v10c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V4H9z M4,3c0-1.1,0.9-2,2-2
                                        s2,0.9,2,2v1H4V3z"/>
                                    </svg>
                                    <span class="cart-count brand-bg-color"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                                </span>
                            </a>
                            <div class="submenu_cart cart <?php if ( ! WC()->cart->is_empty() ) echo esc_attr('cart'); ?>">
                                <div class="cart_header">
                                    <div class="cart_heading">
                                        <h6 class="cart_heading_title"><?php esc_html_e( 'Review Cart', 'stockie' ); ?></h6>
                                    </div>
                                    <div class="close close-bar" id="close_cart">
                                        <div class="close-bar-btn btn-round round-animation" tabindex="0">
                                            <i class="ion ion-android-close"></i>    
                                        </div>
                                    </div>
                                </div>
                                <div class="widget_shopping_cart_content">
                                    <?php woocommerce_mini_cart(); ?>
                                </div>
                            </div>
                            <div class="cart-overlay"></div>
                        </li>
                    <?php endif; ?>

                <?php endif; ?>

				<?php if ($menu_position == 'right') {if ( ! StockieSettings::hamburger() ) { get_template_part( 'parts/elements/header-menu-hamburger' );}}?>

				<?php if ($mobile_menu_position == 'right'): ?>
					<div class="hamburger-menu" id="hamburger-menu">
						<a href="#" class="hamburger" aria-controls="site-navigation" aria-expanded="false">
							<span class="hamburger_line_1"></span>
							<span class="hamburger_line_2"></span>
							<span class="hamburger_line_3"></span>
						</a>
					</div>
				<?php endif; ?>
            </ul>
        </div>
        <div class="middle-part"></div>
    </div>
</header>
<?php get_template_part( 'parts/elements/header-menu-fullscreen-nav' ); ?>