<?php
	// Settings
	$is_fixed = StockieSettings::header_is_fixed();
	$mobile_is_fixed = StockieSettings::get( 'header_mobile_menu_fixed', 'global' );
	$fixed_initial_offset = StockieSettings::get( 'header_fixed_initial_offset', 'global' );

	$use_wrapper = StockieSettings::header_use_wrapper();
	$show_subheader = StockieSettings::subheader_is_displayed();

	$mobile_search_visibility = StockieSettings::get( 'mobile_search_visibility', 'global' );

	$header_classes = '';

	if ( $show_subheader ) { 
		$header_classes .= ' subheader_included'; 
	}
	if ( $mobile_search_visibility == false ) {
		$header_classes .= ' without-mobile-search';
	}

	$menu_type = StockieSettings::menu_type();

	if ( $menu_type == "both" ) {
		$header_classes .= ' both_type';
	}

	$menu_position = StockieSettings::get( 'page_header_menu_position', 'global' );
	$mobile_menu_position = StockieSettings::get( 'page_header_mobile_menu_position', 'global' );
?>

<header id="masthead" class="site-header header-1<?php echo esc_attr( $header_classes ); ?>"
	<?php if ( $is_fixed ) { echo ' data-header-fixed="true"'; } ?>
	<?php if ( $mobile_is_fixed ) { echo ' data-mobile-header-fixed="true"'; } ?>
	<?php if ( $fixed_initial_offset ) { echo ' data-fixed-initial-offset="' . $fixed_initial_offset . '"'; } ?>>

	<div class="header-wrap<?php if ( $use_wrapper ) { echo ' page-container'; } ?>">
		<div class="header-wrap-inner">
			<div class="left-part">
				<?php 
				if ($menu_position == 'left') {
					if ( ! StockieSettings::hamburger() ) { get_template_part( 'parts/elements/header-menu-hamburger' );}
				}
				?>

				<?php if ($mobile_menu_position == 'left' || $mobile_menu_position == NULL): ?>
					<!-- Mobile menu -->
					<div class="hamburger-menu" id="hamburger-menu">
						<a href="#" class="hamburger" aria-controls="site-navigation" aria-expanded="false">
							<span class="hamburger_line_1"></span>
							<span class="hamburger_line_2"></span>
							<span class="hamburger_line_3"></span>
						</a>
					</div>
				<?php endif; ?>

	        	<?php get_template_part( 'parts/elements/header-menu-logo' ); ?>	
			</div>
	        <div class="right-part">
	            <?php get_template_part( 'parts/elements/header-menu-nav' ); ?>
	            <?php get_template_part( 'parts/elements/header-menu-optional-nav' ); ?>
				<?php if ($menu_position == 'right') {if ( ! StockieSettings::hamburger() ) { get_template_part( 'parts/elements/header-menu-hamburger' );}}?>

				<?php if ($mobile_menu_position == 'right'): ?>
					<!-- Mobile menu -->
					<div class="hamburger-menu" id="hamburger-menu">
						<a href="#" class="hamburger" aria-controls="site-navigation" aria-expanded="false">
							<span class="hamburger_line_1"></span>
							<span class="hamburger_line_2"></span>
							<span class="hamburger_line_3"></span>
						</a>
					</div>
				<?php endif; ?>

	            <div class="close-menu"></div>
	        </div>
    	</div>
	</div>
</header>
<?php get_template_part( 'parts/elements/header-menu-fullscreen-nav' ); ?>