<?php
$expires = StockieSettings::get('subscribe_popup_expires', 'global');
setcookie('subscribeCookie', "enabled", (time() + 60 * 60 * 24 * $expires), "/");
$background_image = '';
$background_image_enable = StockieSettings::get('subscribe_popup_switch_background_image', 'global');
if ($background_image_enable) {
    $background_image = 'style="background-image: url( '. StockieSettings::get('subcribe_popup_background_image', 'global') .' )"';
}
$background_color = StockieSettings::get('subcribe_popup_background_color', 'global');
$heading = StockieSettings::get('text_subcribe_popup', 'global');
$description = StockieSettings::get('details_text_subcribe_popup', 'global');
$form_id = StockieSettings::get('subscribe_choice_of_forms', 'global');



?>

<div class="subscribe-popup">
    <div class="subscribe">
        <div class="vc_row">
            <div class="subscribe-img vc_col-sm-6 vc_col-xs-12" <?php echo wp_kses($background_image, 'post') ?>>
            </div>
            <div class="subscribe-content text-center vc_col-sm-6 vc_col-xs-12">
                <h4 class="header subscribe-content-header"><?php echo esc_html($heading) ?></h4>
                <div class="subscribe-content-subheader">
                    <p>
                        <?php echo esc_html($description) ?>
                    </p>
                </div>
                <div class="contact-form">
                    <?php if ($form_id): ?>
                        <?php echo do_shortcode('[contact-form-7 id="' . $form_id . '"]') ?>
                    <div class="hidden" data-contact-btn="true">
                        <button class="btn">
                            <span class="btn-load"></span>
                            <span class="text"></span>
                        </button>
                    </div>
                    <?php endif; ?>
                </div>
                <a href="#" class="subscribe-nothanks-btn btn btn-link"><?php esc_html_e('No, thanks', 'stockie'); ?></a>
            </div>    
        </div>
    </div>
</div>
