<?php
	$mobile_social_position = StockieSettings::get( 'header_mobile_social_position', 'global' );
	$links = StockieSettings::get( 'side_panel_social', 'global' );
	$social_enable = StockieSettings::get( 'side_panel_social_enable', 'global' );
	$show_share_on_mobile = StockieSettings::get( 'side_panel_show_share_on_mobile', 'global' );
	$header_menu_style = StockieSettings::header_menu_style();
	$social_html = '';
	$allowed_html = array(
	    'a' => array(
			'href' =>true,
			'target' =>true
	    ),
	    'i' => array(
	        'class' => true
	    )
	);

if ($links && is_array( $links )){

	ob_start();

	foreach ( $links as $link ) {
		switch ( $link ) {
			case 'facebook':
				echo '<a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=' . rawurlencode( get_permalink() ) . '"><i class="fa-brands fa-facebook"></i></a>';
				break;
			case 'twitter':
				echo '<a target="_blank" href="https://twitter.com/intent/tweet?text=' . rawurlencode( get_permalink() ) . '"><i class="fa-brands fa-x-twitter"></i></a>';
				break;
			case 'dribbble':
				echo '<a target="_blank" href="http://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&description=' . urlencode( 'title' ) . '"><i class="fa-brands fa-dribbble"></i></a>';
				break;
			case 'linkedin':
				echo '<a target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url=' . rawurlencode( get_permalink() ) . '&title=' . urlencode( the_title( '', '', false ) ) . '&source=' . urlencode( get_bloginfo( 'name' ) ) . '"><i class="fa-brands fa-linkedin"></i></a>';
				break;
			case 'pinterest':
				echo '<a target="_blank" href="http://pinterest.com/pin/create/button/?url=' . rawurlencode( get_permalink() ) . '"><i class="fa-brands fa-pinterest-p"></i></a>';
				break;
		}
	}

	$social_html = ob_get_clean();
}
?>

<?php if ( is_array( $links ) && $social_enable ) : ?>

	<?php if ( $show_share_on_mobile ) : ?>

		<div class="share-bar<?php 
			if ( $header_menu_style == 'style6' ) { echo ' header-6'; } 
			if ( $header_menu_style == 'style7' ) { echo ' header-8'; } ?>" tabindex="1">

			<div class="title btn-round">
				<i class="ion brand-bg-color brand-color-hover ion-android-add"></i>
				<span class="name font-titles"><?php esc_html_e( 'Share', 'stockie' ); ?></span>
			</div>
			<div class="links">
				<?php echo wp_kses( $social_html, $allowed_html); ?>
			</div>
		</div>

	<?php endif; ?>

<?php endif; ?>

<div class="social-bar<?php if ( $mobile_social_position == 'inside' ) { echo ' inside'; } ?>">
    <?php get_template_part( 'parts/elements/social-networks' ); ?>
</div>