<?php 
	$notification_bar = StockieSettings::get( 'notification_bar', 'global' );

	if ( $notification_bar ) {

		$notification_text = StockieSettings::get( 'notification_text', 'global' );
		$notification_button = StockieSettings::get( 'notification_button', 'global' );
		$notification_link = StockieSettings::get( 'notification_link', 'global' );
		

		if ( $notification_button ) {
			$notification_button_link = StockieSettings::get( 'notification_button_link', 'global' );
		}

		if ( $notification_link ) {
			$notification_link = StockieSettings::get( 'notification_link', 'global' );
		}
	}

?>
<?php if ( $notification_bar && !isset($_COOKIE['notification']) ) : ?>	
<div class="page-container">
	<div class="notification-bar active">
		<div class="notification">
			<div class="notification-text" >
				<?php echo wp_kses($notification_text, 'post') ?>

				<?php if ( $notification_link ) : ?>
					<div class="notification-link">
						<a href="<?php echo esc_url($notification_link['url']) ?>"><?php echo esc_html($notification_link['title']) ?></a>
					</div>
				<?php endif; ?>
			</div>
			<?php if ( $notification_button ) : ?>
				<div class="notification-btn">
					<a href="<?php echo esc_url($notification_button_link['url']) ?>" class="btn btn-small"> <?php echo esc_html($notification_button_link['title']) ?></a>
				</div>
			<?php endif; ?>
		</div>
		<div class="close"><i class="ion ion-android-close"></i></div>
	</div>
</div>
<?php endif; ?>