<?php 
	$project = StockieObjectParser::parse_to_project_object( $post );
	$border_class = ' ';
	switch ( $project['navigation_position'] ) {
		case 'top':
			$border_class .= 'border-bottom';
			break;
		case 'bottom':
			$border_class .= 'border-top';
			break;
	}
?>

<div class="postNav<?php echo esc_attr( $border_class ); ?>">
	<div class="page-container">
		<div class="vc_row">
		<div class="vc_col-md-6 vc_col-xs-6">
			<?php if ( $project['prev'] ) : ?>
			<div class="postNav_item postNav_item_prev">
				<a href="<?php echo esc_url( $project['prev']['url'] ); ?>">
					<div class="postNav_item_arrow btn-round brand-color-hover">
						<i class="ion ion-ios-arrow-back"></i>
					</div>
				</a>
				<a href="<?php echo esc_url( $project['prev']['url'] ); ?>">
					<div class="postNav_item_inner">
						<div class="postNav_item_inner">
							<div class="postNav_item_inner_slug">
								<?php esc_html_e( 'Previous project', 'stockie' ); ?>
							</div>
							<div class="postNav_item_inner_heading brand-color-hover font-titles">
								<?php echo wp_kses( $project['prev']['title'], 'default' ); ?>
							</div>
						</div>
					</div>
				</a>
			</div>
			<?php endif; ?>
		</div>

		<a href="<?php echo esc_url( $project['link_to_all'] ); ?>" class="grid stockie-icon-grid">
			<div class="btn-round">
				<div class="ion">
					<div class="icon brand-bg-hover"></div>
				</div>
			</div>
		</a>

		<div class="vc_col-md-6 vc_col-xs-6">
			<?php if ( $project['next'] ) : ?>
			<div class="postNav_item postNav_item_next">
				<a href="<?php echo esc_url( $project['next']['url'] ); ?>">
					<div class="postNav_item_inner">
						<div class="postNav_item_inner_slug">
							<?php esc_html_e( 'Next project', 'stockie' ); ?>
						</div>
						<div class="postNav_item_inner_heading brand-color-hover font-titles">
							<?php echo wp_kses( $project['next']['title'], 'default' ); ?>
						</div>
					</div>
				</a>
				<a href="<?php echo esc_url( $project['next']['url'] ); ?>">
					<div class="postNav_item_arrow btn-round brand-color-hover">
						<i class="ion ion-ios-arrow-forward"></i>
					</div>
				</a>
			</div>
			<?php endif; ?>
		</div>
		</div>
	</div>
</div>