<?php
	// Settings
	$prev_post = get_adjacent_post( false, '', false );
	$next_post = get_adjacent_post( false, '', true );
	$toggle_post_column = ( ! empty( $prev_post ) && ! empty( $next_post ) ) ? '6' : '12';

	$hide_prev_n_next = StockieSettings::get( 'post_hide_previous_n_next', 'global' );

	if ( ( $prev_post || $next_post ) && ! $hide_prev_n_next ) :
?>

<div class="postNav border-top">
	<div class="page-container">
		<div class="vc_row"> 
			<div class="vc_col-md-<?php echo esc_attr( $toggle_post_column ); ?> vc_col-xs-6">
			<?php if ( ! empty( $prev_post ) ) : ?>
				<div class="postNav_item postNav_item_prev">
					<a href="<?php echo esc_url( get_permalink( $prev_post ) ); ?>">
						<div class="btn-round postNav_item_arrow brand-color-hover">
							<i class="ion ion-ios-arrow-back"></i>
						</div>
					</a>
					<a href="<?php echo esc_url( get_permalink( $prev_post ) ); ?>">
						<div class="postNav_item_inner">
							<div class="postNav_item_inner_slug">
								<?php esc_html_e( 'previous post', 'stockie' ); ?>
							</div>
							<div class="postNav_item_inner_heading brand-color-hover font-titles">
								<?php
									$prev_title = get_the_title( $prev_post->ID );
									if ( empty( $prev_title ) ) {
										echo wp_kses( '[' . get_the_date( false, $prev_post->ID ) . ']', 'default' );
									} else {
										echo wp_kses( $prev_title, 'default' );
									}
								?>
							</div>	
						</div>
					</a>
				</div>
			<?php endif; ?>
			</div>
			<?php
		        $blog_page = get_option( 'page_for_posts' ) ;
		        if(! empty( $blog_page ) ) {
		        echo '<a href="' . get_permalink($blog_page) . '" class="stockie-icon-grid">';
		            } else {
		        echo '<a href="/" class="stockie-icon-grid">';
		        }
		        echo '<div class="btn-round"><div class="ion"><div class="icon brand-bg-hover"></div></div></div></a>';
		   ?>
			<div class="vc_col-md-<?php echo esc_attr( $toggle_post_column ); ?> vc_col-xs-6">
				<?php if ( ! empty( $next_post ) ) : ?>
					<div class="postNav_item postNav_item_next">
						<a href="<?php echo esc_url( get_permalink( $next_post ) ); ?>">
							<div class="postNav_item_inner">
								<div class="postNav_item_inner_slug">
									<?php esc_html_e( 'next post', 'stockie' ); ?>
								</div>
								<div class="postNav_item_inner_heading brand-color-hover font-titles">
									<?php
										$next_title = get_the_title( $next_post->ID );
										if ( empty( $next_title ) ) {
											echo wp_kses( '[' . get_the_date( false, $next_post->ID ) . ']', 'default' );
										} else {
											echo wp_kses( $next_title, 'default' );
										}
									?>
								</div>
							</div>
						</a>
						<a href="<?php echo esc_url( get_permalink( $next_post ) ); ?>">
							<div class="postNav_item_arrow btn-round brand-color-hover">
								<i class="ion ion-ios-arrow-forward"></i>
							</div>
						</a>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php endif; ?>