
<?php
	$have_wpml = function_exists( 'icl_get_languages' );
?>

<?php
	if ( $have_wpml ) {
	$languages = icl_get_languages( 'skip_missing=1' );

	if ( !empty( $languages ) ): ?>
		<span class="select-holder -small">
			<?php
				$curr_lang = array();
				if ( !empty( $languages ) ) {
					foreach( $languages as $language ) {
						if( !empty( $language['active'] ) ) {
							$curr_lang = $language; // This will contain current language info.
							break;
						}
					}
					echo '<img class="lang-dropdown-flag" src="' . $curr_lang['country_flag_url'] . '" alt="'.$curr_lang['code'].'" class="icon">';
				}
			?>
			<select class="lang-dropdown -small -flat -hide-search">
				<?php
					$languages = icl_get_languages();
					foreach( $languages as $language ) {
						$class = ( $language['active'] ) ? ' class="active" selected="selected"' : '';
						printf( '<option%s value="%s"><img src="%s" alt="%s">%s</option>', $class, $language['url'],
						$language['country_flag_url'], $language['code'], $language['native_name'] );
					}
				?>
			</select>
		</span>
	<?php endif; ?>

<?php } ?>