<?php
	// Settings
	$show_header_title = StockieSettings::header_title_is_displayed();
	$header_subtitle_type = StockieSettings::header_subtitle_type();
	$show_header_subtitle = (bool) ( $header_subtitle_type != 'without' );
	$show_header_cap = StockieSettings::header_cap_is_displayed();
	$header_subtitle_custom_text = StockieSettings::header_subtitle_custom_text();
	$full_height = StockieSettings::header_title_is_full_height();
	$full_height_class = ( $full_height ) ? ' title-full' : '';

	$title_align = StockieSettings::header_title_align();
	$title_align_class = '';
	if ( $title_align == 'left' ) {
		$title_align_class = ' text-left';
	} elseif ( $title_align == 'right' ) {
		$title_align_class = ' text-right';
	} else {
		$title_align_class = ' text-center';
	}

	$page_wrapped = StockieSettings::page_is_wrapped();

	//Cart 
	$is_cart_empty = false;

	// Title and subtitle
	$title_text = get_the_title();
	$subtitle_text = wp_kses( StockieSettings::get( 'header_subtitle' ), 'default' );

	if ( StockieSettings::page_is( 'home' ) ) {
		$title_text = esc_html__( 'Blog', 'stockie' );
		$subtitle_text = esc_html__( 'Our recent posts', 'stockie' );
	} else if ( StockieSettings::page_is( 'category' ) ) {
		$title_text = single_cat_title( '', false ); 
		$subtitle_text = esc_html__( 'Category', 'stockie' );
	} elseif ( StockieSettings::page_is( 'tag' ) ) {
		$title_text = single_tag_title( '', false ); 
		$subtitle_text = esc_html__( 'Tag', 'stockie' );
	} elseif ( StockieSettings::page_is( 'search' ) ) {
		$title_text =  esc_html__( 'Search Results for: ', 'stockie' ) . '<span>' . get_search_query() . '</span>';
		$subtitle_text = false;
	} elseif ( is_day() ) {
		$title_text = get_the_time( 'F' ) . ' ' . get_the_time( 'd' ) . ', ' . get_the_time( 'Y' );
		$subtitle_text = 'Posts by date';
	} elseif ( is_month() ) {
		$title_text = get_the_time( 'F' ) . ' ' . get_the_time( 'Y' );
		$subtitle_text = false;
	} elseif ( is_year() ) {
		$title_text = get_the_time( 'Y' );
		$subtitle_text = false;
	} elseif ( StockieSettings::page_is( 'single' ) ) {
		if ( ! $title_text ) {
			$title_text = '[' . get_the_date( get_option( 'date_format' ), $post->ID ) . ']';
		}
		if ( $header_subtitle_type == 'generated' ) {
			ob_start();
			stockie_return_posted_on();
			
			echo ' <b></b>';

			echo ' <span class="comments">';
			printf( esc_html( _nx( '%1$s comment', '%1$s comments', get_comments_number(), 'comments title', 'stockie' ) ),
				esc_html( number_format_i18n( get_comments_number() ) ) );
			echo ' </span>';

			$subtitle_text = ob_get_clean();
		}
		if ( $header_subtitle_type == 'custom' ) {
			$subtitle_text = $header_subtitle_custom_text;
		}
	} elseif ( StockieSettings::page_is( 'project' ) ) {
		if ( ! $title_text ) {
			$title_text = '[' . get_the_date( get_option( 'date_format' ), $post->ID ) . ']';
		}
		$subtitle_text = StockieSettings::get( 'header_subtitle' );
	} elseif ( StockieSettings::page_is( 'author' ) ) {
		$author = get_the_author();
		$title_text = ( $author ) ? $author : esc_html__( 'Undefined', 'stockie' );
		//$subtitle_text = esc_html__( 'Author', 'stockie' );
	} elseif ( StockieSettings::page_is( 'product' ) ) {
		$subtitle_text = wp_kses( StockieSettings::get( 'woocommerce_header_subtitle', 'global' ), 'default' );
	} elseif ( StockieSettings::page_is( 'shop' ) ) {
		$title_text = get_the_title( $post->ID );
	} elseif ( StockieSettings::page_is( 'product_category' ) ) {
		global $wp_query;
		$cat = $wp_query->get_queried_object();
		$title_text = $cat->name;
		//$subtitle_text = esc_html__( 'Product category', 'stockie' );
	} elseif ( StockieSettings::page_is( 'product_tag' ) ) {
		global $wp_query;
		$cat = $wp_query->get_queried_object();
		$title_text = $cat->name;
		//$subtitle_text = esc_html__( 'Product tag', 'stockie' );
	} elseif ( StockieSettings::page_is( 'cart' ) ) {
		
		if ( WC()->cart->get_cart_contents_count() == 0) {
			$is_cart_empty = true;
		}
	} elseif ( StockieSettings::page_is( 'page' ) ) {
		$subtitle_text = StockieSettings::get( 'header_subtitle' );
	} elseif ( is_404() ) {
		$title_text = esc_html__( 'Page not found!', 'stockie' );
	}

	// Header previous button

	$previous_btn = StockieSettings::get( 'header_previous_button', 'global' );
	$previous_btn_text = '';

	if ( is_null($previous_btn) ) {
		$previous_btn_text = esc_html__('Back', 'stockie' );
	} else {
		$previous_btn_text = StockieSettings::get( 'header_previous_button_text', 'global' );
	}

	$allowed_html = array(
		'a' => array(
			'href' => array(),
			'title' => array()
		),
		'br' => array(),
		'em' => array(),
		'b' => array(),
	);
?>

<?php if ( $show_header_title ) : ?>
<div class="header-title<?php if ( ! $show_header_cap ) { echo ' without-cap'; } echo esc_attr( $full_height_class ) . esc_attr( $title_align_class ); ?>">
	<div class="bg-image"></div>
	<div class="header-title-content">
		<div class="page-container<?php if ( !$page_wrapped ) { echo esc_attr(' full'); } ?>">
			<?php if ( $previous_btn ): ?>
			<div class="back-link">
				<a href="<?php echo $is_cart_empty ? get_permalink( wc_get_page_id( 'shop' ) ) : wp_get_referer(); ?>" class="btn btn-link">
					<i class="ion-left ion ion-ios-arrow-back"></i>
					<?php echo esc_html($previous_btn_text) ?>
				</a>
			</div>
			<?php endif; ?>
			<?php
				/* translators: used between list items, there is a space after the comma */
				if (! is_home() && ! is_category() ) {

					$categories_list = get_the_category_list( ' ' );
					if ( $categories_list && stockie_categorized_blog() ) {
						$categories_list = preg_replace( '/(<a)(.+?>)/i', '$1 class="tag brand-bg-color" $2 ', $categories_list );
						printf( '<div class="tags">%1$s</div>', $categories_list ); // WPCS: XSS OK.
					}
				}
			?>
			<h1 class="page-title"><?php echo wp_kses( $title_text, 'default' ); ?></h1>
			<?php if ( $subtitle_text && $show_header_subtitle ) : ?>
				<div class="subtitle"><?php echo wp_kses( $subtitle_text, $allowed_html ); ?></div>
			<?php endif; ?>
		</div>
	</div>
</div> <!-- .header-title -->
<?php endif;