<?php
	// Settings
	$menu_type = StockieSettings::menu_type();
	$have_woocomerce = function_exists( 'WC' );
	$have_woocomerce_wl = function_exists( 'YITH_WCWL' );
	$have_wpml = function_exists( 'icl_get_languages' );
	$wpml_show_in_header = StockieSettings::get( 'wpml_show_in_header', 'global' );
	$wpml_show_in_header = ( $wpml_show_in_header === false ) ? false : true;
	$mobile_social_position = StockieSettings::get( 'header_mobile_social_position', 'global' );
	$dropdown_carets_visibility = StockieSettings::get( 'header_counters_visibility', 'global' );
	$mobile_menu_position = StockieSettings::get( 'mobile_menu_position', 'global' );
	
	$site_navigation_class = '';
	if ( $menu_type == 'hamburger' ) {
		$site_navigation_class .= ' hidden';
	}
	if ( $mobile_menu_position == 'right' ) {
		$site_navigation_class .= ' slide-right';
	}
	if ( $dropdown_carets_visibility == false ) {
		$site_navigation_class .= ' without-counters';
	}
?>

<nav id="site-navigation" class="main-nav<?php echo esc_attr( $site_navigation_class ); ?>">

	<!-- Mobile overlay -->
	<div class="mbl-overlay">
		<div class="mbl-overlay-bg"></div>

		<!-- Close bar -->
		<div class="close close-bar">
			<div class="close-bar-btn btn-round round-animation" tabindex="0">
				<i class="ion ion-android-close"></i>
			</div>
		</div>
		<div class="mbl-overlay-container">

			<!-- Navigation -->
			<div id="mega-menu-wrap" class="main-nav-container">
				<?php
					if ( StockieSettings::get('extended_menu', 'global') ) {
						wp_nav_menu( array( 'menu' => StockieSettings::get('extended_menu', 'global'), 'menu_id' => 'primary-menu' ) );
					} else {
                        if ( has_nav_menu( 'primary' ) ) {
                            wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'secondary-menu' ) );
                        } else {
                            echo '<span class="menu-not-assigned -blank-menu">' . sprintf( esc_html__( 'Please, %1$s assign a menu %2$s', 'stockie' ), '<a target="_blank" href="' . esc_url( home_url( '/' ) ) . 'wp-admin/nav-menus.php">', '</a>' ) . '</span>';
                        }
					}
				?>
			</div>

			<!-- Lang switcher -->
			<?php get_template_part('parts/elements/language-dropdown');?>
		
			<!-- Copyright -->
			<div class="copyright">
				<?php echo wp_kses( StockieSettings::get( 'footer_copyright_left', 'global' ), 'post' ); ?><br>
				<?php echo wp_kses( StockieSettings::get( 'footer_copyright_right', 'global' ), 'post' ); ?>
			</div>

			<!-- Social links -->
			<?php if ( $mobile_social_position == 'inside' ) : ?>

				<?php get_template_part( 'parts/elements/social-networks' ); ?>
				
			<?php endif; ?>
		</div>
	</div>
</nav>
