<?php
	$logo = StockieSettings::get_logo();
	$logo_for_fixed = StockieSettings::get_logo( false, true );
	$logo_as_image = is_array( $logo );
	$logo_for_fixed_as_image = is_array( $logo_for_fixed );

	$logo_for_onepage = StockieSettings::get_logo_for_onepage();

	$show_search = ! StockieSettings::get( 'header_hide_search', 'global' );
	$header_style = StockieSettings::header_menu_style();

	$logo_text = StockieSettings::get( 'branding_text_logo', 'global' );
	if ( $logo_text == NULL ) {
		$logo_text = get_bloginfo( 'name' );
	} 
?>

<div class="site-branding <?php if ( $logo == "sitename" || $logo === NULL ) { echo 'text-logo'; } ?>">
	<div class="site-title">
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
			<div class="logo<?php if ( $logo_as_image && $logo['mobile'] ) { echo ' with-mobile'; } ?>">
				<?php if ( $logo_as_image && ( $logo['default'] || $logo['retina'] ) ) : ?>
					<img src="<?php echo esc_url( ( $logo['default'] ) ? $logo['default'] : $logo['retina'] ); ?>" <?php if ( $logo['have_vector'] ) { echo ' class="svg-logo"'; } ?><?php if ( $logo['retina'] ) { echo ' srcset="' . $logo['retina'] . ' 2x"'; } ?> alt="<?php echo esc_attr( $logo_text ); ?>">
				<?php else : ?>
					<?php echo esc_html( $logo_text ); ?>
				<?php endif; ?>
			</div>
			<div class="fixed-logo">
				<?php if ( $logo_for_fixed_as_image && ( $logo_for_fixed['default'] || $logo_for_fixed['retina'] ) ) : ?>
					<img src="<?php echo esc_url( ( $logo_for_fixed['default'] ) ? $logo_for_fixed['default'] : $logo_for_fixed['retina'] ); ?>" <?php if ( $logo_for_fixed['have_vector'] ) { echo ' class="svg-logo"'; } ?><?php if ( $logo_for_fixed['retina'] ) { echo ' srcset="' . $logo_for_fixed['retina'] . ' 2x"'; } ?> alt="<?php echo esc_attr( $logo_text ); ?>">
				<?php else : ?>
					<?php echo esc_html( $logo_text ); ?>
				<?php endif; ?>
			</div>
			<?php if ( $logo_as_image && $logo['mobile'] ) : ?>
			<div class="mobile-logo">
				<img src="<?php echo esc_url( $logo['mobile'] ); ?>" class="<?php if ( $logo['have_vector'] ) { echo ' svg-logo'; } ?> alt="<?php echo esc_attr( $logo_text ); ?>">
			</div>
			<?php endif; ?>
			<?php if ( $logo_for_fixed_as_image && $logo_for_fixed['mobile'] ) : ?>
			<div class="fixed-mobile-logo">
				<img src="<?php echo esc_url( $logo_for_fixed['mobile'] ); ?>" class="<?php if ( $logo_for_fixed['have_vector'] ) { echo ' svg-logo'; } ?>" alt="<?php echo esc_attr( $logo_text ); ?>">
			</div>
			<?php endif; ?>
			<div class="for-onepage">
				<span class="dark hidden">
					<?php if ( $logo_for_onepage['dark'] || $logo_for_onepage['dark_retina'] ) : ?>
						<img src="<?php echo esc_url( ( $logo_for_onepage['dark'] ) ? $logo_for_onepage['dark'] : $logo_for_onepage['dark_retina'] ); ?>" <?php if ( $logo_for_onepage['have_vector'] ) { echo ' class="svg-logo"'; } ?><?php if ( $logo_for_onepage['dark_retina'] ) { echo ' srcset="' . $logo_for_onepage['dark_retina'] . ' 2x"'; } ?> alt="<?php echo esc_attr( $logo_text ); ?>">
					<?php else : ?>
						<?php echo esc_html( $logo_text ); ?>
					<?php endif; ?>
				</span>
				<span class="light hidden">
					<?php if ( $logo_for_onepage['light'] || $logo_for_onepage['light_retina'] ) : ?>
						<img src="<?php echo esc_url( ( $logo_for_onepage['light'] ) ? $logo_for_onepage['light'] : $logo_for_onepage['light_retina'] ); ?>" <?php if ( $logo_for_onepage['have_vector'] ) { echo ' class="svg-logo"'; } ?><?php if ( $logo_for_onepage['light_retina'] ) { echo ' srcset="' . $logo_for_onepage['light_retina'] . ' 2x"'; } ?> alt="<?php echo esc_attr( $logo_text ); ?>">
					<?php else : ?>
						<?php echo esc_html( $logo_text ); ?>
					<?php endif; ?>
				</span>
			</div>
		</a>
	</div>
	<?php if ( $show_search && ( $header_style == 'style6' ) ) : ?>
	<div class="search">
		<a href="#" data-nav-search="true">
			<i class="icon ion ion-android-search brand-color-hover-i"></i>
		</a>
	</div>
	<?php endif; ?>
</div><!-- .site-branding -->