<?php
$logo = StockieSettings::get_logo(false);
switch (StockieSettings::get('fullscreen_menu_style', 'global')) {
    case 'centered':
        $logo = StockieSettings::get_logo(true);
        break;
    case 'split':
        $logo = StockieSettings::get_logo(true);
        break;
}
$logo_as_image = is_array($logo);
$have_wpml = function_exists('icl_get_languages');

$menu_class = '';
switch (StockieSettings::get('fullscreen_menu_style', 'global')) {
    case 'centered':
        $menu_class .= ' centered';
        break;
    case 'split':
        $menu_class .= ' split';
        break;
}
?>

<div class="fullscreen-nav<?php echo esc_attr($menu_class); ?>" id="fullscreen-mega-menu">
    <div class="close close-bar" id="fullscreen-menu-close">
        <div class="close-bar-btn btn-round round-animation" tabindex="0">
            <i class="ion ion-android-close"></i>
        </div>
    </div>
    <div class="fullscreen-nav-wrap">
        <div id="fullscreen-mega-menu-wrap">
            <?php
                if ( StockieSettings::get( 'hamburger_menu', 'global' ) ) {
                    wp_nav_menu( array( 'menu' => StockieSettings::get( 'hamburger_menu' , 'global' ), 'menu_id' => 'secondary-menu' ) );
                } else {
                    if ( has_nav_menu( 'primary' ) ) {
                        wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'secondary-menu' ) );
                    } else {
                        echo '<span class="menu-not-assigned -blank-menu">' . sprintf( esc_html__( 'Please, %1$sassign a menu%2$s', 'stockie' ), '<a target="_blank" href="' . esc_url( home_url( '/' ) ) . 'wp-admin/nav-menus.php">', '</a>' ) . '</span>';
                    }
                }
            ?>
        </div>
    </div>
    <div class="copyright">
        
        <?php get_template_part( 'parts/elements/language-dropdown' ); ?>
        
        <div class="content">
            <?php echo wp_kses( StockieSettings::get( 'footer_copyright_left', 'global' ), 'post' ); ?>
            <br>
            <?php echo wp_kses( StockieSettings::get( 'footer_copyright_right', 'global' ), 'post' ); ?>
        </div>
        
        <?php get_template_part( 'parts/elements/social-networks' ); ?>
    </div>
</div>
