<?php
	$stockie_post = StockieHelper::get_storage_item_data();
	$anim_attrs = '';
	if ( in_array( $stockie_post['animation_type'], array( 'sync', 'async' ) ) ) {
		$anim_attrs .= ' data-aos-once="true"';
		$anim_attrs .= ' data-aos="' . esc_attr( $stockie_post['animation_effect'] ) . '"';
		if ( $stockie_post['animation_type'] == 'async' ) {
			$anim_attrs .= '';
		}
	}

	$blog_grid_class = '';	
	if ( in_array( 'sticky', get_post_class( '', $stockie_post['post_id'] ) ) ) {
		$blog_grid_class .= ' sticky'; 
	}
	if ( $stockie_post['boxed'] ) { 
		$blog_grid_class .= ' boxed'; 
	}
	if ( $stockie_post['media']['blockquote'] ) {
		$blog_grid_class .= ' quote';
	}
	if ( ! $stockie_post['preview'] ) {
		$blog_grid_class .= ' no-preview';
	}
	
?>
<div class="blog-grid grid-2<?php echo esc_attr( $blog_grid_class ); ?>" <?php echo esc_attr( $anim_attrs ); ?>>
	<div class="blog-grid-content">
		<?php if ( $stockie_post['categories'] ) : ?>
		<div class="tags">
			<?php if ( in_array( 'sticky', get_post_class( '', $stockie_post['post_id'] ) ) ) : ?>
				<span class="tag tag-sticky"><?php esc_html_e( 'Featured', 'stockie' ); ?></span>
			<?php endif; ?>
			<?php foreach ($stockie_post['categories'] as $_category) : ?>
				<a class="tag brand-bg-color" href="<?php echo esc_url( get_category_link( $_category->cat_ID ) ); ?>">
					<?php echo esc_html( $_category->name ); ?>
				</a>
			<?php endforeach; ?>
		</div>
		<?php endif; ?>
		<div class="post-details">
			<?php if ( $stockie_post['author'] ) : ?>
			<span class="author"><?php echo esc_html( $stockie_post['author'] ); ?></span>
			<?php endif; ?>
			<?php if ( $stockie_post['date'] ) : ?>
			<span class="date"><?php echo esc_html( $stockie_post['date'] ); ?></span>
			<?php endif; ?>
		</div>
		<h3 class="blog-grid-headline">
			<?php if ( in_array( 'sticky', get_post_class( '', $stockie_post['post_id'] ) ) ) : ?>
                <svg class="sticky-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-up-right-circle" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M1 8a7 7 0 1 0 14 0A7 7 0 0 0 1 8zm15 0A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.854 10.803a.5.5 0 1 1-.708-.707L9.243 6H6.475a.5.5 0 1 1 0-1h3.975a.5.5 0 0 1 .5.5v3.975a.5.5 0 1 1-1 0V6.707l-4.096 4.096z"/>
                </svg>
            <?php endif; ?>
			<a href="<?php echo esc_url( $stockie_post['url'] ); ?>">
				<?php echo esc_html( $stockie_post['title'] ); ?>
			</a>
		</h3>

        <?php
        if (preg_match('/<!--more(.*?)?-->/', $post->post_content)) {
            $allowed_html = array(
                'a' => array(
                    'href'  => true,
                    'title' => true,
                ),
                'br'     => array(),
            );
            ?>
            <p>
                <?php echo wp_kses(get_the_content(), $allowed_html); ?>
            </p>
            <a href="<?php echo esc_url($stockie_post['url']); ?>#more-<?php echo esc_attr($post->ID) ?>" class="btn btn-link brand-color-hover">
                <?php esc_html_e('Read More', 'stockie'); ?> <i class="ion-right ion ion-ios-arrow-forward"></i>
            </a>
        <?php } else { ?>
            <p>
                <?php the_excerpt(); ?>
            </p>
            <a href="<?php echo esc_url($stockie_post['url']); ?>" class="btn btn-link brand-color-hover">
                <?php esc_html_e('Read More', 'stockie'); ?> <i class="ion-right ion ion-ios-arrow-forward"></i>
            </a>
        <?php }
        ?>

	</div>
</div>