<?php /* Template Name: Portfolio page */ ?>

<?php
	$GLOBALS['stockie_icon_fonts'][] = 'my-icon-arr-out';

	get_header();

    global $post;

	$show_breadcrumbs = StockieSettings::breadcrumbs_is_displayed();
	$page_wrapped = StockieSettings::page_is_wrapped();
	$add_content_padding = StockieSettings::page_add_top_padding();

	// Projects count
	$count_projects = wp_count_posts( 'stockie_portfolio' );
	$published_projects = $count_projects->publish;

	if ( get_query_var( 'paged' ) ) { 
		$pagination_page = get_query_var( 'paged' ); 
	} elseif ( get_query_var( 'page' ) ) {
		$pagination_page = get_query_var( 'page' );
	} else {
		$pagination_page = 1;
	}

	// Pagination settings
	$projects_per_page = StockieSettings::get( 'portfolio_projects_per_page' );
	if ( ! $projects_per_page || $projects_per_page < 1 ) {

		$projects_per_page = StockieSettings::get( 'portfolio_projects_per_page', 'global' );
		if ( ! $projects_per_page || $projects_per_page < 1 ) {
			$projects_per_page = 12;
		}
	}

	$projects_offset = ( $pagination_page - 1 ) * $projects_per_page;

	$paginator_current = $pagination_page;
	if ( ! $projects_per_page || $projects_per_page < 1 ) {
		$projects_per_page = 1;
	}
	$paginator_all = ceil( $published_projects / $projects_per_page );

	$pagination_type = StockieSettings::get( 'portfolio_pagination_type' );
	if ( in_array( $pagination_type, array( 'inherit', NULL ) ) ) {
		$pagination_type = StockieSettings::get( 'portfolio_pagination_type', 'global' );
	}
	if ( $pagination_type == NULL ){
		$pagination_type = 'simple';
	}
	$pagination_position = StockieSettings::get( 'portfolio_pagination_position' );
	if ( in_array( $pagination_position, array( 'inherit', NULL ) ) ) {
		$pagination_position = StockieSettings::get( 'portfolio_pagination_position', 'global' );
	}
	if ( $pagination_position == NULL ){
		$pagination_position = 'left';
	}

	// Filter
	$show_filter = StockieSettings::get( 'project_show_filter' );
	if ( in_array( $show_filter, array( 'inherit', NULL ) ) ) {
		$show_filter = StockieSettings::get( 'project_show_filter', 'global' );
		if ( $show_filter ) {
			$show_filter = 'show';
		}
	}

	$show_filter = ( $show_filter == 'show' );

	$filter_align = StockieSettings::get( 'portfolio_filter_align' );

	if ( in_array( $show_filter, array( 'inherit', NULL ) ) ) {
		$filter_align = StockieSettings::get( 'portfolio_filter_align', 'global' );
	}
	if ( ! $filter_align ) {
		$filter_align = 'center';
	}

	$filter_align_class = '';
	switch ( $filter_align ) {
		case 'left':
			$filter_align_class = ' text-left';
			break;
		case 'right':
			$filter_align_class = ' text-right';
			break;
	}

	$metro_style = false;

	// Pagintaion results
	$projects_show_from = ( $projects_offset + 1 <= $published_projects ) ? $projects_offset + 1 : $published_projects ;
	$projects_show_to = $projects_offset + $projects_per_page;
	if ( $projects_show_to > $published_projects ) {
		$projects_show_to = $published_projects;
	}

	$args = array(
		'posts_per_page'	=> $projects_per_page,
		'offset'			=> $projects_offset,
		'category'			=> '',
		'category_name'		=> '',
		'orderby'			=> 'date',
		'order'				=> 'DESC',
		'include'			=> '',
		'exclude'			=> '',
		'meta_key'			=> '',
		'meta_value'		=> '',
		'post_type'			=> 'stockie_portfolio',
		'post_mime_type' 	=> '',
		'post_parent'		=> '',
		'author'			=> '',
		'author_name'		=> '',
		'post_status'		=> 'publish',
		'suppress_filters' 	=> false 
	);
	$projects_array = get_posts( $args );

	// Animation type & effect
	$animation_type = StockieSettings::get( 'portfolio_animation_type' );
	if ( in_array( $animation_type, array( 'inherit', NULL ) ) ) {
		$animation_type = StockieSettings::get( 'portfolio_animation_type', 'global' );
	}
	$animation_effect = StockieSettings::get( 'portfolio_animation_effect' );
	if ( in_array( $animation_effect, array( 'inherit', NULL ) ) ) {
		$animation_effect = StockieSettings::get( 'portfolio_animation_effect', 'global' );
	}

	// Sidebar
	$sidebar_position = StockieSettings::get( 'page_sidebar' );
	if ( in_array( $sidebar_position, array( 'inherit', NULL ) ) ) {
		$sidebar_position = StockieSettings::get( 'portfolio_page_sidebar', 'global' );

		if ( in_array( $sidebar_position, array( 'inherit', NULL ) ) ) {
			$sidebar_position = StockieSettings::get( 'page_sidebar', 'global' );
		}
	}

	$sidebar_page_class = '';
	if ( $sidebar_position == 'left' ) {
		$sidebar_page_class = ' with-left-sidebar';
	}
	if ( $sidebar_position == 'right' ) {
		$sidebar_page_class = ' with-right-sidebar';
	}

	$sidebar_layout = StockieSettings::page_sidebar_layout();
	$sidebar_class = '';
	if ( $sidebar_layout ) {
		$sidebar_class .= ' sidebar-' . $sidebar_layout;
	}

	// Portfolio grid paddings
	$grid_item_style_class = '';
	$posts_without_paddings = StockieSettings::get( 'portfolio_items_without_padding' );
	if ( in_array( $posts_without_paddings, array( 'inherit', NULL ) ) ) {
		$posts_without_paddings = StockieSettings::get( 'portfolio_items_without_padding', 'global' );
	}

	if ( ( is_bool( $posts_without_paddings ) && $posts_without_paddings ) || $posts_without_paddings == 'yes' ) {
		$grid_item_style_class .= ' post-offset ';
	} else {
		$grid_item_style_class .= ' with-padding ';
	}

	// Page container class
	$page_container_class = '';
	if ( !$show_breadcrumbs && $add_content_padding ) {
		$page_container_class .= ' without-breadcrumbs'; 
	}
	if ( !$page_wrapped ) {
		$page_container_class .= ' full';
	}
	if ( $add_content_padding ) {
		$page_container_class .= ' bottom-offset';
	}

	// Columns classes
	$columns_num = StockieSettings::get( 'portfolio_columns_in_row' );
	if ( ! isset( $columns_num ) ) {
		$columns_num = 'i-i-i-i';
	}
	$columns_num_global = StockieSettings::get( 'portfolio_columns_in_row', 'global' );
	if ( ! isset( $columns_num_global ) ) {
		$columns_num_global = '4-3-2-1';
	}

	$columns_class = StockieHelper::parse_columns_to_css( $columns_num, false, $columns_num_global );
	$columns_double_class = StockieHelper::parse_columns_to_css( $columns_num, true, $columns_num_global );

	$columns_in_row = explode( '-', $columns_num );
	if ( is_array( $columns_in_row ) ) {
		$columns_in_row = intval( $columns_in_row[0] );
	}


	// Portfolio layout type
	$projects_layout_item = StockieSettings::get( 'portfolio_item_layout_type' );
	if ( ! $projects_layout_item || $projects_layout_item == 'inherit' ) {
		$projects_layout_item = StockieSettings::get( 'portfolio_layout', 'global' );
	}

	if ( $projects_layout_item == NULL ) {
		$projects_layout_item = 'grid_1';
	}

	$projects_layout_hover = 'hover_1';
	if ( $projects_layout_item == 'grid_1' ) {
		$projects_layout_hover = StockieSettings::get( 'portfolio_grid_1_hover' );
		$template_layout = StockieSettings::get( 'portfolio_item_layout_type' );
		if ( $template_layout == NULL || $template_layout == 'inherit' || ! $projects_layout_hover || $projects_layout_hover == 'inherit' ) {
			$projects_layout_hover = StockieSettings::get( 'portfolio_grid_1_hover', 'global' );
		}
	}
	else if ( $projects_layout_item == 'grid_2' ) {
		$projects_layout_hover = StockieSettings::get( 'portfolio_grid_2_hover' );
		$template_layout = StockieSettings::get( 'portfolio_item_layout_type' );
		if ( $template_layout == NULL || $template_layout == 'inherit' || ! $projects_layout_hover || $projects_layout_hover == 'inherit' ) {
			$projects_layout_hover = StockieSettings::get( 'portfolio_grid_2_hover', 'global' );
		}
	}
	if ( $projects_layout_hover == NULL ) {
		$projects_layout_hover = 'hover_1';
	}


    $content_location = StockieSettings::get( 'portfolio_content_position', 'global' );
    if ($content_location == NULL) {
        $content_location = 'top';
    }
?>

<?php get_template_part( 'parts/elements/header-title' ); ?>

<?php get_template_part( 'parts/elements/breadcrumbs' ); ?>

<div class="page-container<?php echo esc_attr( $page_container_class ); ?>">
	<div id="primary" class="content-area">

		<?php if ( $sidebar_position == 'left' ) : ?>
		<div class="page-sidebar sidebar-left<?php echo esc_attr( $sidebar_class ); ?>">
			<aside id="secondary" class="widget-area">
				<?php dynamic_sidebar( 'stockie-sidebar-blog' ); ?>
			</aside>
		</div>
		<?php endif; ?>

		<div class="page-content<?php echo esc_attr( $sidebar_page_class ); ?>">
			<main id="main" class="site-main" data-stockie-portfolio-grid="true">

                <!-- Custom content -->
                <?php
                if ($content_location == 'top'):
                    if(have_posts()) :
                        echo '<div class="page_content portfolio_page_content">';
                        while(have_posts()) : the_post();
                            the_content();
                        endwhile;
                        echo '</div>';
                    endif;
                endif;
                ?>

					<div data-stockie-portfolio-grid="true">
						<?php if ( $show_filter ) : ?>
							<?php $cat_ids = get_terms( array( 'taxonomy' => 'stockie_portfolio_category' ) ); ?>
							<?php if ( is_array( $cat_ids ) && $cat_ids ) : ?>
								<div class="portfolio-sorting<?php echo esc_attr( $filter_align_class ); ?>" data-filter="portfolio">
									<ul class="unstyled font-titles">
										<li>
											<a class="active" href="#all" data-isotope-filter="*">
												<span class="name"><?php esc_html_e( 'All', 'stockie' ); ?></span>
												<span class="num"></span>
											</a>
										</li>
										<?php foreach ( $cat_ids as $cat_obj ) : ?>
											<li>
												<a href="#<?php echo esc_attr( $cat_obj->slug ); ?>" data-isotope-filter=".stockie-filter-project-<?php echo hash( 'md4', $cat_obj->slug, false ); ?>">
													<span class="name"><?php echo esc_html( $cat_obj->name ); ?></span>
													<span class="num"></span>
												</a>
											</li>
										<?php endforeach; ?>
									</ul>
								</div>
							<?php endif; ?>
						<?php endif; ?>
						<div class="portfolio-grid" data-isotope-grid="true" data-lazy-container="projects"">
						<?php

						$_post_i = 0;
						foreach ( $projects_array as $_project_index => $_project_object ) {
							$stockie_project = StockieObjectParser::parse_to_project_object( $_project_object );
							$stockie_project['metro_style'] = $metro_style;
							StockieHelper::set_storage_item_data( $stockie_project );

							$col_class = $columns_class;
							if ( $stockie_project['grid_style'] == '2col' ) {
								$col_class = $columns_double_class;
							}
							// Animation calculating
							$_anim_attrs = '';
							if ( in_array( $animation_type, array( 'sync', 'async' ) ) ) {
								$_anim_attrs .= ' data-aos-once="true"';
								$_anim_attrs .= ' data-aos="' . $animation_effect . '"';
								if ( $animation_type == 'async' && $columns_in_row ) {
									$columns_in_row = (int) substr( $columns_in_row, 0, 1);
									$_delay = ( 400 / $columns_in_row ) * ( $_post_i % $columns_in_row );
									$_delay = (int) $_delay - ( $_delay % 50 );
									$_anim_attrs .= ' data-aos-delay="' . $_delay . '"';
								}
							}
							echo '<div class="portfolio-item-wrap' . esc_attr( $col_class ) . ' stockie-project-item ' . (( $stockie_project['grid_style'] != '2col' ) ? ' grid-item' : '') . ' ' . esc_attr( $grid_item_style_class  . $stockie_project['categories_group'] ) . '" data-lazy-item="" data-lazy-scope="projects">';
							if ( $_anim_attrs ) {
								echo '<div' . $_anim_attrs . '>';
							}

							switch ( $projects_layout_item ) {
								case 'grid_1':
									get_template_part( 'parts/portfolio-cards/grid_1_' . $projects_layout_hover );
									break;
									case 'grid_2':
										get_template_part( 'parts/portfolio-cards/grid_2_' . $projects_layout_hover );
										break;
									default:
										get_template_part(  'parts/portfolio-cards/grid_1_hover_1' );
										break;
							}
							echo '</div>';

							$_post_i++;

							if ( $_anim_attrs ) {
								echo '</div>';
							}
						}

						?>
						</div>
						<?php
							if ( $paginator_all > 1 ) {
								$large_number = 10000000;
								$paginator_pattern = str_replace( $large_number, '{{page}}', get_pagenum_link( $large_number ) );

								switch ( $pagination_type ) {
									case 'simple':
										StockieLayout::the_paginator_layout( $pagination_page, $paginator_all, $pagination_position );
										break;
								 	case 'lazy_scroll':
										echo '<div class="lazy-load loading font-titles text-' . $pagination_position . '" data-lazy-load="scroll" data-lazy-pages-count="' . esc_attr( $paginator_all ) . '" data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" data-lazy-load-scope="projects">';
										echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie' ) . '</span>';
										echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
										echo '</div>';
										break;
									case 'lazy_button':
										echo '<div class="lazy-load load-more font-titles text-' . $pagination_position . '" data-lazy-load="click" data-lazy-pages-count="' . esc_attr( $paginator_all ) . ' data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" data-lazy-load-scope="projects">';
										echo '<span class="loadmore-text">' . esc_html__( 'Load more', 'stockie' ) . '</span>';
										echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie' ) . '</span>';
										echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
										echo '</div>';
										break;
								}
							}
						?>

					</div>

                <!-- Custom content -->
                <?php if ($content_location == 'bottom'):
                    if(have_posts()) :
                        echo '<div class="page_content portfolio_page_content">';
                        while(have_posts()) : the_post();
                            the_content();
                        endwhile;
                        echo '</div>';
                    endif;
                endif; ?>

			</main>
		</div>

		<?php if ( $sidebar_position == 'right' ) : ?>
		<div class="page-sidebar sidebar-right<?php echo esc_attr( $sidebar_class ); ?>">
			<aside id="secondary" class="widget-area">
				<?php dynamic_sidebar( 'stockie-sidebar-blog' ); ?>
			</aside>
		</div>
		<?php endif; ?>

	</div><!-- #primary -->
</div><!--.page-container-->
	
<?php get_footer();