<?php

function stockie_ocdi_import_files() {
	return array(
		array(
			'import_file_name' => 'Engaging Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo1',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/01/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/01/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/01/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/01/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo1.jpg',
		),
		array(
			'import_file_name' => 'Minimal Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo2',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/02/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/02/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/02/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/02/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo2.jpg',
		),
		array(
			'import_file_name' => 'Carousel Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo3',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/03/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/03/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/03/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/03/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo3.jpg',
		),
		array(
			'import_file_name' => 'Fashion Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo4',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/04/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/04/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/04/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/04/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo4.jpg',
		),
		array(
			'import_file_name' => 'Classic Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo5',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/05/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/05/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/05/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/05/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo5.jpg',
		),
		array(
			'import_file_name' => 'Elegant Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo6',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/06/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/06/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/06/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/06/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo6.jpg',
		),
		array(
			'import_file_name' => 'Split Slider Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo7',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/07/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/07/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/07/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/07/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo7.jpg',
		),
		array(
			'import_file_name' => 'Traditional Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo8',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/08/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/08/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/08/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/08/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo8.jpg',
		),
		array(
			'import_file_name' => 'Onepage Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo9',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/09/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/09/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/09/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/09/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo9.jpg',
		),
		array(
			'import_file_name' => 'Clean Store',
			'preview_url'  => 'https://stockie.clbthemes.com/demo10',
			'categories' => array( esc_html__( 'Demo', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/10/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/10/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/10/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/10/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo10.jpg',
		),
		array(
			'import_file_name' => 'Coming Soon',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/coming-soon/',
			'categories' => array( esc_html__( 'Coming Soon', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/11/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/11/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/11/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/11/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo11.jpg'
		),
		array(
			'import_file_name' => 'About - Minimal',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/about-minimal/',
			'categories' => array( esc_html__( 'About', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/20/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/20/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/20/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/20/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout1.jpg'
		),
		array(
			'import_file_name' => 'About - Classic',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/about-classic/',
			'categories' => array( esc_html__( 'About', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/21/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/21/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/21/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/21/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout2.jpg'
		),
		array(
			'import_file_name' => 'About - Studio',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/about-studio/',
			'categories' => array( esc_html__( 'About', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/22/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/22/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/22/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/22/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout3.jpg'
		),
		array(
			'import_file_name' => 'About - Extended',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/about-extended/',
			'categories' => array( esc_html__( 'About', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/23/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/23/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/23/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/23/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout4.jpg'
		),
		array(
			'import_file_name' => 'Contact - Minimal',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/contact-minimal/',
			'categories' => array( esc_html__( 'Contact', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/30/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/30/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/30/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/30/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact1.jpg'
		),
		array(
			'import_file_name' => 'Contact - Classic',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/contact-classic/',
			'categories' => array( esc_html__( 'Contact', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/31/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/31/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/31/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/31/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact2.jpg'
		),
		array(
			'import_file_name' => 'Contact - Blocks',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/contact-blocks/',
			'categories' => array( esc_html__( 'Contact', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/32/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/32/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/32/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/32/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact3.jpg'
		),
		array(
			'import_file_name' => 'Contact - Extended',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/contact-extended/',
			'categories' => array( esc_html__( 'Contact', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/33/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/33/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/33/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/33/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact4.jpg'
		),
		array(
			'import_file_name' => 'Shopping FAQs',
			'preview_url'  => 'https://stockie.clbthemes.com/shopping-faqs/',
			'categories' => array( esc_html__( 'FAQs', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/40/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/40/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/40/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/40/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoFAQ.jpg'
		),
		array(
			'import_file_name' => 'Pricing - Classic',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/pricing-classic/',
			'categories' => array( esc_html__( 'Pricing', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/50/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/50/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/50/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/50/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoPricing1.jpg'
		),
		array(
			'import_file_name' => 'Pricing - One Page',
			'preview_url'  => 'https://stockie.clbthemes.com/pages/pricing-one-page/',
			'categories' => array( esc_html__( 'Pricing', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/51/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/51/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/51/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/51/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoPricing2.jpg'
		),
		array(
			'import_file_name' => 'Forms - Contact Form 7',
			'preview_url'  => '',
			'categories' => array( esc_html__( 'Contact Forms', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/70/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/70/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/70/options.json',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoForms.jpg'
		),
		array(
			'import_file_name' => 'Shortcodes',
			'preview_url'  => '',
			'categories' => array( esc_html__( 'Shortcodes', 'stockie' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/80/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/80/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/80/options.json',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoSC.jpg'
		)
	);
}

add_filter( 'pt-ocdi/import_files', 'stockie_ocdi_import_files' );

function stockie_ocdi_after_import_setup( $selected_import ) {
	global $wpdb;

	$front_page_id = get_page_by_title( str_replace( esc_html( '&' ), 'n', $selected_import['import_file_name'] ) );

	if ( $selected_import['import_file_name'] === 'Classic Blog' ) { // i don't know why
		$front_page_id = get_page_by_title( 'Blog Classic' );
	}

	if ( isset( $front_page_id ) and is_object( $front_page_id ) ) {
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
	}

	// Set menu
	$main_menu = wp_get_nav_menus();
	if ( is_array( $main_menu ) && count( $main_menu ) > 0 ) {
		$main_menu = $main_menu[0];
	}
	if ( is_object( $main_menu ) ) {
		$locations = get_theme_mod('nav_menu_locations');
		$locations['primary'] = $main_menu->term_id;
		set_theme_mod( 'nav_menu_locations', $locations );
	}

	// VC background images fix
	$site_url = get_site_url();
	$wpdb->query( $wpdb->prepare( 'UPDATE ' . $wpdb->postmeta . ' SET meta_value = REPLACE( meta_value, \'{{this_domain}}\', %s )', $site_url ) );
	$wpdb->query( $wpdb->prepare( 'UPDATE ' . $wpdb->posts . ' SET post_content = REPLACE( post_content, \'{{this_domain}}\', %s )', $site_url ) );

	// Update stockie portfolio categories count
	$wpdb->query( $wpdb->prepare( 'UPDATE ' . $wpdb->term_taxonomy . ' SET count = ( 
		SELECT COUNT(*) FROM ' . $wpdb->term_relationships . ' rel 
		LEFT JOIN ' . $wpdb->posts . ' po ON (po.ID = rel.object_id) 
		WHERE rel.term_taxonomy_id = ' . $wpdb->term_taxonomy . '.term_taxonomy_id 
		AND ' . $wpdb->term_taxonomy . '.taxonomy NOT IN (%s) 
		AND po.post_status IN (%s, %s))', 'link_category', 'publish', 'future' ) );
}

add_action( 'pt-ocdi/after_import', 'stockie_ocdi_after_import_setup' );