<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_592fd650bf099",
        "title" => __( 'Portfolio Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_591b002d4818cffmod",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592fd651216b4",
                "label" => __( 'Portfolio layout', 'stockie' ),
                "name" => "portfolio_item_layout_type",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for portfolio items', 'stockie' ),
                "conditional_logic" => 0,
                "default_value" => "inherit",
                "image_option_value" => [
                    [
                        "name" => "inherit",
                        "description" => __( 'Use from Theme Settings', 'stockie' ),
                        "src" => "acf__image_inherited.svg" 
                    ],
                    [
                        "name" => "grid_2",
                        "description" => __( 'Classic', 'stockie' ),
                        "src" => "acf__image_24.svg"
                    ],
                    [
                        "name" => "grid_1",
                        "description" => __( 'Minimal', 'stockie' ),
                        "src" => "acf__image_34.svg"
                    ]
                ]
            ],
            [
                "key" => "field_5123412342456234",
                "label" => __( 'Hover effect', 'stockie' ),
                "name" => "global_portfolio_grid_1_hover",
                "type" => "image_option",
                "instructions" => __( 'Choose hover layout for portfolio items', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd651216b4",
                            "operator" => "==",
                            "value" => "grid_1"
                        ]
                    ]
                ],
                "image_option_value" => [
                    [
                        "name" => "hover_1",
                        "description" => __( 'Centered Details', 'stockie' ),
                        "src" => "acf__image_37.svg"
                    ],
                    [
                        "name" => "hover_2",
                        "description" => __( 'Side Details', 'stockie' ),
                        "src" => "acf__image_21.svg"
                    ]
                ]
            ],
            [
                "key" => "field_59fa41123235te2345",
                "label" => __( 'Hover effect', 'stockie' ),
                "name" => "global_portfolio_grid_2_hover",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for portfolio items', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd651216b4",
                            "operator" => "==",
                            "value" => "grid_2"
                        ]
                    ]
                ],
                "image_option_value" => [
                    [
                        "name" => "hover_1",
                        "description" => "Image Opacity",
                        "src" => "acf__image_35.svg"
                    ],
                    [
                        "name" => "hover_2",
                        "description" => "Overlay Button",
                        "src" => "acf__image_36.svg"
                    ]
                ]
            ],
            [
                "key" => "field_592fd65121a9b",
                "label" => __( 'Grid spacing', 'stockie' ),
                "name" => "portfolio_items_without_padding",
                "type" => "radio",
                "instructions" => __( 'Remove spacing between grid items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "default_value" => ["inherit"],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592fd65120ece",
                "label" => __( 'Portfolio items per row', 'stockie' ),
                "name" => "portfolio_columns_in_row",
                "type" => "stockie_columns",
                "instructions" => __( 'Choose number of portfolio items per row', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "default_value" => "i-i-i-i",
                "use_inherit" => true
            ],
            [
                "key" => "field_592d60af8a7ffmo6467ds",
                "label" => __( 'Grid animation', 'stockie' ),
                "name" => "portfolio_animation_type",
                "type" => "select",
                "instructions" => __( 'Choose grid animation type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "default" => __( 'Disable Animation', 'stockie' ),
                    "sync" => __( 'Sync Animation', 'stockie' ),
                    "async" => __( 'Async Animation', 'stockie' )
                ],
                "default_value" => ["inherit"],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d60af8ac17d27mo646ds",
                "label" => __( 'Grid animation effect', 'stockie' ),
                "name" => "portfolio_animation_effect",
                "type" => "select",
                "instructions" => __( 'Choose portfolio items appear effect', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d60af8a7ffmo6467ds",
                            "operator" => "!=",
                            "value" => "default"
                        ],
                        [
                            "field" => "field_592d60af8a7ffmo6467ds",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "fade-up" => __( 'Fade Up', 'stockie' ),
                    "fade-down" => __( 'Fade Down', 'stockie' ),
                    "fade-right" => __( 'Fade Right', 'stockie' ),
                    "fade-left" => __( 'Fade Left', 'stockie' ),
                    "flip-up" => __( 'Flip Up', 'stockie' ),
                    "flip-down" => __( 'Flip Down', 'stockie' ),
                    "zoom-in" => __( 'Zoom In', 'stockie' ),
                    "zoom-out" => __( 'Zoom Out', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fd65121a9b",
                "label" => __( 'Grid spacing', 'stockie' ),
                "name" => "portfolio_items_without_padding",
                "type" => "radio",
                "instructions" => __( 'Remove spacing between grid items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "default_value" => ["inherit"],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_591b002d4819cffmod",
                "label" => __( 'Portfolio Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592fd651222a5",
                "label" => __( 'Category filter', 'stockie' ),
                "name" => "project_show_filter",
                "type" => "radio",
                "instructions" => __( 'Show category filter on portfolio page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "show" => __( 'Show', 'stockie' ),
                    "hide" => __( 'Hide', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592fd651222a5_tcol",
                "label" => __( 'Category filter text color', 'stockie' ),
                "name" => "project_filter_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose category filter text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd651222a5",
                            "operator" => "!=",
                            "value" => "hide"
                        ]
                    ]
                ],
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_592fd651222a5_acol",
                "label" => __( 'Category filter accent color', 'stockie' ),
                "name" => "project_filter_accent_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose category filter accent color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd651222a5",
                            "operator" => "!=",
                            "value" => "hide"
                        ]
                    ]
                ],
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_592fd6512267d",
                "label" => __( 'Category filter position', 'stockie' ),
                "name" => "portfolio_filter_align",
                "type" => "select",
                "instructions" => __( 'Choose category filter position for portfolio page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd651222a5",
                            "operator" => "!=",
                            "value" => "hide"
                        ]
                    ]
                ],
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fd651212c8",
                "label" => __( 'Portfolio items per page', 'stockie' ),
                "name" => "portfolio_projects_per_page",
                "type" => "number",
                "instructions" => __( 'Choose number of portfolio items per page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "placeholder" => "",
                "prepend" => "",
                "append" => __( 'projects', 'stockie' ),
                "min" => 1,
                "max" => 250,
                "step" => 1
            ],
            [
                "key" => "field_592fd65121624",
                "label" => __( 'Pagination', 'stockie' ),
                "name" => "portfolio_pagination_type",
                "type" => "select",
                "instructions" => __( 'Choose pagination type for portfolio page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "simple" => __( 'Simple', 'stockie' ),
                    "lazy_scroll" => __( 'Lazy Load', 'stockie' ),
                    "lazy_button" => __( 'Load More', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59fb4334bgd33615",
                "label" => __( 'Pagination position', 'stockie' ),
                "name" => "portfolio_pagination_position",
                "type" => "select",
                "instructions" => __( 'Choose pagination position for portfolio page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "wrapper" => [
                    "width" => "",
                    "class" => "",
                    "id" => ""
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "page_template",
                    "operator" => "==",
                    "value" => "page-templates/page_for-projects.php"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;