<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_593dd5f5615b0",
        "title" => __( 'Blog Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_591b002d4818sffmod",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593dd5f56bae0",
                "label" => __( 'Blog layout', 'stockie' ),
                "name" => "blog_item_layout_type",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for blog grid', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "inherit",
                        "description" => __( 'Use from Theme Settings', 'stockie' ),
                        "src" => "acf__image_inherited.svg"
                    ],
                    [
                        "name" => "classic",
                        "description" => __( 'Classic', 'stockie' ),
                        "src" => "acf__image_24.svg"
                    ],
                    [
                        "name" => "simple",
                        "description" => __( 'Simple', 'stockie' ),
                        "src" => "acf__image_25.svg"
                    ],
                    [
                        "name" => "overlay",
                        "description" => __( 'Overlay', 'stockie' ),
                        "src" => "acf__image_25.1.svg"
                    ]
                ],
                "default_value" => "inherit",
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593dd5f56af4c",
                "label" => __( 'Grid layout', 'stockie' ),
                "name" => "blog_page_layout",
                "type" => "radio",
                "instructions" => __( 'Choose grid layout type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "classic" => __( 'Classic', 'stockie' ),
                    "masonry" => __( 'Masonry', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593dd5f56c2b2",
                "label" => __( 'Grid spacing', 'stockie' ),
                "name" => "blog_items_without_padding",
                "type" => "radio",
                "instructions" => __( 'Remove spacing between grid items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59ccb100ba6f7nomod",
                "label" => __( 'Blog categories', 'stockie' ),
                "name" => "blog_categories",
                "type" => "taxonomy",
                "instructions" => __( 'Leave empty if want show all categories', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "taxonomy" => "category",
                "field_type" => "multi_select",
                "allow_null" => 0,
                "add_term" => 0,
                "save_terms" => 0,
                "load_terms" => 0,
                "return_format" => "id",
                "multiple" => 1
            ],
            [
                "key" => "field_592d60af8a7ffmo7ds",
                "label" => __( 'Grid animation', 'stockie' ),
                "name" => "blog_page_animation_type",
                "type" => "radio",
                "instructions" => __( 'Choose grid animation type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "default" => __( 'Disable Animation', 'stockie' ),
                    "sync" => __( 'Sync Animation', 'stockie' ),
                    "async" => __( 'Async Animation', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d60af8ac17d27mo7ds",
                "label" => __( 'Grid animation effect', 'stockie' ),
                "name" => "blog_page_animation_effect",
                "type" => "select",
                "instructions" => __( 'Choose blog items appear effect', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "fade-up" => __( 'Fade Up', 'stockie' ),
                    "fade-down" => __( 'Fade Down', 'stockie' ),
                    "fade-right" => __( 'Fade Right', 'stockie' ),
                    "fade-left" => __( 'Fade Left', 'stockie' ),
                    "flip-up" => __( 'Flip Up', 'stockie' ),
                    "flip-down" => __( 'Flip Down', 'stockie' ),
                    "zoom-in" => __( 'Zoom In', 'stockie' ),
                    "zoom-out" => __( 'Zoom Out', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593dd5f56b310",
                "label" => __( 'Blog items per page', 'stockie' ),
                "name" => "blog_columns_in_row",
                "type" => "stockie_columns",
                "instructions" => __( 'Choose the number of blog items per page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593dd5f56af4c",
                            "operator" => "==",
                            "value" => "masonry"
                        ]
                    ]
                ],
                "default_value" => "i-i-i-i",
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => "",
                "use_inherit" => true
            ],
            [
                "key" => "field_592d60affsafr4gdt25",
                "label" => __( 'Boxed', 'stockie' ),
                "name" => "blog_items_boxed_style",
                "type" => "radio",
                "instructions" => __( 'Use boxed layout post items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593dd5f56bae0",
                            "operator" => "!=",
                            "value" => "overlay"
                        ],
                        [
                            "field" => "field_593dd5f56bae0",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "boxed" => "Boxed",
                    "default" => "Default"
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_591b002d4817sffmod",
                "label" => __( 'Blog Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593dd5f56b70f",
                "label" => __( 'Blog items per page', 'stockie' ),
                "name" => "blog_posts_per_page",
                "type" => "number",
                "instructions" => __( 'Choose the number of blog items per page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => 24,
                "placeholder" => "",
                "prepend" => "",
                "append" => __( 'posts', 'stockie' ),
                "min" => 1,
                "max" => 100,
                "step" => 1
            ],
            [
                "key" => "field_593dd5f56ba30",
                "label" => __( 'Pagination', 'stockie' ),
                "name" => "blog_pagination_type",
                "type" => "select",
                "instructions" => __( 'Choose pagination type for blog page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "simple" => __( 'Simple', 'stockie' ),
                    "lazy_scroll" => __( 'Lazy Load', 'stockie' ),
                    "lazy_button" => __( 'Load More', 'stockie' )
                ],
                "default_value" => [
                    "simple"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
                ],
            [
                "key" => "field_593dd523442330",
                "label" => __( 'Pagination position', 'stockie' ),
                "name" => "blog_pagination_position",
                "type" => "select",
                "instructions" => __( 'Choose pagination type for blog page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => "Left",
                    "center" => "Center",
                    "right" => "Right"
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "page_template",
                    "operator" => "==",
                    "value" => "page-templates/page_for-posts.php"
                ],
                [
                    "param" => "post_type",
                    "operator" => "==",
                    "value" => "page"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;
