<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
		"key" => "group_593dbedc44ab6",
		"title" => __( 'Project Settings', 'stockie' ),
		"private" => true,
		"fields" => [
			[
	            "key" => "field_583be7a6d24291",
	            "label" => __( 'General', 'stockie' ),
	            "name" => "",
	            "type" => "tab",
	            "instructions" => "",
	            "required" => 0,
	            "conditional_logic" => 0,
	            "placement" => "top",
	            "endpoint" => 0
	        ],
			[
	            "key" => "field_593dbedc58835",
	            "label" => __( 'Single project layout', 'stockie' ),
	            "name" => "project_layout_type",
	            "type" => "image_option",
	            "instructions" => __( 'Choose layout type for project page', 'stockie' ),
	            "required" => 0,
	            "conditional_logic" => 0,
	            "image_option_value" => [
	            	[
	                    "name" => "inherit",
	                    "description" => __( 'Use from Theme Settings', 'stockie' ),
	                    "src" => "acf__image_inherited.svg"
	                ],
	                [
	                    "name" => "type_1",
	                    "description" => __( 'Classic with Left Image', 'stockie' ),
	                    "src" => "acf__image_27.svg"
	                ],
	                [
	                    "name" => "type_2",
	                    "description" => __( 'Classic with Right Image', 'stockie' ),
	                    "src" => "acf__image_26.svg"
	                ],
	                [
	                    "name" => "type_3",
	                    "description" => __( 'Split Screen Left Image', 'stockie' ),
	                    "src" => "acf__image_29.svg"
	                ],
	                [
	                    "name" => "type_4",
	                    "description" => __( 'Split Screen Right Image', 'stockie' ),
	                    "src" => "acf__image_28.svg"
	                ],
	                [
	                    "name" => "type_5",
	                    "description" => __( 'Light Details Intro', 'stockie' ),
	                    "src" => "acf__image_30.svg"
	                ]
	            ],
	            "default_value" => "inherit"
	        ],
			[
				"key" => "field_59390deb01d3qewfd",
				"label" => __( 'Content wrapper', 'stockie' ),
				"name" => "page_is_wrapped",
				"type" => "radio",
				"instructions" => __( 'Add content wrapper to this page', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb03738",
							"operator" => "!=",
							"value" => "yes"
						]
					]
				],
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Enable', 'stockie' ),
					"no" => __( 'Disable', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_591b10dbb4a8233rfd345623",
				"label" => __( 'Content wrapper width', 'stockie' ),
				"name" => "content_wrapper_width",
				"type" => "text",
				"instructions" => __( 'Define container wrapper width', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => "",
				"placeholder" => "1326px",
                "prepend" => __( 'Use CSS units', 'stockie' ),
				"append" => "",
				"maxlength" => 200
			],
			[
				"key" => "field_591b10db34fesw4a85_fwgaps_local",
				"label" => __( 'Full-width wrapper side margins', 'stockie' ),
				"name" => "full_width_margins_size",
				"type" => "text",
				"instructions" => __( 'Define side margins for full-width page container', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => "",
				"placeholder" => "",
				"prepend" => __( 'Use CSS units', 'stockie' ),
				"append" => "",
				"maxlength" => 200
			],
			[
				"key" => "field_59390deb03738",
				"label" => __( 'Boxed page layout', 'stockie' ),
				"name" => "page_use_boxed_wrapper",
				"type" => "radio",
				"instructions" => __( 'Wrap this page in boxed container?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Yes', 'stockie' ),
					"no" => __( 'No', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390deb034gghas",
				"label" => __( 'Content padding', 'stockie' ),
				"name" => "page_add_top_padding",
				"type" => "radio",
				"instructions" => __( 'Add top and bottom padding for page content', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Add', 'stockie' ),
					"no" => __( 'No', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_593dbedc5a7fe",
				"label" => __( 'Navigation', 'stockie' ),
				"name" => "project_show_navigation",
				"type" => "radio",
				"instructions" => __( 'Choose portfolio navigation type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "none" => __( 'Without Navigation', 'stockie' ),
                    "prev_n_next" => __( 'Next and Prev', 'stockie' )
                ],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => [
					"inherit"
				],
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
		        "key" => "field_592fd66622a31amodagg",
		        "label" => __( 'Navigation position', 'stockie' ),
		        "name" => "project_navigation_position",
		        "type" => "radio",
		        "instructions" => __( 'Choose portfolio navigation position', 'stockie' ),
		        "required" => 0,
		        "conditional_logic" => 0,
		        "choices" => [
		        	"inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "top" => __( 'Top - Before content', 'stockie' ),
                    "bottom" => __( 'Bottom - After Content', 'stockie' )
                ],
		        "allow_null" => 0,
		        "other_choice" => 0,
		        "save_other_choice" => 0,
		        "default_value" => "simple",
		        "layout" => "horizontal",
		        "return_format" => "value"
	    	],
	    	[
		        "key" => "field_592fd66622a41amodagg",
		        "label" => __( 'Custom content position', 'stockie' ),
		        "name" => "project_custom_content_position",
		        "type" => "select",
		        "instructions" => __( 'Choose custom content position', 'stockie' ),
		        "required" => 0,
		        "conditional_logic" => [
		            [
		                [
		                    "field" => "field_593dbedc5a7fe",
		                    "operator" => "!=",
		                    "value" => "none"
		                ],
		                [
		                    "field" => "field_593dbedc58835",
		                    "operator" => "!=",
		                    "value" => "type_1"
		                ]
		            ]
		        ],
		        "choices" => [
	        		"inherit" => __( 'Use from Theme Settings', 'stockie' ),
		            "top" => __( 'Top - Before Content', 'stockie' ),
		            "after_description" => __( 'Center - After Description', 'stockie' ),
		            "bottom" => __( 'Bottom - After Content', 'stockie' )
		        ],
		        "allow_null" => 0,
		        "other_choice" => 0,
		        "save_other_choice" => 0,
		        "default_value" => "top",
		        "return_format" => "value"
	    	],
			[
				"key" => "field_59390deb23rfdsf",
				"label" => __( 'Background type', 'stockie' ),
				"name" => "page_background_type",
				"type" => "radio",
				"instructions" => __( 'Choose background type for project page', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"color" => __( 'Custom Color', 'stockie' ),
					"custom" => __( 'Custom Image', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390deb035heswd",
				"label" => __( 'Background image', 'stockie' ),
				"name" => "page_background_image",
				"type" => "image",
				"instructions" => __( 'Custom background image', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"return_format" => "url",
				"preview_size" => "thumbnail",
				"library" => "all",
				"min_width" => "",
				"min_height" => "",
				"min_size" => "",
				"max_width" => "",
				"max_height" => "",
				"max_size" => "",
				"mime_types" => ""
			],
			[
				"key" => "field_59390deb023fdsg",
				"label" => __( 'Background image size', 'stockie' ),
				"name" => "page_background_size",
				"type" => "select",
				"instructions" => __( 'Choose background image size type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
				"default_value" => [
					"auto"
				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390deb45hygdfe",
				"label" => __( 'Background image position', 'stockie' ),
				"name" => "page_background_position",
				"type" => "select",
				"instructions" => __( 'Choose background image position', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb023fdsg",
							"operator" => "==",
							"value" => "auto"
						],
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "custom"
						]
					],
					[
						[
							"field" => "field_59390deb023fdsg",
							"operator" => "==",
							"value" => "contain"
						],
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
				"default_value" => [

				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390de56ujgfhn",
				"label" => __( 'Background image repeat', 'stockie' ),
				"name" => "page_background_repeat",
				"type" => "select",
				"instructions" => __( 'Choose background image repeat type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb023fdsg",
							"operator" => "==",
							"value" => "auto"
						],
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "custom"
						]
					],
					[
						[
							"field" => "field_59390deb023fdsg",
							"operator" => "==",
							"value" => "contain"
						],
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
				"default_value" => "",
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390deb034gdfs",
				"label" => __( 'Background attachment', 'stockie' ),
				"name" => "page_background_is_attached",
				"type" => "true_false",
				"instructions" => __( 'You can fix background image on this page', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"message" => "",
				"default_value" => 0,
				"ui" => 1,
				"ui_on_text" => "Yes",
				"ui_off_text" => "No"
			],
			[
				"key" => "field_59390deb0245ydsf",
				"label" => __( 'Background color', 'stockie' ),
				"name" => "page_background_color",
				"type" => "stockie_color",
				"instructions" => __( 'Custom background color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb23rfdsf",
							"operator" => "==",
							"value" => "color"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_59390deaeee3d",
				"label" => __( 'Header', 'stockie' ),
				"name" => "",
				"type" => "tab",
				"instructions" => "",
				"required" => 0,
				"conditional_logic" => 0,
				"placement" => "top",
				"endpoint" => 0
			],
			[
	            "key" => "field_59390deaef21a",
	            "label" => __( 'Header layout', 'stockie' ),
	            "name" => "header_menu_style",
	            "type" => "image_option",
	            "instructions" => __( 'Choose header template', 'stockie' ),
	            "required" => 0,
	            "conditional_logic" => 0,
	            "image_option_value" => [
	                [
                        "name" => "inherit",
                        "description" => __( 'Use from Theme Settings', 'stockie' ),
                        "src" => "acf__image_inherited.svg"
                    ],
                    [
                        "name" => "style1",
                        "description" => __( 'Default', 'stockie' ),
                        "src" => "acf__image_01.svg"
                    ],
                    [
                        "name" => "style3",
                        "description" => __( 'Top Logo', 'stockie' ),
                        "src" => "acf__image_03.svg"
                    ],
                    [
                        "name" => "style4",
                        "description" => __( 'Centered Menu', 'stockie' ),
                        "src" => "acf__image_04.svg"
                    ],
                    [
                        "name" => "style5",
                        "description" => __( 'Centered Logo', 'stockie' ),
                        "src" => "acf__image_05.svg"
                    ],
                    [
                        "name" => "style6",
                        "description" => __( 'Sidebar Menu', 'stockie' ),
                        "src" => "acf__image_06.svg"
                    ],
                    [
                        "name" => "style7",
                        "description" => __( 'Panel Menu', 'stockie' ),
                        "src" => "acf__image_07.svg"
                    ]
	            ],
	            "default_value" => "inherit"
	        ],
			[
				"key" => "field_59390deaef9ea23tfswxq",
				"label" => __( 'Blank spacer under header', 'stockie' ),
				"name" => "header_menu_add_cap",
				"type" => "radio",
				"instructions" => __( 'We recommend use this setting for transparent and fixed header navigation', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Add Spacer', 'stockie' ),
					"no" => __( 'Don\'t Add Spacer', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390deaef623tfqwaadf",
				"label" => __( 'Content wrapper', 'stockie' ),
				"name" => "header_menu_use_wrapper",
				"type" => "radio",
				"instructions" => __( 'Use header content wrapper', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Yes', 'stockie' ),
					"no" => __( 'No', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59411fcf0048f5498hged",
				"label" => __( 'Header styles', 'stockie' ),
				"name" => "header_menu_style_settings",
				"type" => "radio",
				"instructions" => __( 'Define header custom styles', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"custom" => __( 'Custom', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_5941276d098ghbiyj",
				"label" => __( 'Height', 'stockie' ),
				"name" => "header_menu_height",
				"type" => "stockie_responsive_height",
				"instructions" => __( 'Set up header height', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59411fcf0048f5498hged",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_59390dea789t4wklj",
				"label" => __( 'Background color', 'stockie' ),
				"name" => "header_menu_background_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose header background color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59411fcf0048f5498hged",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_59390d83hdjcas",
				"label" => __( 'Typography', 'stockie' ),
				"name" => "header_menu_text_typo",
				"type" => "stockie_typo",
				"instructions" => __( 'Set up typography for header', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59411fcf0048f5498hged",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"add_theme_inherited" => true
			],
			[
				"key" => "field_5941261c699597823y4hf",
				"label" => __( 'Bottom border', 'stockie' ),
				"name" => "header_menu_hide_border",
				"type" => "true_false",
				"instructions" => __( 'Hide bottom border from header?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59411fcf0048f5498hged",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"message" => "",
				"default_value" => 0,
				"ui" => 1,
				"ui_on_text" => "",
				"ui_off_text" => ""
			],
			[
				"key" => "field_594126ed0b89887uyghbas",
				"label" => __( 'Bottom border type', 'stockie' ),
				"name" => "header_menu_border_type",
				"type" => "select",
				"instructions" => __( 'Choose border stroke type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59411fcf0048f5498hged",
							"operator" => "==",
							"value" => "custom"
						],
						[
							"field" => "field_5941261c699597823y4hf",
							"operator" => "!=",
							"value" => "1"
						]
					]
				],
				"choices" => [
                    "solid" => __( 'Solid', 'stockie' ),
                    "dashed" => __( 'Dashed', 'stockie' ),
                    "dotted" => __( 'Dotted', 'stockie' ),
                    "double" => __( 'Double', 'stockie' )
                ],
				"default_value" => [
					"solid"
				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_594127340b89293hfa",
				"label" => __( 'Bottom border color', 'stockie' ),
				"name" => "header_menu_border_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose bottom border color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59411fcf0048f5498hged",
							"operator" => "==",
							"value" => "custom"
						],
						[
							"field" => "field_5941261c699597823y4hf",
							"operator" => "!=",
							"value" => "1"
						]
					]
				],
				"default_value" => ""
			],
			[
	            "key" => "field_5937a0a52ebmod23",
	            "label" => "",
	            "name" => "",
	            "type" => "message",
	            "instructions" => "",
	            "required" => 0,
	            "conditional_logic" => 0,
	            "message" => '<h4>' . __( 'Sticky Header', 'stockie' ) . '</h4>',
	            "new_lines" => "",
	            "esc_html" => 0
	        ],
			[
				"key" => "field_5939023r23aaf1978",
				"label" => __( 'Sticky header', 'stockie' ),
				"name" => "header_menu_fixed",
				"type" => "radio",
				"instructions" => __( 'Enable sticky header, when you scrolling the page', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Yes', 'stockie' ),
					"no" => __( 'No', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
	            "key" => "field_5937af34fsws71ebmod23",
	            "label" => "",
	            "name" => "",
	            "type" => "message",
	            "instructions" => "",
	            "required" => 0,
	            "conditional_logic" => 0,
	            "message" => '<h4>' . __( 'Logo Settings', 'stockie' ) . '</h4>',
	            "new_lines" => "",
	            "esc_html" => 0
	        ],
			[
				"key" => "field_59391a13d6302be45gas",
				"label" => __( 'Brand logo', 'stockie' ),
				"name" => "header_logo_style",
				"type" => "select",
				"instructions" => __( 'Choose logo type for this page', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"dark_variant" => __( 'Dark Variant', 'stockie' ),
					"light_variant" => __( 'Light Variant', 'stockie' ),
					"sitename" => __( 'Text Logo', 'stockie' ),
					"custom" => __( 'Custom Image', 'stockie' )
				],
				"default_value" => [

				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390de17dghaaf09ac",
				"label" => __( 'Text Logo settings', 'stockie' ),
				"name" => "header_menu_sitename_typo",
				"type" => "stockie_typo",
				"instructions" => __( 'Custom setting for text logo typography', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59391a13d6302be45gas",
							"operator" => "==",
							"value" => "sitename"
						]
					]
				],
				"add_theme_inherited" => true
			],
			[
				"key" => "field_59411f821da7d2536",
				"label" => __( 'Custom logo', 'stockie' ),
				"name" => "header_menu_custom_logo",
				"type" => "image",
				"instructions" => __( 'Loaded logo image for this page', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59391a13d6302be45gas",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"return_format" => "url",
				"preview_size" => "thumbnail",
				"library" => "all",
				"min_width" => "",
				"min_height" => "",
				"min_size" => "",
				"max_width" => "",
				"max_height" => "",
				"max_size" => "",
				"mime_types" => ""
			],
			[
	            "key" => "field_5937a12das71ebmod23",
	            "label" => "",
	            "name" => "",
	            "type" => "message",
	            "instructions" => "",
	            "required" => 0,
	            "conditional_logic" => 0,
	            "message" => '<h4>' . __( 'Menu Settings', 'stockie' ) . '</h4>',
	            "new_lines" => "",
	            "esc_html" => 0
	        ],
			[
				"key" => "field_59390deaefde512wd24g",
				"label" => __( 'Menu type', 'stockie' ),
				"name" => "menu_type",
				"type" => "radio",
				"instructions" => __( 'Choose menu type for this page', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"full" => __( 'Regular Menu', 'stockie' ),
					"hamburger" => __( 'Hamburger Menu', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_5941060e2a3ab",
				"label" => __( 'Subheader', 'stockie' ),
				"name" => "",
				"type" => "tab",
				"instructions" => "",
				"required" => 0,
				"conditional_logic" => 0,
				"placement" => "top",
				"endpoint" => 0
			],
			[
				"key" => "field_59390de13odhaks",
				"label" => __( 'Visibility', 'stockie' ),
				"name" => "header_menu_add_contacts_bar",
				"type" => "radio",
				"instructions" => __( 'Show subheader bar on this page?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Show', 'stockie' ),
					"no" => "Hide"
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_5941234030b7ce2f5d",
				"label" => __( 'Subheader styles', 'stockie' ),
				"name" => "header_menu_contacts_bar_style",
				"type" => "radio",
				"instructions" => __( 'Choose subheader style', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"custom" => __( 'Custom', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_5941040a9713r12ashec9",
				"label" => __( 'Height', 'stockie' ),
				"name" => "header_menu_contacts_bar_height",
				"type" => "stockie_responsive_height",
				"instructions" => __( 'Set up subheader height', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_5941234030b7ce2f5d",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_59390deaf2rasd5",
				"label" => __( 'Background color', 'stockie' ),
				"name" => "header_menu_contacts_bar_background",
				"type" => "stockie_color",
				"instructions" => __( 'Choose background color for subheader', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_5941234030b7ce2f5d",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_59390dea23rasfh59e",
				"label" => __( 'Typography', 'stockie' ),
				"name" => "header_menu_contacts_bar_text_typo",
				"type" => "stockie_typo",
				"instructions" => __( 'Set up typography for subheader', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_5941030b7ce5d",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"add_theme_inherited" => true
			],
			[
				"key" => "field_593dbedc55195",
				"label" => __( 'Page Headline', 'stockie' ),
				"name" => "",
				"type" => "tab",
				"instructions" => "",
				"required" => 0,
				"conditional_logic" => 0,
				"placement" => "top",
				"endpoint" => 0
			],
			[
				"key" => "field_59390deb02r3uhjd1",
				"label" => __( 'Visibility', 'stockie' ),
				"name" => "header_use_hero",
				"type" => "radio",
				"instructions" => __( 'Hide page headline from this page?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Hide', 'stockie' ),
					"no" => __( 'Show', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
	            "key" => "field_59390deb0074",
	            "label" => __( 'Fullscreen height', 'stockie' ),
	            "name" => "header_height_fullscreen",
	            "type" => "radio",
	            "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
	            "required" => 0,
	            "conditional_logic" => 0,
	            "choices" => [
	                "inherit" => __( 'Use from Theme Settings', 'stockie' ),
	                "yes" => __( 'Yes', 'stockie' ),
	                "no" => __( 'No', 'stockie' ),
	            ],
	            "allow_null" => 0,
	            "other_choice" => 0,
	            "save_other_choice" => 0,
	            "default_value" => "inherit",
	            "layout" => "horizontal",
	            "return_format" => "value"
	        ],
	        [
	            "key" => "field_59390deb34jnfd9",
	            "label" => __( 'Height', 'stockie' ),
	            "name" => "header_height",
	            "type" => "stockie_responsive_height",
	            "instructions" => __( 'Set up page headline height', 'stockie' ),
	            "required" => 0,
	            "conditional_logic" => [
	                [
	                    [
	                        "field" => "field_59390deb0074",
	                        "operator" => "!=",
	                        "value" => "yes"
	                    ]
	                ]
	            ],
	            "default_value" => ""
	      ],
			[
				"key" => "field_593ddeb756rfuhcb",
				"label" => __( 'Subtitle text', 'stockie' ),
				"name" => "header_subtitle",
				"type" => "text",
				"instructions" => __( 'Custom subtitle text', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => "",
				"placeholder" => "",
				"prepend" => "",
				"append" => "",
				"maxlength" => ""
			],
			[
				"key" => "field_59390de24gfklj4e",
				"label" => __( 'Content position', 'stockie' ),
				"name" => "header_title_align",
				"type" => "radio",
				"instructions" => __( 'Choose page headline content position', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"left" => __( 'Left', 'stockie' ),
					"center" => __( 'Center', 'stockie' ),
					"right" => __( 'Right', 'stockie' )
				],
				"default_value" => [
					"inherit"
				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"layout" => "horizontal",
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390dea3q35gsa",
				"label" => __( 'Background type', 'stockie' ),
				"name" => "header_background_type",
				"type" => "radio",
				"instructions" => __( 'Choose background type for page headline', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"color" => __( 'Background Color', 'stockie' ),
					"image" => __( 'Custom Image', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390dea23f34gedrg5",
				"label" => __( 'Background image', 'stockie' ),
				"name" => "header_background_image",
				"type" => "image",
				"instructions" => __( 'Upload background image for page headline', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						]
					]
				],
				"preview_size" => "thumbnail",
				"library" => "all",
				"return_format" => "url",
				"min_width" => 0,
				"min_height" => 0,
				"min_size" => 0,
				"max_width" => 0,
				"max_height" => 0,
				"max_size" => 0,
				"mime_types" => ""
			],
			[
				"key" => "field_59390deaf34fwsdef",
				"label" => __( 'Background image size', 'stockie' ),
				"name" => "header_background_size",
				"type" => "select",
				"instructions" => __( 'Choose background image size type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						]
					]
				],
				"choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
				"default_value" => [
					"cover"
				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390deaf3134ferg",
				"label" => __( 'Background image position', 'stockie' ),
				"name" => "header_background_position",
				"type" => "select",
				"instructions" => __( 'Choose background image position', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deaf34fwsdef",
							"operator" => "==",
							"value" => "auto"
						],
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						]
					],
					[
						[
							"field" => "field_59390deaf34fwsdef",
							"operator" => "==",
							"value" => "contain"
						],
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						]
					]
				],
				"choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
				"default_value" => [

				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390deaf3534gfds",
				"label" => __( 'Background image repeat', 'stockie' ),
				"name" => "header_background_repeat",
				"type" => "select",
				"instructions" => __( 'Choose background image repeat type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deaf34fwsdef",
							"operator" => "==",
							"value" => "auto"
						],
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						]
					],
					[
						[
							"field" => "field_59390deaf34fwsdef",
							"operator" => "==",
							"value" => "contain"
						],
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						]
					]
				],
				"choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
				"default_value" => [

				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390deaf25845gde",
				"label" => __( 'Background color', 'stockie' ),
				"name" => "header_background_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose background color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "color"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_59390deaf3934gfsdef",
				"label" => __( 'Background overlay', 'stockie' ),
				"name" => "header_use_overlay",
				"type" => "radio",
				"instructions" => __( 'Add colored overlay over background image?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						]
					]
				],
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Yes', 'stockie' ),
					"no" => __( 'No', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390deaf3d34fsdf",
				"label" => __( 'Background overlay color', 'stockie' ),
				"name" => "header_overlay_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose background overlay color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						],
						[
							"field" => "field_59390deaf3934gfsdef",
							"operator" => "==",
							"value" => "inherit"
						]
					],
					[
						[
							"field" => "field_59390dea3q35gsa",
							"operator" => "==",
							"value" => "image"
						],
						[
							"field" => "field_59390deaf3934gfsdef",
							"operator" => "==",
							"value" => "yes"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_593a55746323df23dfsf",
				"label" => __( 'Typography settings', 'stockie' ),
				"name" => "page_typography_settings",
				"type" => "radio",
				"instructions" => __( 'Set up typography for page headline', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"custom" => __( 'Custom', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_593a55daq124v0637fq",
				"label" => __( 'Go back button typography', 'stockie' ),
				"name" => "header_back_typo",
				"type" => "stockie_typo",
				"instructions" => __( 'Set up typography for go back button', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_593a55746323df23dfsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"add_theme_inherited" => true
			],
			[
				"key" => "field_593a55d06334grdf",
				"label" => __( 'Title settings', 'stockie' ),
				"name" => "page_header_title_typo",
				"type" => "stockie_typo",
				"instructions" => __( 'Set up typography for hero titles', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_593a55746323df23dfsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"add_theme_inherited" => true
			],
			[
				"key" => "field_593a56516334fkvdjs",
				"label" => __( 'Subtitle settings', 'stockie' ),
				"name" => "page_header_subtitle_typo",
				"type" => "stockie_typo",
				"instructions" => __( 'Set up typography for subtitles', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_593a55746323df23dfsf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"add_theme_inherited" => true
			],
			[
				"key" => "field_593dc093b6b75",
				"label" => __( 'Breadcrumbs', 'stockie' ),
				"name" => "",
				"type" => "tab",
				"instructions" => "",
				"required" => 0,
				"conditional_logic" => 0,
				"placement" => "top",
				"endpoint" => 0
			],
			[
				"key" => "field_59390deb033234rtgqw3s",
				"label" => __( 'Visibility', 'stockie' ),
				"name" => "page_show_breadcrumbs",
				"type" => "radio",
				"instructions" => __( 'Show breadcrumbs on this page?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Show', 'stockie' ),
					"no" => "Hide"
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_593d618e8yfghjh",
				"label" => __( 'Breadcrumbs background color', 'stockie' ),
				"name" => "breadcrumbs_background_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose breadcrumbs block background color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => ""
			],
			[
				"key" => "field_593db13323iuhfisk",
				"label" => __( 'Breadcrumbs text color', 'stockie' ),
				"name" => "breadcrumbs_text_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose breadcrumbs text color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => ""
			],
			[
				"key" => "field_59390deb044fdas4",
				"label" => __( 'Footer', 'stockie' ),
				"name" => "",
				"type" => "tab",
				"instructions" => "",
				"required" => 0,
				"conditional_logic" => 0,
				"placement" => "top",
				"endpoint" => 0
			],
			[
				"key" => "field_59390deb0879ughi",
				"label" => __( 'Visibility', 'stockie' ),
				"name" => "footer_hide",
				"type" => "radio",
				"instructions" => __( 'Hide footer from this page?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Hide', 'stockie' ),
					"no" => __( 'Show', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390de345gdsfvg",
				"label" => __( 'Content wrapper', 'stockie' ),
				"name" => "footer_is_wrapped",
				"type" => "radio",
				"instructions" => __( 'Add footer content wrapper?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Enable', 'stockie' ),
					"no" => __( 'Disable', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_5940ec915rgsd19",
				"label" => __( 'Content text color', 'stockie' ),
				"name" => "footer_text_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose content text color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => ""
			],
			[
				"key" => "field_59390deb023feryg",
				"label" => __( 'Background type', 'stockie' ),
				"name" => "footer_background_type",
				"type" => "radio",
				"instructions" => __( 'Choose footer background type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"color" => __( 'Custom Color', 'stockie' ),
					"custom" => __( 'Custom Image', 'stockie' )
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390deb0523fasd",
				"label" => __( 'Background image', 'stockie' ),
				"name" => "footer_background_image",
				"type" => "image",
				"instructions" => __( 'Upload background image for footer', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb023feryg",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"return_format" => "url",
				"preview_size" => "medium",
				"library" => "all",
				"min_width" => "",
				"min_height" => "",
				"min_size" => "",
				"max_width" => "",
				"max_height" => 1200,
				"max_size" => "",
				"mime_types" => ""
			],
			[
				"key" => "field_59390deb34gfasdefh",
				"label" => __( 'Background size', 'stockie' ),
				"name" => "footer_background_size",
				"type" => "select",
				"instructions" => __( 'Choose background image size type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb023feryg",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
				"default_value" => [
					"cover"
				],
					"allow_null" => 0,
					"multiple" => 0,
					"ui" => 0,
					"ajax" => 0,
					"return_format" => "value",
					"placeholder" => ""
				],
			[
				"key" => "field_59390deb042wegffhj",
				"label" => __( 'Background position', 'stockie' ),
				"name" => "footer_background_position",
				"type" => "select",
				"instructions" => __( 'Choose background image position', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb023feryg",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
				"default_value" => [

				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_5932gfreheb0638b",
				"label" => __( 'Background repeat', 'stockie' ),
				"name" => "footer_background_repeat",
				"type" => "select",
				"instructions" => __( 'Choose background image repeat type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb023feryg",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
				"default_value" => [
					"repeat"
				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_59390deb046ujty",
				"label" => __( 'Background color', 'stockie' ),
				"name" => "footer_background_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose footer background color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb023feryg",
							"operator" => "!=",
							"value" => "inherit"
						]
					]
				],
				"default_value" => ""
			],
			[
				"key" => "field_59390deb0434tgyherf",
				"label" => __( 'Footer logo widget type', 'stockie' ),
				"name" => "footer_logo_widget_type",
				"type" => "select",
				"instructions" => __( 'Choose widget logo type', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"light_variant" => "Light Variant logo",
					"dark_variant" => __( 'Dark Variant', 'stockie' ),
					"sitename" => "Site name",
					"custom" => __( 'Custom Image', 'stockie' )
				],
				"default_value" => [
					"inherit"
				],
				"allow_null" => 0,
				"multiple" => 0,
				"ui" => 0,
				"ajax" => 0,
				"return_format" => "value",
				"placeholder" => ""
			],
			[
				"key" => "field_5940df23trabfe181",
				"label" => __( 'Footer site name settings', 'stockie' ),
				"name" => "footer_sitename_typo",
				"type" => "stockie_typo",
				"instructions" => __( 'Custom settings for footer site name', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb0434tgyherf",
							"operator" => "==",
							"value" => "sitename"
						]
					]
				],
				"add_theme_inherited" => true
			],
			[
				"key" => "field_5940dfeaf34fsad",
				"label" => __( 'Footer custom logo image', 'stockie' ),
				"name" => "footer_custom_logo",
				"type" => "image",
				"instructions" => __( 'Custom logo image in footer', 'stockie' ),
				"required" => 0,
				"conditional_logic" => [
					[
						[
							"field" => "field_59390deb0434tgyherf",
							"operator" => "==",
							"value" => "custom"
						]
					]
				],
				"return_format" => "url",
				"preview_size" => "thumbnail",
				"library" => "all",
				"min_width" => "",
				"min_height" => "",
				"min_size" => "",
				"max_width" => "",
				"max_height" => "",
				"max_size" => "",
				"mime_types" => ""
			],
			[
				"key" => "field_5939164uhjdgfdef2b",
				"label" => __( 'Sticky footer', 'stockie' ),
				"name" => "footer_as_sticky",
				"type" => "radio",
				"instructions" => __( 'Set sticky (fixed) footer on this page?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Yes', 'stockie' ),
					"no" => __( 'No', 'stockie' ),
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
	            "key" => "field_5937a0a521s8134tgd23",
	            "label" => "",
	            "name" => "",
	            "type" => "message",
	            "instructions" => "",
	            "required" => 0,
	            "conditional_logic" => 0,
	            "message" => '<h4>' . __( 'Copyright Bar', 'stockie' ) . '</h4>',
	            "new_lines" => "",
	            "esc_html" => 0
	        ],
			[
				"key" => "field_59390deb07397",
				"label" => __( 'Copyright section visibility', 'stockie' ),
				"name" => "footer_show_copyright_section",
				"type" => "radio",
				"instructions" => __( 'Show copyright section on this page?', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
					"inherit" => __( 'Use from Theme Settings', 'stockie' ),
					"yes" => __( 'Show', 'stockie' ),
					"no" => "Hide"
				],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "inherit",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_59390de46utgd",
				"label" => __( 'Copyright section background', 'stockie' ),
				"name" => "footer_copyright_section_background",
				"type" => "stockie_color",
				"instructions" => __( 'Choose section background color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => ""
			],
			[
				"key" => "field_59390d45yujtgb67",
				"label" => __( 'Copyright section text color', 'stockie' ),
				"name" => "footer_copyright_section_text_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose section content text color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => ""
			],
			[
				"key" => "field_59390deethe8",
				"label" => __( 'Copyright section links color', 'stockie' ),
				"name" => "footer_copyright_section_links_color",
				"type" => "stockie_color",
				"instructions" => __( 'Choose section content links color', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"default_value" => ""
		      	],
	      	[
				"key" => "field_593d1e8c5b3b3",
				"label" => __( 'Other', 'stockie' ),
				"name" => "",
				"type" => "tab",
				"instructions" => "",
				"required" => 0,
				"conditional_logic" => 0,
				"placement" => "top",
				"endpoint" => 0
			],
	      	[
				"key" => "field_593dbedc5b780",
				"label" => __( 'Double width', 'stockie' ),
				"name" => "project_style_in_grid",
				"type" => "radio",
				"instructions" => __( 'Make double width for this portfolio item', 'stockie' ),
				"required" => 0,
				"conditional_logic" => 0,
				"choices" => [
                    "default" => __( 'Default - 1 Column Width', 'stockie' ),
                    "2col" => __( 'Wide - 2 Column Width', 'stockie' )
                ],
				"allow_null" => 0,
				"other_choice" => 0,
				"save_other_choice" => 0,
				"default_value" => "default",
				"layout" => "horizontal",
				"return_format" => "value"
			],
			[
				"key" => "field_593d1edc5b3b3",
				"label" => __( 'Custom CSS', 'stockie' ),
				"name" => "",
				"type" => "tab",
				"instructions" => "",
				"required" => 0,
				"conditional_logic" => 0,
				"placement" => "top",
				"endpoint" => 0
			],
			[
	            "key" => "field_59390de45yh5gh5",
	            "label" => __( 'Custom CSS styles', 'stockie' ),
	            "name" => "page_custom_css",
	            "type" => "stockie_code",
	            "instructions" => __( 'Write your own stylesheet here', 'stockie' ),
	            "required" => 0,
	            "conditional_logic" => 0,
	            "default_value" => "",
	            "language" => "css"
	        ],
	        [
	            "key" => "field_5937e0a52b4567mod951",
	            "label" => "",
	            "name" => "",
	            "type" => "message",
	            "instructions" => "",
	            "required" => 0,
	            "conditional_logic" => 0,
	            "message" => "<p class=\"message\"><span class=\"icon ion-information-circled\"></span> <b>Note:</b> you won't lose the CSS code written here while updating the theme.</p>",
	            "new_lines" => "",
	            "esc_html" => 0
	        ]
		],
		"location" => [
			[
				[
					"param" => "post_type",
					"operator" => "==",
					"value" => "stockie_portfolio"
				]
			]
		],
		"menu_order" => 0,
		"position" => "normal",
		"style" => "default",
		"label_placement" => "left",
		"instruction_placement" => "label",
		"hide_on_screen" => "",
		"active" => 1,
		"description" => ""
    ] );

endif;
