<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_59391f245236d",
        "title" => __( 'Project Details', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_59391f24594ff",
                "label" => __( 'Excerpt', 'stockie' ),
                "name" => "project_description",
                "type" => "wysiwyg",
                "instructions" => __( 'Write a short description for this project', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "maxlength" => "",
                "rows" => "",
                "new_lines" => "wpautop"
            ],
            [
                "key" => "field_59391f24598db",
                "label" => __( 'Media gallery', 'stockie' ),
                "name" => "project_content",
                "type" => "gallery",
                "instructions" => __( 'Add media files for this project (JPG, PNG, GIF formats are supported)', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "min" => "",
                "max" => "",
                "insert" => "append",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => "png, jpg, jpeg, gif, webp"
            ],
            [
                "key" => "field_59391f2459ccd",
                "label" => __( 'Date', 'stockie' ),
                "name" => "project_date",
                "type" => "date_picker",
                "instructions" => __( 'Choose the project date', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "display_format" => "F j, Y",
                "return_format" => "F j, Y",
                "first_day" => 1
            ],
            [
                "key" => "field_59391f245a0b6",
                "label" => __( 'Task', 'stockie' ),
                "name" => "project_task",
                "type" => "text",
                "instructions" => __( 'Specify what a challenge you had to overcome working on this project', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_59391f245a4b5",
                "label" => __( 'Skills', 'stockie' ),
                "name" => "project_skills",
                "type" => "text",
                "instructions" => __( 'Skills, techs and tools like', 'stockie' ) . '<em>&nbsp;' . __( '(e.g. Illustration, HTML5 and CSS Animation)', 'stockie' ) . '&nbsp;</em>' . __( 'or leave blank', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_59391f245a893",
                "label" => __( 'Client', 'stockie' ),
                "name" => "project_client",
                "type" => "text",
                "instructions" => __( 'Project client', 'stockie' ) . '<em>&nbsp;' . __( '(e.g. Envato Market)', 'stockie' ) . '&nbsp;</em>' . __( 'or leave blank', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_59391f245b478",
                "label" => __( 'Custom fields', 'stockie' ),
                "name" => "project_custom_fields",
                "type" => "repeater",
                "instructions" => __( 'Custom fields', 'stockie' ) . '<em>&nbsp;' . __( '(e.g. Tools, Technologies)', 'stockie' ) . '</em>',
                "required" => 0,
                "conditional_logic" => 0,
                "collapsed" => "",
                "min" => 0,
                "max" => 6,
                "layout" => "table",
                "button_label" => "+ Add Field",
                "sub_fields" => [
                    [
                        "key" => "field_59391f246d98c",
                        "label" => "Title",
                        "name" => "project_custom_field_title",
                        "type" => "text",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "wrapper" => [
                            "width" => "",
                            "class" => "",
                            "id" => ""
                        ],
                        "default_value" => "",
                        "placeholder" => "",
                        "prepend" => "",
                        "append" => "",
                        "maxlength" => ""
                    ],
                    [
                        "key" => "field_59391f246dd81",
                        "label" => "Value",
                        "name" => "project_custom_field_value",
                        "type" => "text",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "wrapper" => [
                            "width" => "",
                            "class" => "",
                            "id" => ""
                        ],
                        "default_value" => "",
                        "placeholder" => "",
                        "prepend" => "",
                        "append" => "",
                        "maxlength" => ""
                    ]
                ]
            ],
            [
                "key" => "field_59391f245b078",
                "label" => __( 'Project link', 'stockie' ),
                "name" => "project_open_type",
                "type" => "select",
                "instructions" => __( 'Add a link to the custom project page or live project website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "project" => __( 'Open a standard project page', 'stockie' ),
                    "external_target" => __( 'Open a project external link', 'stockie' ),
                    "external_blank" => __( 'Open a project external link in a new tab', 'stockie' )
                ],
                "default_value" => [
                    "project"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391f245ac8a",
                "label" => __( 'Project external link', 'stockie' ),
                "name" => "project_link",
                "type" => "url",
                "instructions" => __( 'Choose a showcase page for this project', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => ""
            ],
        ],
        "location" => [
            [
                [
                    "param" => "post_type",
                    "operator" => "==",
                    "value" => "stockie_portfolio"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "acf_after_title",
        "style" => "default",
        "label_placement" => "top",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;