<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_59390deae2279_product",
        "title" => __( 'Product Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_583be7a6d24298",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_595323fsa41247ae",
                "label" => __( 'Product layout', 'stockie' ),
                "name" => "ecommerce_product_type",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for product pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "inherit",
                        "description" => __( 'Use from Theme Settings', 'stockie' ),
                        "src" => "acf__image_inherited.svg"
                    ],
                    [
                        "name" => "type1",
                        "description" => __( 'Type 1', 'stockie' ),
                        "src" => "acf__image_15.svg"
                    ],
                    [
                        "name" => "type2",
                        "description" => __( 'Type 2', 'stockie' ),
                        "src" => "acf__image_16.svg"
                    ],
                    [
                        "name" => "type3",
                        "description" => __( 'Type 3', 'stockie' ),
                        "src" => "acf__image_17.svg"
                    ],
                    [
                        "name" => "type4",
                        "description" => __( 'Type 4', 'stockie' ),
                        "src" => "acf__image_18.svg"
                    ],
                    [
                        "name" => "type5",
                        "description" => __( 'Type 5', 'stockie' ),
                        "src" => "acf__image_19.svg"
                    ]
                ],
                "default_value" => "inherit"
            ],
            [
                "key" => "field_47272fda25ype",
                "label" => __( 'View mode', 'stockie' ),
                "name" => "woocommerce_view_mode",
                "type" => "radio",
                "instructions" => __( 'Choose view mode for product pages', 'stockie' ),
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => __( 'Left Gallery', 'stockie' ),
                    "right" => __( 'Right Gallery', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "return_format" => "value", 
                "layout" => "horizontal"
            ],
            [
                "key" => "field_47271241245ype",
                "label" => __( 'Sticky Product', 'stockie' ),
                "name" => "woocommerce_product_sticky",
                "type" => "radio",
                "instructions" => __( 'Enable Sticky product for product page?', 'stockie' ),
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "1" => __( 'Show', 'stockie' ),
                    "0" => __( 'Hide', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "return_format" => "value", 
                "layout" => "horizontal"
            ],
            [
                "key" => "field_47271f141245ype",
                "label" => __( 'Sale tag', 'stockie' ),
                "name" => "woocommerce_product_sale_tag",
                "type" => "radio",
                "instructions" => __( 'Enable Sale tag for product page?', 'stockie' ),
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "1" => __( 'Show', 'stockie' ),
                    "0" => __( 'Hide', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "return_format" => "value", 
                "layout" => "horizontal"
            ],
            [
                "key" => "field_47fqwerf141245ype",
                "label" => __( 'Lightbox preview', 'stockie' ),
                "name" => "woocommerce_product_lightbox_preview",
                "type" => "radio",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "1" => __( 'Show', 'stockie' ),
                    "0" => __( 'Hide', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "return_format" => "value", 
                "layout" => "horizontal"
            ],
            [
                "key" => "field_eq2rf141245ype",
                "label" => __( 'SKU', 'stockie' ),
                "name" => "woocommerce_product_sku",
                "type" => "radio",
                "instructions" => __( 'Enable SKU for product page?', 'stockie' ),
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "1" => __( 'Show', 'stockie' ),
                    "0" => __( 'Hide', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "return_format" => "value", 
                "layout" => "horizontal"
            ],
            [
                "key" => "field_eqcat141245ype",
                "label" => __( 'Category', 'stockie' ),
                "name" => "woocommerce_product_category",
                "type" => "radio",
                "instructions" => __( 'Enable category for product page?', 'stockie' ),
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "1" => __( 'Show', 'stockie' ),
                    "0" => __( 'Hide', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "return_format" => "value", 
                "layout" => "horizontal"
            ],
            [
                "key" => "field_eqtag141245ype",
                "label" => __( 'Tags', 'stockie' ),
                "name" => "woocommerce_product_tags",
                "type" => "radio",
                "instructions" => __( 'Enable tags for product page?', 'stockie' ),
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "1" => __( 'Show', 'stockie' ),
                    "0" => __( 'Hide', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "return_format" => "value", 
                "layout" => "horizontal"
            ],
            [
                "key" => "field_1427a0a52148cexmod23s152323232",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<h4>' . __( 'Typography Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_vqkf4haf12422c",
                "label" => __( 'Product title typography', 'stockie' ),
                "name" => "woocommerce_single_product_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for simple product titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592f4aff124wen",
                "label" => __( 'Product price typography', 'stockie' ),
                "name" => "woocommerce_single_product_price_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for simple product price', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_qwr93f4hff12422b",
                "label" => __( 'Product meta typography', 'stockie' ),
                "name" => "woocommerce_single_product_category_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for product meta', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59390deaeee3d",
                "label" => __( 'Header', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390dsqrf21a",
                "label" => __( 'Header layout', 'stockie' ),
                "name" => "header_menu_style",
                "type" => "image_option",
                "instructions" => __( 'Choose header template', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "inherit",
                        "description" => __( 'Use from Theme Settings', 'stockie' ),
                        "src" => "acf__image_inherited.svg"
                    ],
                    [
                        "name" => "style1",
                        "description" => __( 'Default', 'stockie' ),
                        "src" => "acf__image_01.svg"
                    ],
                    [
                        "name" => "style3",
                        "description" => __( 'Top Logo', 'stockie' ),
                        "src" => "acf__image_03.svg"
                    ],
                    [
                        "name" => "style4",
                        "description" => __( 'Centered Menu', 'stockie' ),
                        "src" => "acf__image_04.svg"
                    ],
                    [
                        "name" => "style5",
                        "description" => __( 'Centered Logo', 'stockie' ),
                        "src" => "acf__image_05.svg"
                    ],
                    [
                        "name" => "style6",
                        "description" => __( 'Sidebar Menu', 'stockie' ),
                        "src" => "acf__image_06.svg"
                    ],
                    [
                        "name" => "style7",
                        "description" => __( 'Panel Menu', 'stockie' ),
                        "src" => "acf__image_07.svg"
                    ]
                ],
                "default_value" => "inherit"
            ],
            [
                "key" => "field_59390dea34g3ehj",
                "label" => __( 'Blank spacer under header', 'stockie' ),
                "name" => "header_menu_add_cap",
                "type" => "radio",
                "instructions" => __( 'We recommend use this setting for transparent and fixed header navigation', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Add Spacer', 'stockie' ),
                    "no" => __( 'Don\'t Add Spacer', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deaef61423rf23wki",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "header_menu_use_wrapper",
                "type" => "radio",
                "instructions" => __( 'Use header content wrapper', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59411fcf0048f123g5vfl",
                "label" => __( 'Header styles', 'stockie' ),
                "name" => "header_menu_style_settings",
                "type" => "radio",
                "instructions" => __( 'Define header custom styles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5941276d07u9gibuiyh",
                "label" => __( 'Height', 'stockie' ),
                "name" => "header_menu_height",
                "type" => "stockie_responstive_height",
                "instructions" => __( 'Set up header height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vfl",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390dea8ygf76",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "header_menu_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose header background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vfl",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390dea4egkj",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "header_menu_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for header', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vfl",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_5941261c69912r342e",
                "label" => __( 'Bottom border', 'stockie' ),
                "name" => "header_menu_hide_border",
                "type" => "true_false",
                "instructions" => __( 'Hide bottom border from header?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vfl",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_594126ed0b898uhi23",
                "label" => __( 'Bottom border type', 'stockie' ),
                "name" => "header_menu_border_type",
                "type" => "select",
                "instructions" => __( 'Choose border stroke type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vfl",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_5941261c69912r342e",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "solid" => __( 'Solid', 'stockie' ),
                    "dashed" => __( 'Dashed', 'stockie' ),
                    "dotted" => __( 'Dotted', 'stockie' ),
                    "double" => __( 'Double', 'stockie' )
                ],
                "default_value" => [
                    "solid"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_594127340b89a83gdi23bd",
                "label" => __( 'Bottom border color', 'stockie' ),
                "name" => "header_menu_border_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose bottom border color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vfl",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_5941261c69912r342e",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593a521s71ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<h4>' . __( 'Sticky Header', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59390deaweff19789ftfv",
                "label" => __( 'Sticky header', 'stockie' ),
                "name" => "header_menu_fixed",
                "type" => "radio",
                "instructions" => __( 'Enable sticky header, when you scrolling the page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937af34fs71ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<h4>' . __( 'Logo Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59391a16302be1jhnlsdc",
                "label" => __( 'Brand logo', 'stockie' ),
                "name" => "header_logo_style",
                "type" => "select",
                "instructions" => __( 'Choose logo type for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "light_variant" => __( 'Light Variant', 'stockie' ),
                    "sitename" => __( 'Text Logo', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390d23r2qeaf09ac",
                "label" => __( 'Text Logo settings', 'stockie' ),
                "name" => "header_menu_sitename_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Custom setting for text logo typography', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391a16302be1jhnlsdc",
                            "operator" => "==",
                            "value" => "sitename"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59411f812deas2536",
                "label" => __( 'Custom logo', 'stockie' ),
                "name" => "header_menu_custom_logo",
                "type" => "image",
                "instructions" => __( 'Loaded logo image for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391a16302be1jhnlsdc",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_5937a0a23rfas71ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<h4>' . __( 'Menu Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59390deaefde5asd2t3g4",
                "label" => __( 'Menu type', 'stockie' ),
                "name" => "menu_type",
                "type" => "radio",
                "instructions" => __( 'Choose menu type for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "full" => __( 'Regular Menu', 'stockie' ),
                    "hamburger" => __( 'Hamburger Menu', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59410293713dasac",
                "label" => __( 'Subheader', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390deaf190djals4",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "header_menu_add_contacts_bar",
                "type" => "radio",
                "instructions" => __( 'Show subheader on this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => "Hide"
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5941030b7c13udygasg",
                "label" => __( 'Subheader styles', 'stockie' ),
                "name" => "header_menu_contacts_bar_style",
                "type" => "radio",
                "instructions" => __( 'Choose subheader style', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5941040a97ec12412dgs9",
                "label" => __( 'Height', 'stockie' ),
                "name" => "header_menu_contacts_bar_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up subheader height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5941030b7c13udygasg",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390deaf18d73kj11d5",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "header_menu_contacts_bar_background",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5941030b7c13udygasg",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390deaf23r423as59e",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "header_menu_contacts_bar_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5941030b7ce5d",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59390deaf10238jb",
                "label" => __( 'Page Headline', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390deb00213rdfy1",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "header_use_hero",
                "type" => "radio",
                "instructions" => __( 'Hide page headline from this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Hide', 'stockie' ),
                    "no" => __( 'Show', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb02r34ewsf33",
                "label" => __( 'Fullscreen height', 'stockie' ),
                "name" => "header_height_fullscreen",
                "type" => "radio",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb00b7fzdkj",
                "label" => __( 'Height', 'stockie' ),
                "name" => "header_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up page headline height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb02r34ewsf33",
                            "operator" => "!=",
                            "value" => "yes"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593ddebba23iurhfbb",
                "label" => __( 'Subtitle text', 'stockie' ),
                "name" => "header_subtitle",
                "type" => "text",
                "instructions" => __( 'Custom subtitle text', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_59390deb07urhlkj",
                "label" => __( 'Content position', 'stockie' ),
                "name" => "header_title_align",
                "type" => "select",
                "instructions" => __( 'Choose page headline content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => "Left",
                    "center" => "Center",
                    "right" => "Right"
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deaf23fswdc",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "header_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose background type for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "image" => __( 'Custom Image', 'stockie' ),
                    "color" => __( 'Background color', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deaf29813cdwedvf",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "header_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "preview_size" => "thumbnail",
                "library" => "all",
                "return_format" => "url",
                "min_width" => 0,
                "min_height" => 0,
                "min_size" => 0,
                "max_width" => 0,
                "max_height" => 0,
                "max_size" => 0,
                "mime_types" => ""
            ],
            [
                "key" => "field_59390deaf224rfwesdf",
                "label" => __( 'Background image size', 'stockie' ),
                "name" => "header_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deaf34f3ewd",
                "label" => __( 'Background image position', 'stockie' ),
                "name" => "header_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deaf224rfwesdf",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ],
                    [
                        [
                            "field" => "field_59390deaf224rfwesdf",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deaf3534fsed",
                "label" => __( 'Background image repeat', 'stockie' ),
                "name" => "header_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose background image repeat type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deaf224rfwesdf",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ],
                    [
                        [
                            "field" => "field_59390deaf224rfwesdf",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deaf25824fewd",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "header_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59390deaf39634tdf",
                "label" => __( 'Background overlay', 'stockie' ),
                "name" => "header_use_overlay",
                "type" => "radio",
                "instructions" => __( 'Add colored overlay over background image?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deaf3d24fed",
                "label" => __( 'Background overlay color', 'stockie' ),
                "name" => "header_overlay_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background overlay color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ],
                        [
                            "field" => "field_59390deaf39634tdf",
                            "operator" => "==",
                            "value" => "inherit"
                        ]
                    ],
                    [
                        [
                            "field" => "field_59390deaf23fswdc",
                            "operator" => "==",
                            "value" => "image"
                        ],
                        [
                            "field" => "field_59390deaf39634tdf",
                            "operator" => "==",
                            "value" => "yes"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593a55746373423rf",
                "label" => __( 'Typography settings', 'stockie' ),
                "name" => "page_typography_settings",
                "type" => "radio",
                "instructions" => __( 'Set up typography for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_51cga93a55daq124v0637fq",
                "label" => __( 'Go back button typography', 'stockie' ),
                "name" => "header_back_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for go back button', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593a55746373423rf",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593a55d06377rfuy",
                "label" => __( 'Title settings', 'stockie' ),
                "name" => "page_header_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for hero titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593a55746373423rf",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593a56516334r",
                "label" => __( 'Subtitle settings', 'stockie' ),
                "name" => "page_header_subtitle_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for subtitles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593a55746373423rf",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593d61608b76gh",
                "label" => __( 'Breadcrumbs', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390deb033223tgds",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "page_show_breadcrumbs",
                "type" => "radio",
                "instructions" => __( 'Show breadcrumbs on this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => "Hide"
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb03328dsaf1v",
                "label" => __( 'Category slug', 'stockie' ),
                "name" => "page_show_category_breadcrumbs",
                "type" => "radio",
                "instructions" => __( 'Show product categories in breadcrumbs?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => "Theme settings inherited",
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => "Hide"
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593d618e8b87u6ghj",
                "label" => __( 'Breadcrumbs background color', 'stockie' ),
                "name" => "breadcrumbs_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose breadcrumbs block background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593db133923iuyfghk",
                "label" => __( 'Breadcrumbs text color', 'stockie' ),
                "name" => "breadcrumbs_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose breadcrumbs text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59390deb0123fsdsad",
                "label" => __( 'Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390deb034fswedf",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "page_is_wrapped",
                "type" => "radio",
                "instructions" => __( 'Add content wrapper to this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb03738",
                            "operator" => "!=",
                            "value" => "yes"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Enable', 'stockie' ),
                    "no" => __( 'Disable', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_591ac5s9d31f3",
                "label" => __( 'Content wrapper width', 'stockie' ),
                "name" => "global_content_wrapper_width",
                "type" => "text",
                "instructions" => __( 'Define container wrapper width</em>', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "1326px",
                "prepend" => __( 'Use CSS units', 'stockie' ),
                "append" => "",
                "maxlength" => 200
            ],
            [
                "key" => "field_591b10dbb4a85_fwgaps_type",
                "label" => __( 'Full-width wrapper', 'stockie' ),
                "name" => "full_width_margins_type",
                "type" => "radio",
                "instructions" => __( 'Set custom value for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_591b10dbb4a85_35gsdaps_local",
                "label" => __( 'Full-width wrapper side margins', 'stockie' ),
                "name" => "full_width_margins_size",
                "type" => "text",
                "instructions" => __( 'Define side margins for full-width page container', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_591b10dbb4a85_fwgaps_type",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => "",
                "placeholder" => "",
                "prepend" => __( 'Use CSS units', 'stockie' ),
                "append" => "",
                "maxlength" => 200
            ],
            [
                "key" => "field_59390deb0334fwdef",
                "label" => __( 'Content padding', 'stockie' ),
                "name" => "page_add_top_padding",
                "type" => "radio",
                "instructions" => __( 'Add top and bottom padding for page content', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Add', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb03738",
                "label" => __( 'Boxed page layout', 'stockie' ),
                "name" => "page_use_boxed_wrapper",
                "type" => "radio",
                "instructions" => __( 'Wrap this page in boxed container?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb024fwe",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "page_background_type",
                "type" => "radio",
                "instructions" => __( 'Select background type for page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' ),
                    "color" => __( 'Custom Color', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb0123frhed",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "page_background_image",
                "type" => "image",
                "instructions" => __( 'Custom background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fwe",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_59390deb0345gerfv",
                "label" => __( 'Background image size', 'stockie' ),
                "name" => "page_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fwe",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "auto"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deb34gfswdef",
                "label" => __( 'Background image position', 'stockie' ),
                "name" => "page_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb0345gerfv",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_59390deb024fwe",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ],
                    [
                        [
                            "field" => "field_59390deb0345gerfv",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_59390deb024fwe",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deb0223rjhoklj",
                "label" => __( 'Background image repeat', 'stockie' ),
                "name" => "page_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose background image repeat type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb0345gerfv",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_59390deb024fwe",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ],
                    [
                        [
                            "field" => "field_59390deb0345gerfv",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_59390deb024fwe",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deb034tgfds",
                "label" => __( 'Background attachment', 'stockie' ),
                "name" => "page_background_is_attached",
                "type" => "true_false",
                "instructions" => __( 'You can fix background image on this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fwe",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59390deb0213rasd",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "page_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Custom background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59390deb0423rdsw",
                "label" => __( 'Footer', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390deb060hjouj",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "footer_hide",
                "type" => "radio",
                "instructions" => __( 'Hide footer from this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Hide', 'stockie' ),
                    "no" => __( 'Show', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb34gdfs1",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "footer_is_wrapped",
                "type" => "radio",
                "instructions" => __( 'Add footer content wrapper?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Enable', 'stockie' ),
                    "no" => __( 'Disable', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5940ec945tgersd",
                "label" => __( 'Content text color', 'stockie' ),
                "name" => "footer_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose content text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59390deb024fdhsz",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "footer_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose footer background type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' ),
                    "color" => __( 'Custom Color', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb05723fdas",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "footer_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for footer', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fdhsz",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => 1200,
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_59390deb0513dfasd",
                "label" => __( 'Background size', 'stockie' ),
                "name" => "footer_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fdhsz",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deb023rasdg",
                "label" => __( 'Background position', 'stockie' ),
                "name" => "footer_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fdhsz",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390de23drfasf38b",
                "label" => __( 'Background repeat', 'stockie' ),
                "name" => "footer_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose background image repeat type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fdhsz",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390deb034gdfsh",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "footer_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose footer background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb024fdhsz",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390deb045h34",
                "label" => __( 'Footer logo widget type', 'stockie' ),
                "name" => "footer_logo_widget_type",
                "type" => "select",
                "instructions" => __( 'Choose widget logo type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "light_variant" => "Light Variant logo",
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "sitename" => "Site name",
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5940dfabfe5hefg",
                "label" => __( 'Footer site name settings', 'stockie' ),
                "name" => "footer_sitename_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Custom settings for footer site name', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb045h34",
                            "operator" => "==",
                            "value" => "sitename"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_5940dfeaf34tgdsf",
                "label" => __( 'Footer custom logo image', 'stockie' ),
                "name" => "footer_custom_logo",
                "type" => "image",
                "instructions" => __( 'Custom logo image in footer', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb045h34",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_59391734tgreyhdef2b",
                "label" => __( 'Sticky footer', 'stockie' ),
                "name" => "footer_as_sticky",
                "type" => "radio",
                "instructions" => __( 'Set sticky (fixed) footer on this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937a4a921s81ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<h4>' . __( 'Copyright Bar', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59390deb07397",
                "label" => __( 'Copyright section visibility', 'stockie' ),
                "name" => "footer_show_copyright_section",
                "type" => "radio",
                "instructions" => __( 'Show copyright section on this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => "Hide"
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deb23rtfedswgd",
                "label" => __( 'Copyright section background', 'stockie' ),
                "name" => "footer_copyright_section_background",
                "type" => "stockie_color",
                "instructions" => __( 'Choose section background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59390d34tger67",
                "label" => __( 'Copyright section text color', 'stockie' ),
                "name" => "footer_copyright_section_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose section content text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59390d34ytgref",
                "label" => __( 'Copyright section links color', 'stockie' ),
                "name" => "footer_copyright_section_links_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose section content links color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
    			"key" => "field_593d1e8c5bqwe",
    			"label" => __( 'Other', 'stockie' ),
    			"name" => "",
    			"type" => "tab",
    			"instructions" => "",
    			"required" => 0,
    			"conditional_logic" => 0,
    			"wrapper" => [
    				"width" => "",
    				"class" => "",
    				"id" => ""
    			],
    			"placement" => "top",
    			"endpoint" => 0
    		],
          	[
    			"key" => "field_593dbedc5bqwee1",
    			"label" => __( 'Double width', 'stockie' ),
    			"name" => "product_style_in_grid",
    			"type" => "radio",
    			"instructions" => __( 'Make double width for this product', 'stockie' ),
    			"required" => 0,
    			"conditional_logic" => 0,
    			"wrapper" => [
    				"width" => "",
    				"class" => "",
    				"id" => ""
    			],
                "choices" => [
                    "default" => __( 'Default - 1 Column Width', 'stockie' ),
                    "2col" => __( 'Wide - 2 Column Width', 'stockie' )
                ],
    			"allow_null" => 0,
    			"other_choice" => 0,
    			"save_other_choice" => 0,
    			"default_value" => "default",
    			"layout" => "horizontal",
    			"return_format" => "value"
    		],
            [
                "key" => "field_59390deb07f2t43rdf",
                "label" => __( 'Custom CSS', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390deb34tgd5",
                "label" => __( 'Custom CSS styles', 'stockie' ),
                "name" => "page_custom_css",
                "type" => "stockie_code",
                "instructions" => __( 'Write your own stylesheet here', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "language" => "css"
            ],
            [
                "key" => "field_5937e0a52b4567mod951",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "<p class=\"message\"><span class=\"icon ion-information-circled\"></span> <b>Note:</b> you won't lose the CSS code written here while updating the theme.</p>",
                "new_lines" => "",
                "esc_html" => 0
            ]
        ],
        "location" => [
            [
                [
                    "param" => "post_type",
                    "operator" => "==",
                    "value" => "product"
                ]
            ]
        ],
        "menu_order" => 5,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => [
            "discussion",
            "comments",
            "author",
            "format"
        ],
        "active" => 1,
        "description" => ""
    ] );

endif;
