<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_593914649cd2e",
        "title" => __( 'Post Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_59391464a894a",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59391464a8d8c",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "post_page_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose page background type for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' ),
                    "color" => __( 'Custom Color', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59391464a9134",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "post_page_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a8d8c",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_59391464a952d",
                "label" => __( 'Background size', 'stockie' ),
                "name" => "post_page_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a8d8c",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464a991d",
                "label" => __( 'Background position', 'stockie' ),
                "name" => "post_page_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a8d8c",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_59391464a952d",
                            "operator" => "!=",
                            "value" => "cover"
                        ],
                        [
                            "field" => "field_59391464a952d",
                            "operator" => "!=",
                            "value" => "100per"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [
                    "center"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464a9cd2",
                "label" => __( 'Background repeat', 'stockie' ),
                "name" => "post_page_background_repeat",
                "type" => "select",
                "instructions" => __( 'Repeat type of background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a8d8c",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_59391464a952d",
                            "operator" => "!=",
                            "value" => "cover"
                        ],
                        [
                            "field" => "field_59391464a952d",
                            "operator" => "!=",
                            "value" => "100per"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464aa0f2",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "post_page_background",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a8d8c",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59391464aa4d7",
                "label" => __( 'Background attachment', 'stockie' ),
                "name" => "post_page_attach_background",
                "type" => "true_false",
                "instructions" => __( 'Fix background image for this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a8d8c",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593914adc9695",
                "label" => __( 'Boxed page layout', 'stockie' ),
                "name" => "post_use_boxed_wrapper",
                "type" => "radio",
                "instructions" => __( 'Wrap this page in boxed container?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59391464ab533",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "post_page_add_wrapper",
                "type" => "radio",
                "instructions" => __( 'Add page content wrapper to this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593914adc9695",
                            "operator" => "!=",
                            "value" => "yes"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],

            [
                "key" => "field_59390deaeee3dduda",
                "label" => __( 'Header', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390dsqrf21aduda",
                "label" => __( 'Header layout', 'stockie' ),
                "name" => "header_menu_style",
                "type" => "image_option",
                "instructions" => __( 'Choose header template', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "inherit",
                        "description" => __( 'Use from Theme Settings', 'stockie' ),
                        "src" => "acf__image_inherited.svg"
                    ],
                    [
                        "name" => "style1",
                        "description" => __( 'Default', 'stockie' ),
                        "src" => "acf__image_01.svg"
                    ],
                    [
                        "name" => "style3",
                        "description" => __( 'Top Logo', 'stockie' ),
                        "src" => "acf__image_03.svg"
                    ],
                    [
                        "name" => "style4",
                        "description" => __( 'Centered Menu', 'stockie' ),
                        "src" => "acf__image_04.svg"
                    ],
                    [
                        "name" => "style5",
                        "description" => __( 'Centered Logo', 'stockie' ),
                        "src" => "acf__image_05.svg"
                    ],
                    [
                        "name" => "style6",
                        "description" => __( 'Sidebar Menu', 'stockie' ),
                        "src" => "acf__image_06.svg"
                    ],
                    [
                        "name" => "style7",
                        "description" => __( 'Panel Menu', 'stockie' ),
                        "src" => "acf__image_07.svg"
                    ]
                ],
                "default_value" => "inherit"
            ],
            [
                "key" => "field_59390dea34g3ehjduda",
                "label" => __( 'Blank spacer under header', 'stockie' ),
                "name" => "header_menu_add_cap",
                "type" => "radio",
                "instructions" => __( 'We recommend use this setting for transparent and fixed header navigation', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Add Spacer', 'stockie' ),
                    "no" => __( 'Don\'t Add Spacer', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59390deaef61423rf23wkiduda",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "header_menu_use_wrapper",
                "type" => "radio",
                "instructions" => __( 'Use header content wrapper', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59411fcf0048f123g5vflduda",
                "label" => __( 'Header styles', 'stockie' ),
                "name" => "header_menu_style_settings",
                "type" => "radio",
                "instructions" => __( 'Define header custom styles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5941276d07u9gibuiyhduda",
                "label" => __( 'Height', 'stockie' ),
                "name" => "header_menu_height",
                "type" => "stockie_responstive_height",
                "instructions" => __( 'Set up header height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vflduda",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390dea8ygf76duda",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "header_menu_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose header background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vflduda",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390dea4egkjduda",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "header_menu_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for header', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vflduda",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_5941261c69912r342eduda",
                "label" => __( 'Bottom border', 'stockie' ),
                "name" => "header_menu_hide_border",
                "type" => "true_false",
                "instructions" => __( 'Hide bottom border from header?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vflduda",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_594126ed0b898uhi23duda",
                "label" => __( 'Bottom border type', 'stockie' ),
                "name" => "header_menu_border_type",
                "type" => "select",
                "instructions" => __( 'Choose border stroke type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vflduda",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_5941261c69912r342eduda",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "solid" => __( 'Solid', 'stockie' ),
                    "dashed" => __( 'Dashed', 'stockie' ),
                    "dotted" => __( 'Dotted', 'stockie' ),
                    "double" => __( 'Double', 'stockie' )
                ],
                "default_value" => [
                    "solid"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_594127340b89a83gdi23bdduda",
                "label" => __( 'Bottom border color', 'stockie' ),
                "name" => "header_menu_border_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose bottom border color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59411fcf0048f123g5vflduda",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_5941261c69912r342eduda",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593a521s71ebmod23duda",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Sticky Header', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59390deaweff19789ftfvduda",
                "label" => __( 'Sticky header', 'stockie' ),
                "name" => "header_menu_fixed",
                "type" => "radio",
                "instructions" => __( 'Enable sticky header, when you scrolling the page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937af34fs71ebmod23duda",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Logo Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59391a16302be1jhnlsdcduda",
                "label" => __( 'Brand logo', 'stockie' ),
                "name" => "header_logo_style",
                "type" => "select",
                "instructions" => __( 'Choose logo type for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "light_variant" => __( 'Light Variant', 'stockie' ),
                    "sitename" => __( 'Text Logo', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390d23r2qeaf09acduda",
                "label" => __( 'Text Logo settings', 'stockie' ),
                "name" => "header_menu_sitename_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Custom setting for text logo typography', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391a16302be1jhnlsdcduda",
                            "operator" => "==",
                            "value" => "sitename"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59411f812deas2536duda",
                "label" => __( 'Custom logo', 'stockie' ),
                "name" => "header_menu_custom_logo",
                "type" => "image",
                "instructions" => __( 'Loaded logo image for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391a16302be1jhnlsdcduda",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_5937a0a23rfas71ebmod23duda",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Menu Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59390deaefde5asd2t3g4duda",
                "label" => __( 'Menu type', 'stockie' ),
                "name" => "menu_type",
                "type" => "radio",
                "instructions" => __( 'Choose menu type for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "full" => __( 'Regular Menu', 'stockie' ),
                    "hamburger" => __( 'Hamburger Menu', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59391464a4dc9",
                "label" => __( 'Page Headline', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59391464a855b",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "post_title_hide",
                "type" => "radio",
                "instructions" => __( 'Hide page headline from this page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Hide', 'stockie' ),
                    "no" => __( 'Show', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59391464a7d7c",
                "label" => __( 'Fullscreen height', 'stockie' ),
                "name" => "header_height_fullscreen",
                "type" => "radio",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59391464a8178",
                "label" => __( 'Height', 'stockie' ),
                "name" => "post_title_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up page headline height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a7d7c",
                            "operator" => "!=",
                            "value" => "yes"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59391464a51e6",
                "label" => __( 'Subtitle text', 'stockie' ),
                "name" => "header_title_subtitle_type",
                "type" => "radio",
                "instructions" => __( 'Choose custom subtitle type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "generated" => __( 'Post Meta', 'stockie' ),
                    "custom" => __( 'Custom Subtitle', 'stockie' ),
                    "hidden" => __( 'Hidden', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593d5eb537af1",
                "label" => __( 'Content position', 'stockie' ),
                "name" => "post_header_title_align",
                "type" => "radio",
                "instructions" => __( 'Choose page headline content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => "Left",
                    "center" => "Center",
                    "right" => "Right"
                ],
                "default_value" => [
                    
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464a55be",
                "label" => __( 'Custom subtitle text', 'stockie' ),
                "name" => "header_subtitle",
                "type" => "text",
                "instructions" => __( 'Write custom subtitle for this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a51e6",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "formatting" => "html",
                "maxlength" => ""
            ],
            [
                "key" => "field_59391464a59dc",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "post_title_background",
                "type" => "radio",
                "instructions" => __( 'Choose background type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "post_thumbnail" => __( 'Post Featured Image', 'stockie' ),
                    "loaded_image" => __( 'Custom Image', 'stockie' ),
                    "color" => __( 'Background Color', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464a5df8",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "post_title_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "==",
                            "value" => "color"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59391464a61b8",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "post_title_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "==",
                            "value" => "loaded_image"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_59391464a65b9",
                "label" => __( 'Background image size', 'stockie' ),
                "name" => "post_title_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "==",
                            "value" => "loaded_image"
                        ]
                    ],
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464a69b6",
                "label" => __( 'Background image position', 'stockie' ),
                "name" => "post_title_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "!=",
                            "value" => "color"
                        ],
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "!=",
                            "value" => "inherit"
                        ],
                        [
                            "field" => "field_59391464a65b9",
                            "operator" => "!=",
                            "value" => "100per"
                        ],
                        [
                            "field" => "field_59391464a65b9",
                            "operator" => "!=",
                            "value" => "cover"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [
                    "center"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464a6d9b",
                "label" => __( 'Background image repeat', 'stockie' ),
                "name" => "post_title_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose background image repeat type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "!=",
                            "value" => "inherit"
                        ],
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "!=",
                            "value" => "color"
                        ],
                        [
                            "field" => "field_59391464a65b9",
                            "operator" => "!=",
                            "value" => "cover"
                        ],
                        [
                            "field" => "field_59391464a65b9",
                            "operator" => "!=",
                            "value" => "100per"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59391464a7198",
                "label" => __( 'Background overlay', 'stockie' ),
                "name" => "post_title_use_overlay",
                "type" => "radio",
                "instructions" => __( 'Add colored overlay over background image?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "==",
                            "value" => "loaded_image"
                        ]
                    ],
                    [
                        [
                            "field" => "field_59391464a59dc",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59391464a758b",
                "label" => __( 'Background overlay color', 'stockie' ),
                "name" => "post_title_background_overlay",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background overlay color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a7198",
                            "operator" => "==",
                            "value" => "Yes"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59391464a79ac",
                "label" => __( 'Typography settings', 'stockie' ),
                "name" => "post_typography_settings",
                "type" => "radio",
                "instructions" => __( 'Set up typography for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593a55sqt37fq",
                "label" => __( 'Go back button typography', 'stockie' ),
                "name" => "header_back_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for go back button', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a79ac",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593d45d195043",
                "label" => __( 'Title settings', 'stockie' ),
                "name" => "post_header_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for hero titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a79ac",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593d45ef95044",
                "label" => __( 'Subtitle settings', 'stockie' ),
                "name" => "post_header_subtitle_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for subtitles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59391464a79ac",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593db4dfba577",
                "label" => __( 'Breadcrumbs', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59391464ab0fc",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "post_show_breadcrumbs",
                "type" => "radio",
                "instructions" => __( 'Show breadcrumbs on this page page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "hide" => __( 'Hide', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593db522ba578",
                "label" => __( 'Breadcrumbs background color', 'stockie' ),
                "name" => "post_breadcrumbs_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose breadcrumbs block background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593db573ba579",
                "label" => __( 'Breadcrumbs text color', 'stockie' ),
                "name" => "post_breadcrumbs_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose breadcrumbs text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59391464ab91d",
                "label" => __( 'Styles', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59391464abd30",
                "label" => __( 'Double width', 'stockie' ),
                "name" => "post_style_in_grid",
                "type" => "radio",
                "instructions" => __( 'Make double width for this post item', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "default" => __( 'Default - 1 Column Width', 'stockie' ),
                    "2col" => __( 'Wide - 2 Column Width', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "default",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59391s64ab91d",
                "label" => __( 'Custom CSS', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59391464ac555",
                "label" => __( 'Custom CSS styles', 'stockie' ),
                "name" => "post_custom_css",
                "type" => "textarea",
                "instructions" => __( 'Write your own stylesheet here', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "Your CSS code here",
                "maxlength" => "",
                "rows" => "",
                "new_lines" => ""
            ],
            [
                "key" => "field_5937e0a52b4567mod951",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message"><span class="dashicons dashicons-editor-help"></span>' . __( 'You won\'t lose the CSS code after updating the theme.', 'stockie' ) . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
        ],
        "location" => [
            [
                [
                    "param" => "post_type",
                    "operator" => "==",
                    "value" => "post"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;