<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_592fd665c6552",
        "title" => __( 'Portfolio Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_592fe6046937d",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a52b48cexmod155",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59fa4344b383615",
                "label" => __( 'Portfolio layout', 'stockie' ),
                "name" => "global_portfolio_layout",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for portfolio items', 'stockie' ),
                "conditional_logic" => 0,
                "default_value" => "grid_1",
                "image_option_value" => [
                    [
                        "name" => "grid_2",
                        "description" => __( 'Classic', 'stockie' ),
                        "src" => "acf__image_24.svg"
                    ],
                    [
                        "name" => "grid_1",
                        "description" => __( 'Minimal', 'stockie' ),
                        "src" => "acf__image_34.svg"
                    ]
                ]
            ],
            [
                "key" => "field_512341234234234",
                "label" => __( 'Hover effect', 'stockie' ),
                "name" => "global_portfolio_grid_1_hover",
                "type" => "image_option",
                "instructions" => __( 'Choose hover layout for portfolio items', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fa4344b383615",
                            "operator" => "==",
                            "value" => "grid_1"
                        ]
                    ]
                ],
                "image_option_value" => [
                    [
                        "name" => "hover_1",
                        "description" => __( 'Centered Details', 'stockie' ),
                        "src" => "acf__image_37.svg"
                    ],
                    [
                        "name" => "hover_2",
                        "description" => __( 'Side Details', 'stockie' ),
                        "src" => "acf__image_21.svg"
                    ]
                ]
            ],
            [
                "key" => "field_59fa41123412345",
                "label" => __( 'Hover effect', 'stockie' ),
                "name" => "global_portfolio_grid_2_hover",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for portfolio items', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fa4344b383615",
                            "operator" => "==",
                            "value" => "grid_2"
                        ]
                    ]
                ],
                "image_option_value" => [
                    [
                        "name" => "hover_1",
                        "description" => "Image Opacity",
                        "src" => "acf__image_35.svg"
                    ],
                    [
                        "name" => "hover_2",
                        "description" => "Overlay Button",
                        "src" => "acf__image_36.svg"
                    ]
                ]
            ],
            [
                "key" => "field_592fd66v12ffaqwba22c",
                "label" => __( 'Grid image size', 'stockie' ),
                "name" => "global_portfolio_images_size",
                "type" => "select",
                "instructions" => __( 'Choose image size for portfolio items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "thumbnail" => __( 'Thumbnail', 'stockie' ),
                    "medium" => __( 'Small', 'stockie' ),
                    "medium_large" => __( 'Medium', 'stockie' ),
                    "large" => __( 'Large', 'stockie' ),
                    "full" => __( 'Original', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "medium_large",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59fb4313b343615",
                "label" => __( 'Portfolio items per row', 'stockie' ),
                "name" => "global_portfolio_columns_in_row",
                "type" => "stockie_columns",
                "instructions" => __( 'Choose number of portfolio items per row', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "4-3-2-1"
            ],
            [
                "key" => "field_59fb4312b343615",
                "label" => __( 'Grid animation', 'stockie' ),
                "name" => "global_portfolio_animation_type",
                "type" => "select",
                "instructions" => __( 'Choose grid animation type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "default" => __( 'Disable Animation', 'stockie' ),
                    "sync" => __( 'Sync Animation', 'stockie' ),
                    "async" => __( 'Async Animation', 'stockie' )
                ],
                "default_value" => ["default"],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59fb4332b343615",
                "label" => __( 'Grid animation effect', 'stockie' ),
                "name" => "global_portfolio_animation_effect",
                "type" => "select",
                "instructions" => __( 'Choose portfolio items appear effect', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fb4312b343615",
                            "operator" => "!=",
                            "value" => "default"
                        ]
                    ]
                ],
                "choices" => [
                    "fade-up" => __( 'Fade Up', 'stockie' ),
                    "fade-down" => __( 'Fade Down', 'stockie' ),
                    "fade-right" => __( 'Fade Right', 'stockie' ),
                    "fade-left" => __( 'Fade Left', 'stockie' ),
                    "flip-up" => __( 'Flip Up', 'stockie' ),
                    "flip-down" => __( 'Flip Down', 'stockie' ),
                    "zoom-in" => __( 'Zoom In', 'stockie' ),
                    "zoom-out" => __( 'Zoom Out', 'stockie' )
                ],
                "default_value" => [
                    "fade-up"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59fb4312383615",
                "label" => __( 'Category visible', 'stockie' ),
                "name" => "global_portfolio_page_category",
                "type" => "true_false",
                "instructions" => __( 'Show category label on portfolio items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_5939023234234d98",
                "label" => __( 'Category color', 'stockie' ),
                "name" => "global_portfolio_page_category_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose category text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fb4312383615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59397890834d98",
                "label" => __( 'Category background color', 'stockie' ),
                "name" => "global_portfolio_page_category_bg_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose category label background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fb4312383615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59390234233d98",
                "label" => __( 'Title color', 'stockie' ),
                "name" => "global_portfolio_page_title_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose title text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59f234234383615",
                "label" => __( 'Project link visible', 'stockie' ),
                "name" => "global_portfolio_page_more",
                "type" => "true_false",
                "instructions" => __( 'Show <em>"View project"</em> link on portfolio items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_59392342562343d98",
                "label" => __( 'Project link color', 'stockie' ),
                "name" => "global_portfolio_page_more_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose project link text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59f234234383615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59392398832343d98",
                "label" => __( 'Overlay color', 'stockie' ),
                "name" => "global_portfolio_page_overlay_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose overlay background color', 'stockie' )
            ],
            [
                "key" => "field_59392323423423523",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_portfolio_page_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color', 'stockie' ),
            ],
            [
                "key" => "field_59fb4313b383615",
                "label" => __( 'Grid spacing', 'stockie' ),
                "name" => "global_portfolio_items_without_padding",
                "type" => "true_false",
                "instructions" => __( 'Remove spacing between grid items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_592fe4346937d",
                "label" => __( 'Portfolio Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592fd666241be",
                "label" => __( 'Portfolio page', 'stockie' ),
                "name" => "global_portfolio_page",
                "type" => "page_link",
                "instructions" => __( 'Choose page for all portfolio projects', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "post_type" => [
                    "page"
                ],
                "taxonomy" => [

                ],
                "allow_null" => 0,
                "allow_archives" => 0,
                "multiple" => 0
            ],
            [
                "key" => "field_592fd66622e2c",
                "label" => __( 'Breadcrumbs visibility', 'stockie' ),
                "name" => "global_project_hide_breadcrumbs",
                "type" => "radio",
                "instructions" => __( 'Hide breadcrumbs from portfolio pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Hide', 'stockie' ),
                    "no" => __( 'Show', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592fd66622e2f",
                "label" => __( 'Breadcrumbs slug', 'stockie' ),
                "name" => "global_project_breadcrumb_slug",
                "type" => "text",
                "instructions" => __( 'Enter custom text for breadcrumbs slug', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "Portfolio",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592fd66vba22c",
                "label" => __( 'Custom content position', 'stockie' ),
                "name" => "global_portfolio_content_position",
                "type" => "select",
                "instructions" => __( 'Choose WPBakery Page Builder page content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "top" => __( 'Top - Before Portfolio', 'stockie' ),
                    "bottom" => __( 'Bottom - After Portfolio', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59fb4334b343615",
                "label" => __( 'Category filter', 'stockie' ),
                "name" => "global_project_show_filter",
                "type" => "true_false",
                "instructions" => __( 'Show category filter on portfolio pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_59fb43341343615",
                "label" => __( 'Category filter text color', 'stockie' ),
                "name" => "global_project_filter_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose category filter text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fb4334b343615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59fb43342343615",
                "label" => __( 'Category filter accent color', 'stockie' ),
                "name" => "global_project_filter_accent_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose category filter accent color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fb4334b343615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59fb4334b433615",
                "label" => __( 'Category filter position', 'stockie' ),
                "name" => "global_portfolio_filter_align",
                "type" => "select",
                "instructions" => __( 'Choose category filter position for portfolio pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59fb4334b343615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "left" => "Left",
                    "center" => "Center",
                    "right" => "Right"
                ],
                "default_value" => [
                    "center"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59fb4334a433615",
                "label" => __( 'Portfolio items per page', 'stockie' ),
                "name" => "global_portfolio_projects_per_page",
                "type" => "number",
                "instructions" => __( 'Choose number of portfolio items per page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => 12,
                "placeholder" => "",
                "prepend" => "",
                "append" => __( 'projects', 'stockie' ),
                "min" => 1,
                "max" => 250,
                "step" => 1
            ],
            [
                "key" => "field_59fb4334fd33615",
                "label" => __( 'Pagination', 'stockie' ),
                "name" => "global_portfolio_pagination_type",
                "type" => "select",
                "instructions" => __( 'Choose pagination type for portfolio page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "simple" => __( 'Simple', 'stockie' ),
                    "lazy_scroll" => __( 'Lazy load', 'stockie' ),
                    "lazy_button" => __( 'Load more', 'stockie' )
                ],
                "default_value" => [
                    "simple"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59fb4334bgdasdf33615",
                "label" => __( 'Pagination position', 'stockie' ),
                "name" => "global_portfolio_pagination_position",
                "type" => "select",
                "instructions" => __( 'Choose pagination position for portfolio page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59fb4432b343615",
                "label" => __( 'Sidebar', 'stockie' ),
                "name" => "global_portfolio_page_sidebar",
                "type" => "radio",
                "instructions" => __( 'Choose sidebar position for portfolio pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "right" => __( 'Right', 'stockie' ),
                    "without" => __( 'Disable', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fe44346937d",
                "label" => __( 'Project Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592fd6662265c",
                "label" => __( 'Single project layout', 'stockie' ),
                "name" => "global_project_layout_type",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for project pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "type_1",
                        "description" => __( 'Classic with Left Image', 'stockie' ),
                        "src" => "acf__image_27.svg"
                    ],
                    [
                        "name" => "type_2",
                        "description" => __( 'Classic with Right Image', 'stockie' ),
                        "src" => "acf__image_26.svg"
                    ],
                    [
                        "name" => "type_3",
                        "description" => __( 'Split Screen Left Image', 'stockie' ),
                        "src" => "acf__image_29.svg"
                    ],
                    [
                        "name" => "type_4",
                        "description" => __( 'Split Screen Right Image', 'stockie' ),
                        "src" => "acf__image_28.svg"
                    ],
                    [
                        "name" => "type_5",
                        "description" => __( 'Light Details Intro', 'stockie' ),
                        "src" => "acf__image_30.svg"
                    ]
                ],
                "default_value" => "type_1"
            ],
            [
                "key" => "field_59fb4334bgdf3615",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_project_page_is_wrapped",
                "type" => "radio",
                "instructions" => __( 'Add content wrapper to project pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deb03738",
                            "operator" => "!=",
                            "value" => "yes"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" =>  __( 'Use from Page Settings', 'stockie' ),
                    "yes" =>  __( 'Enable', 'stockie' ),
                    "no" =>  __( 'Disable', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_591ac519d31f3",
                "label" => __( 'Content wrapper width', 'stockie' ),
                "name" => "global_project_content_wrapper_width",
                "type" => "text",
                "instructions" => __( 'Define container wrapper width', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "1326px",
                "prepend" => __( 'Use CSS units', 'stockie' ),
                "append" => "",
                "maxlength" => 200
            ],
            [
                "key" => "field_591b10dbb4a85234e3453",
                "label" => __( 'Full-width wrapper side margins', 'stockie' ),
                "name" => "global_project_full_width_margins_size",
                "type" => "text",
                "instructions" => __( 'Define side margins for full-width page container', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => __( 'Use CSS units', 'stockie' ),
                "append" => "",
                "maxlength" => 200
            ],
            [
                "key" => "field_59fb433fbgd33615",
                "label" => __( 'Boxed page layout', 'stockie' ),
                "name" => "global_project_page_use_boxed_wrapper",
                "type" => "radio",
                "instructions" => __( 'Wrap all project pages in boxed container', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59fb4334asdd33615",
                "label" => __( 'Content padding', 'stockie' ),
                "name" => "global_project_page_add_top_padding",
                "type" => "radio",
                "instructions" => __( 'Add top and bottom padding for project page content', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592fd66622a31",
                "label" => __( 'Navigation', 'stockie' ),
                "name" => "global_project_show_navigation",
                "type" => "select",
                "instructions" => __( 'Choose portfolio navigation type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "none" => __( 'Without Navigation', 'stockie' ),
                    "prev_n_next" => __( 'Next and Prev', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "none",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592fd66622a31amod",
                "label" => __( 'Navigation position', 'stockie' ),
                "name" => "global_project_navigation_position",
                "type" => "select",
                "instructions" => __( 'Choose portfolio navigation position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd66622a31",
                            "operator" => "==",
                            "value" => "prev_n_next"
                        ],
                        [
                            "field" => "field_592fd6662265c",
                            "operator" => "!=",
                            "value" => "type_7"
                        ]
                    ]
                ],
                "choices" => [
                    "top" => __( 'Top - Before content', 'stockie' ),
                    "bottom" => __( 'Bottom - After content', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "bottom",
                "layout" => "vertical",
                "return_format" => "value"
            ],
            [
                "key" => "field_592fd66622a41amodbgg",
                "label" => __( 'Custom content position', 'stockie' ),
                "name" => "global_project_custom_content_position",
                "type" => "select",
                "instructions" => __( 'Choose custom content position', 'stockie' ),
                "required" => 0,
                "choices" => [
                    "top" => __( 'Top - Before Content', 'stockie' ),
                    "after_description" => __( 'Center - After Description', 'stockie' ),
                    "bottom" => __( 'Bottom - After Content', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "top",
                "layout" => "vertical",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937a1a521s81ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<h4>' . __( 'Page Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593923440171e",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "global_project_page_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose background type for project page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "color" => __( 'Background Color', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5939023423b57",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_project_page_background_image",
                "type" => "image",
                "instructions" => __( 'Custom background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_5939asdfasdf1f80",
                "label" => __( 'Background image size', 'stockie' ),
                "name" => "global_project_page_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "auto"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390de23342387",
                "label" => __( 'Background image position', 'stockie' ),
                "name" => "global_project_page_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5939asdfasdf1f80",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ],
                    [
                        [
                            "field" => "field_5939asdfasdf1f80",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593923b02758",
                "label" => __( 'Background image repeat', 'stockie' ),
                "name" => "global_project_page_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose background image repeat type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5939asdfasdf1f80",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ],
                    [
                        [
                            "field" => "field_5939asdfasdf1f80",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59390asd02b58",
                "label" => __( 'Background attachment', 'stockie' ),
                "name" => "global_project_page_background_is_attached",
                "type" => "true_false",
                "instructions" => __( 'You can fix background image on this page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59390d23402f35",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_project_page_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Custom background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593923440171e",
                            "operator" => "==",
                            "value" => "color"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_592fe6166937e",
                "label" => __( 'Page Headline', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5931067c175b5",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_project_header_use_hero",
                "type" => "radio",
                "instructions" => __( 'Hide page headline from project pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59310b5b35a20",
                "label" => __( 'Height settings', 'stockie' ),
                "name" => "global_project_header_title_height_settings",
                "type" => "radio",
                "instructions" => __( 'Choose height type for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593105ee5d7af",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_project_header_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up page headline height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59310b5b35a20",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593105d65d7ae",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593105d65d7ae",
                "label" => __( 'Fullscreen height', 'stockie' ),
                "name" => "global_project_title_height_fullscreen",
                "type" => "true_false",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_593102f7b99f7",
                "label" => __( 'Content position', 'stockie' ),
                "name" => "global_portfolio_header_title_align",
                "type" => "radio",
                "instructions" => __( 'Choose page headline content position for project pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fe6df9bea5",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "global_portfolio_header_title_type",
                "type" => "radio",
                "instructions" => __( 'Choose background type for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "color" => __( 'Background Color', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fe7d7fe779",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_portfolio_title_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_592fe81e4e6d1",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_portfolio_title_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_593019c8e452c",
                "label" => __( 'Background image size', 'stockie' ),
                "name" => "global_portfolio_title_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593025e5dbc6f",
                "label" => __( 'Background image position', 'stockie' ),
                "name" => "global_portfolio_title_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "inherit"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "inherit"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [
                    "center"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5930285d3f1ff",
                "label" => __( 'Background image repeat', 'stockie' ),
                "name" => "global_portfolio_title_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose background image repeat type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "inherit"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "inherit"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593019c8e452c",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593029f1e5302",
                "label" => __( 'Background overlay', 'stockie' ),
                "name" => "global_portfolio_use_title_overlay",
                "type" => "radio",
                "instructions" => __( 'Add colored overlay over background image?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "inherit"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59302aa9e5304",
                "label" => __( 'Background overlay color', 'stockie' ),
                "name" => "global_portfolio_title_background_overlay_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background overlay color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "inherit"
                        ],
                        [
                            "field" => "field_593029f1e5302",
                            "operator" => "==",
                            "value" => "yes"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592fe6df9bea5",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593029f1e5302",
                            "operator" => "==",
                            "value" => "yes"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_5931041de1845",
                "label" => __( 'Typography settings', 'stockie' ),
                "name" => "global_portfolio_typography_settings",
                "type" => "radio",
                "instructions" => __( 'Set up typography for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593105045d7ac",
                "label" => __( 'Title settings', 'stockie' ),
                "name" => "global_project_header_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for hero titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5931041de1845",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_5931058d5d7ad",
                "label" => __( 'Subtitle settings', 'stockie' ),
                "name" => "global_project_header_subtitle_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for subtitles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5931041de1845",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592fe61fd937e",
                "label" => __( 'Other', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5936a7a521481ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<h4>' . __( 'Sharing Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_592fd666231f2",
                "label" => __( 'Sharing', 'stockie' ),
                "name" => "global_project_hide_sharing_buttons",
                "type" => "true_false",
                "instructions" => __( 'Disable sharing feature for project pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No",
                "message" => "",
                "default_value" => 0
            ],
            [
                "key" => "field_592fd666235d9",
                "label" => __( 'Sharing networks', 'stockie' ),
                "name" => "global_project_social_sharing_buttons",
                "type" => "select",
                "instructions" => __( 'Choose sharing social networks', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd666231f2",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "facebook" => "Facebook",
                    "twitter" => "Twitter",
                    "pinterest" => "Pinterest",
                    "linkedin" => "LinkedIn"
                ],
                "default_value" => [],
                "allow_null" => 0,
                "multiple" => 1,
                "ui" => 1,
                "ajax" => 1,
                "return_format" => "value",
                "placeholder" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-portfolio"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;
