<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_591ac509c1730",
        "title" => __( 'Page Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_591b002d481fc",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a52b48cexmod153",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_591ac509d31f3",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_page_is_wrapped",
                "type" => "true_false",
                "instructions" => __( 'Add content wrapper to all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59381c77504b1",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_591ac5s9d31f3",
                "label" => __( 'Content wrapper width', 'stockie' ),
                "name" => "global_content_wrapper_width",
                "type" => "text",
                "instructions" => __( 'Define container wrapper width', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "1326px",
                "prepend" => __( 'Use CSS units', 'stockie' ),
                "append" => "",
                "maxlength" => 200
            ],
            [
                "key" => "field_591b10dbb4a85_fwgaps",
                "label" => __( 'Full-width layout spacing', 'stockie' ),
                "name" => "global_full_width_margins_size",
                "type" => "text",
                "instructions" => __( 'Define side margins for full-width page container', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => __( 'Use CSS units', 'stockie' ),
                "append" => "",
                "maxlength" => 200
            ],
            [
                "key" => "field_591ac509d3606",
                "label" => __( 'Content padding', 'stockie' ),
                "name" => "global_page_add_top_padding",
                "type" => "true_false",
                "instructions" => __( 'Add top and bottom padding for page content', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No",
                "message" => "",
                "default_value" => 1
            ],
            [
                "key" => "field_59381c77504b1",
                "label" => __( 'Boxed page layout', 'stockie' ),
                "name" => "global_page_use_boxed_wrapper",
                "type" => "true_false",
                "instructions" => __( 'Wrap all pages in boxed container', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_591ac509d1208",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_page_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_591ac509cfdd8",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_page_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_591ac509d01a8",
                "label" => __( 'Background size', 'stockie' ),
                "name" => "global_page_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100_per" => __( '100% 100%', 'stockie' ),
                ],
                "default_value" => [
                    "auto"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_591ac509d05b5",
                "label" => __( 'Background position', 'stockie' ),
                "name" => "global_page_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [
                    "center"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_591ac509d09b7",
                "label" => __( 'Background repeat', 'stockie' ),
                "name" => "global_page_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose repeat type for background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_591ac509d0dce",
                "label" => __( 'Background attachment', 'stockie' ),
                "name" => "global_page_background_attach",
                "type" => "true_false",
                "instructions" => __( 'Fix background image for all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],


            [
                "key" => "field_59229bda372c9",
                "label" => __( 'Page Headline', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59229bda38e8d",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_header_use_hero",
                "type" => "true_false",
                "instructions" => __( 'Hide page headline from all pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59229bda3868f",
                "label" => __( 'Fullscreen height', 'stockie' ),
                "name" => "global_header_height_fullscreen",
                "type" => "true_false",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59229bda38a78",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_header_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up page headline height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3868f",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59229e431eaea",
                "label" => __( 'Content position', 'stockie' ),
                "name" => "global_header_title_align",
                "type" => "radio",
                "instructions" => __( 'Choose page headline content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "left",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5922a0ea1eaeb",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "global_header_title_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose background type for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "color" => __( 'Background Color', 'stockie' ),
                    "image" => __( 'Custom Image', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59229bda37ea5",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_header_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5922a0ea1eaeb",
                            "operator" => "==",
                            "value" => "color"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_5922a2fd080e8",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_header_title_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5922a0ea1eaeb",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_5922a6390c4a9",
                "label" => __( 'Background image size', 'stockie' ),
                "name" => "global_header_title_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5922a0ea1eaeb",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "auto"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5922a7500579b",
                "label" => __( 'Background image position', 'stockie' ),
                "name" => "global_header_title_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5922a0ea1eaeb",
                            "operator" => "==",
                            "value" => "image"
                        ],
                        [
                            "field" => "field_5922a6390c4a9",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_5922a0ea1eaeb",
                            "operator" => "==",
                            "value" => "image"
                        ],
                        [
                            "field" => "field_5922a6390c4a9",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [
                    "center"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5922ab31f19b0",
                "label" => __( 'Background image repeat', 'stockie' ),
                "name" => "global_header_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose background image repeat type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5922a0ea1eaeb",
                            "operator" => "==",
                            "value" => "image"
                        ],
                        [
                            "field" => "field_5922a6390c4a9",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_5922a0ea1eaeb",
                            "operator" => "==",
                            "value" => "image"
                        ],
                        [
                            "field" => "field_5922a6390c4a9",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59229bda376e8",
                "label" => __( 'Background overlay', 'stockie' ),
                "name" => "global_header_use_overlay",
                "type" => "true_false",
                "instructions" => __( 'Add colored overlay over background image?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59229bda37acf",
                "label" => __( 'Background overlay color', 'stockie' ),
                "name" => "global_header_overlay_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background overlay color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda376e8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_5922qef4g4376e8",
                "label" => __( 'Go back button', 'stockie' ),
                "name" => "global_header_previous_button",
                "type" => "true_false",
                "instructions" => __( 'Add back link button to previous page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
                    [
                "key" => "field_59256hderger8",
                "label" => __( 'Go back button text', 'stockie' ),
                "name" => "global_header_previous_button_text",
                "type" => "text",
                "instructions" => __( 'Add text for previous button', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5922qef4g4376e8",
                            "operator" => "==",
                            "value" => "1"   
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => "Back",
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59223452345a3827b",
                "label" => __( 'Go back button typography', 'stockie' ),
                "name" => "global_header_back_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for go back button', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59229bda3827b",
                "label" => __( 'Title typography', 'stockie' ),
                "name" => "global_header_tilte_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for hero titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59229d1dd0a61",
                "label" => __( 'Subtitle typography', 'stockie' ),
                "name" => "global_header_subtilte_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for subtitles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_591b0f20ed84s",
                "label" => __( 'Page Sidebar', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59390deaf218c",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_page_sidebar",
                "type" => "radio",
                "instructions" => __( 'Enable sidebar on all pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "without" => __( 'Disable', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59392223423434234c",
                "label" => __( 'Sidebar layout', 'stockie' ),
                "name" => "global_page_sidebar_layout",
                "type" => "select",
                "instructions" => __( 'Choose sidebar layout', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59390deaf218c",
                            "operator" => "!=",
                            "value" => "without"
                        ]
                    ]
                ],
                "choices" => [
                    "simple" => "Simple",
                    "boxed" => "Boxed"
                ],
                "default_value" => [
                    "simple"
                ],
                "return_format" => "value"
            ],
            [
                "key" => "field_5937e3a33b3exmod15",
                "label" => __( 'Sidebar widget heading', 'stockie' ),
                "name" => "global_widgets_heading_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography styles for widget heading', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_5937e3a33f4exmod15",
                "label" => __( 'Sidebar widget content', 'stockie' ),
                "name" => "global_widgets_content_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography styles for widget content', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_591b0f20ed84e",
                "label" => __( 'Breadcrumbs', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_591ac509d29ee",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_page_show_breadcrumbs",
                "type" => "true_false",
                "instructions" => __( 'Show breadcrumbs on all pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_591b10dbb4a85",
                "label" => __( 'Separator', 'stockie' ),
                "name" => "global_breadcrumbs_separator",
                "type" => "text",
                "instructions" => __( 'Use custom HTML or UTF-8 symbols. Slashes or arrows are recommended', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => 250
            ],
            [
                "key" => "field_591ac509d2e0d",
                "label" => __( 'Home slug', 'stockie' ),
                "name" => "global_page_show_home_breadcrumb",
                "type" => "true_false",
                "instructions" => __( 'Show <em>"Home /")</em> slug in breadcrumbs', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_591ef0e8d845b",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_breadcrumbs_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose breadcrumbs bar background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_591ef10cd845c",
                "label" => __( 'Text color', 'stockie' ),
                "name" => "global_breadcrumbs_font_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose breadcrumbs text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-pages"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;