<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_5946362bf373c5",
        "title" => __( 'Other', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_542244d4313bf",
                "label" => __( 'Plugins', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937a0a521481ebmod23",
                "label" => __( '', 'stockie' ),
                "name" => "",
                "type" => "message",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Google Maps', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_592fe13500023",
                "label" => __( 'Google Maps API key', 'stockie' ),
                "name" => "global_google_maps_api_key",
                "type" => "text",
                "instructions" => __( 'Paste your Google Maps API key here.<br> <a target="_blank" href="https://developers.google.com/maps/documentation/javascript/get-api-key">How to get your API key</a>', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "Paste your key",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_542244d4343bf",
                "label" => __( 'Custom JS', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a32b48cexmod151",
                "label" => __( '', 'stockie' ),
                "name" => "",
                "type" => "message",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . __( 'Note, that you can update the theme without losing the code injected.', 'stockie' ) . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_5937e3a43b383415",
                "label" => __( 'Header JavaScript injection', 'stockie' ),
                "name" => "global_header_javascript",
                "type" => "stockie_code",
                "instructions" => __( 'Paste your Google Analytics, Facebook Pixel or custom tracking code', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "language" => "javascript"
            ],
            [
                "key" => "field_5937e4a43b383415",
                "label" => __( 'Footer JavaScript injection', 'stockie' ),
                "name" => "global_footer_javascript",
                "type" => "stockie_code",
                "instructions" => __( 'Paste your Google Analytics, Facebook Pixel or custom tracking code', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "language" => "javascript"
            ],
            [
                "key" => "field_591b056456481fcffmod",
                "label" => __( 'Subscribe Pop-Up', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5222e34430vve4od8",
                "label" => __( 'Subscribe pop-up', 'stockie' ),
                "name" => "global_subscribe_popup_switch",
                "type" => "true_false",
                "instructions" => __( 'Enable subscribe pop-up', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_5222we220vvge1od8",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_subscribe_popup_switch_background_image",
                "type" => "true_false",
                "instructions" => __( 'Enable background image for pop-up', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_5456ai4d080e8",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_subcribe_popup_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for pop-up', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222we220vvge1od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_59229bda33b3d",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_subcribe_popup_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose pop-up background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_5937895484415",
                "label" => __( 'Subscribe form', 'stockie' ),
                "name" => "global_subscribe_choice_of_forms",
                "type" => "post_object",
                "post_type" => [
                    "wpcf7_contact_form"
                ],
                "instructions" => __( 'Choose', 'stockie') . '&nbsp;<a target="_blank" href="/wp-admin/admin.php?page=wpcf7">' . __( 'Contact Form 7', 'stockie') . '&nbsp;</a>' . __( 'form for subscribtion', 'stockie') . '<em>&nbsp;' . __( '(Use pre-made forms only)', 'stockie') . '</em>',
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "id",
                "placeholder" => ""
            ],
            [
                "key" => "field_592gh23s3500c30",
                "label" => __( 'Heading text', 'stockie' ),
                "name" => "global_text_subcribe_popup",
                "type" => "text",
                "instructions" => __( 'Enter heading for your subscribe pop-up', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => "Subscribe to our newsletter",
                "message" => "",
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592g223s3500c30",
                "label" => __( 'Details text', 'stockie' ),
                "name" => "global_details_text_subcribe_popup",
                "type" => "textarea",
                "instructions" => __( 'Enter details about subscription terms', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => "Sign up to receive updates, promotions, and sneak peaks of upcoming products. Plus 20% off your next order.",
                "message" => "",
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592fgj993827b",
                "label" => __( 'Heading typography', 'stockie' ),
                "name" => "global_subcribe_popup_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography styles for pop-up heading', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592fg8883827b",
                "label" => __( 'Details text settings', 'stockie' ),
                "name" => "global_details_text_subcribe_popup_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography styles for pop-up details', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592s33s15af5g8t",
                "label" => '<h4>' . __( 'Display Settings', 'stockie') . '</h4>',
                "name" => "",
                "type" => "message",
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ]
            ],
            [
                "key" => "field_59229bda31f95_sbscr",
                "label" => __( 'Pop-up triggers', 'stockie' ),
                "name" => "global_subscribe_popup_display_trigger",
                "type" => "radio",
                "instructions" => __( 'Select one of the ways to display modal', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "time" => __( 'Time', 'stockie' ),
                    "scroll" => __( 'Page scroll', 'stockie' ),
                    "exit" => __( 'Exit intent', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "no",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_3337773s3500c30",
                "label" => __( 'Show pop-up delay', 'stockie' ),
                "name" => "global_delay_subcribe_popup",
                "type" => "text",
                "instructions" => __( 'Here goes a description', 'stockie' ),
                "required" => 0,
                "append" => __( 'seconds', 'stockie' ),
                "conditional_logic" =>
                [
                    [
                        [
                            "field" => "field_59229bda31f95_sbscr",
                            "operator" => "==",
                            "value" => "time"
                        ]
                    ]
                ],
                "message" => "",
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_58351fsa421j1265",
                "label" => __( 'Show after page scrolled', 'stockie' ),
                "name" => "global_subscribe_popup_scroll_percent",
                "type" =>"text",
                "instructions" => __( 'Define the percentage of page height for a popup to be shown', 'stockie' ),
                "required" => 0,
                "append" => __( '%', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda31f95_sbscr",
                            "operator" => "==",
                            "value" => "scroll"
                        ]
                    ]
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "maxlength" => "2",
                "placeholder" => ""
            ],
            [
                "key" => "field_58383c7ed01ae_sbscr",
                "label" => __( 'Expires', 'stockie' ),
                "name" => "global_subscribe_popup_expires",
                "type" =>"text",
                "instructions" => __( 'After expiry, user will see the subscribe pop-up again', 'stockie' ),
                "required" => 1,
                "append" => __( 'days', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5222e34430vve4od8",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "maxlength" => "2",
                "placeholder" => ""
            ],
            [
                "key" => "field_591b002d481fcff56",
                "label" => __( 'Social Networks', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59223523535423",
                "label" => '<h4>' . __( 'Follow Networks', 'stockie') . '</h4>',
                "name" => "",
                "type" => "message",
                "conditional_logic" => 0,
            ],
            [
                "key" => "field_snlid", // old field_59229bda366f4mod
                "label" => __( 'Social networks list', 'stockie' ),
                "name" => "global_header_menu_social_links",
                "type" => "repeater",
                "instructions" => __( 'Choose social networks to be displayed on your website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe1350456235",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "collapsed" => "",
                "min" => 0,
                "max" => 6,
                "layout" => "table",
                "button_label" => __( '+ Add social network', 'stockie' ),
                "sub_fields" => [
                    [
                        "key" => "insnsn", // old field_59229bda7b686moddd
                        "label" => __( 'Direction', 'stockie' ),
                        "name" => "social_network",
                        "type" => "select",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "choices" => [
                            "artstation" => __( 'Artstation', 'stockie' ),
                            "behance" => __( 'Behance', 'stockie' ),
                            "deviantart" => __( 'DeviantArt', 'stockie' ),
                            "digg" => __( 'Digg', 'stockie' ),
                            "discord" => __( 'Discord', 'stockie' ),
                            "dribbble" => __( 'Dribbble', 'stockie' ),
                            "facebook" => __( 'Facebook', 'stockie' ),
                            "flickr" => __( 'Flickr', 'stockie' ),
                            "github" => __( 'GitHub', 'stockie' ),
                            "houzz" => __( 'Houzz', 'stockie' ),
                            "instagram" => __( 'Instagram', 'stockie' ),
                            "kaggle" => __( 'Kaggle', 'stockie' ),
                            "linkedin" => __( 'LinkedIn', 'stockie' ),
                            "medium" => __( 'Medium', 'stockie' ),
                            "mixer" => __( 'Mixer', 'stockie' ),
                            "pinterest" => __( 'Pinterest', 'stockie' ),
                            "producthunt" => __( 'Product Hunt', 'stockie' ),
                            "quora" => __( 'Quora', 'stockie' ),
                            "reddit" => __( 'Reddit', 'stockie' ),
                            "snapchat" => __( 'Snapchat', 'stockie' ),
                            "soundcloud" => __( 'SoundCloud', 'stockie' ),
                            "spotify" => __( 'Spotify', 'stockie' ),
                            "teamspeak" => __( 'Teamspeak', 'stockie' ),
                            "telegram" => __( 'Telegram', 'stockie' ),
                            "threads" => __( 'Threads', 'stockie' ),
                            "tiktok" => __( 'TikTok', 'stockie' ),
                            "tumblr" => __( 'Tumblr', 'stockie' ),
                            "twitch" => __( 'Twitch', 'stockie' ),
                            "twitter" => __( 'Twitter', 'stockie' ),
                            "vimeo" => __( 'Vimeo', 'stockie' ),
                            "vine" => __( 'Vine', 'stockie' ),
                            "whatsapp" => __( 'WhatsApp', 'stockie' ),
                            "xing" => __( 'Xing', 'stockie' ),
                            "youtube" => __( 'YouTube', 'stockie' ),
                            "500px" => __( '500px', 'stockie')
                        ],
                        "default_value" => [],
                        "allow_null" => 0,
                        "multiple" => 0,
                        "ui" => 0,
                        "ajax" => 0,
                        "return_format" => "value",
                        "placeholder" => ""
                    ],
                    [
                        "key" => "insnurl", // old field_59229bda7ba5ajhghjhg
                        "label" => __( 'URL', 'stockie' ),
                        "name" => "url",
                        "type" => "url",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "default_value" => "",
                        "placeholder" => ""
                    ]
                ]
            ],
            [
                "key" => "field_59223523535424",
                "label" => '<h4>' . __( 'Sharing Networks', 'stockie') . '</h4>',
                "name" => "",
                "type" => "message",
                "conditional_logic" => 0,
            ],
            [
                "key" => "field_59374a3443db361523f",
                "label" => __( 'Sharing', 'stockie' ),
                "name" => "global_side_panel_social_enable",
                "type" => "true_false",
                "instructions" => __( 'Enable sharing feature for product pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592fd666235d9mod2",
                "label" => __( 'Sharing networks', 'stockie' ),
                "name" => "global_side_panel_social",
                "type" => "select",
                "instructions" => __( 'Choose sharing social networks', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [],
                "choices" => [
                    "facebook" => "Facebook",
                    "twitter" => "Twitter",
                    "dribbble" => "Dribbble",
                    "linkedin" => "LinkedIn",
                    "pinterest" => "Pinterest"
                ],
                "default_value" => [],
                "allow_null" => 0,
                "multiple" => 1,
                "ui" => 1,
                "ajax" => 1,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_591ac509d0dcemod8",
                "label" => __( 'Sharing on mobile', 'stockie' ),
                "name" => "global_side_panel_show_share_on_mobile",
                "type" => "true_false",
                "instructions" => __( 'Show share button on mobile devices', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_591ac509cmmod",
                "label" => __( 'Content color', 'stockie' ),
                "name" => "global_side_panel_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose panel text and icons color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_542244d4343hg",
                "label" => __( 'Notification Bar', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => __( '', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592fe13500qwedqwxs",
                "label" => __( 'Notification Bar', 'stockie' ),
                "name" => "global_notification_bar",
                "type" => "true_false",
                "instructions" => __( 'Enable notification bar on your website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592fe13500hjbh",
                "label" => __( 'Notification details', 'stockie' ),
                "name" => "global_notification_text",
                "type" => "text",
                "instructions" => __( 'Paste your notification text here', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500qwedqwxs",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_583592feа12as98holrv",
                "label" => __( 'Text color', 'stockie' ),
                "name" => "global_subscribe_popup_color",
                "type" =>"stockie_color",
                "instructions" => __( 'Choose color for notification details', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500qwedqwxs",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "ui" => 0,
                "ajax" => 0,
                "placeholder" => ""
            ],
            [
                "key" => "field_592fe135002542tgs",
                "label" => __( 'Notification details link', 'stockie' ),
                "name" => "global_notification_link",
                "type" => "true_false",
                "instructions" => __( 'Enable notification link', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500qwedqwxs",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592feа125350234df2",
                "label" => __( 'Notification link', 'stockie' ),
                "name" => "global_notification_link",
                "type" => "link",
                "instructions" => __( 'Set up notification link', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe135002542tgs",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592fe13500asdas",
                "label" => __( 'Notification button', 'stockie' ),
                "name" => "global_notification_button",
                "type" => "true_false",
                "instructions" => __( 'Enable notification button', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500qwedqwxs",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592feа125350kasdgh",
                "label" => __( 'Button link', 'stockie' ),
                "name" => "global_notification_button_link",
                "type" => "link",
                "instructions" => __( 'Set up button link', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500asdas",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_583592feа12asdf435e",
                "label" => __( 'Expires', 'stockie' ),
                "name" => "global_subscribe_popup_expires",
                "type" =>"text",
                "instructions" => __( 'After expiry, user will see the notification bar again', 'stockie' ),
                "required" => 0,
                "append" => __( 'days', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500qwedqwxs",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => "360",
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "maxlength" => "2",
                "placeholder" => ""
            ],
            [
                "key" => "field_583592feа12asdf4asfasf",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_subscribe_popup_background",
                "type" =>"stockie_color",
                "instructions" => __( 'Choose background color for notification', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500qwedqwxs",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "ui" => 0,
                "ajax" => 0,
                "placeholder" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-other"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;