<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_59229bda27se2",
        "title" => __( 'Menu Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_59221bda313bf",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937easfasf15",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie' ) . '</p>',

                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59229bda3374d",
                "label" => __( 'Menu type', 'stockie' ),
                "name" => "global_menu_type",
                "type" => "radio",
                "instructions" => __( 'Choose menu type for all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "full" => __( 'Regular Menu', 'stockie' ),
                    "hamburger" => __( 'Hamburger Menu', 'stockie' ),
                    "both" => __( 'Both', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "full",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59229bda31ауеmod",
                "label" => __( 'Extended menu', 'stockie' ),
                "name" => "global_extended_menu",
                "type" => "stockie_menu",
                "instructions" => __( 'Choose from already pre-made menus', 'stockie' ) . '&nbsp;<em>( ' . __( 'Appearance', 'stockie' ) . '&nbsp;>&nbsp;' . '<a target="_blank" href="./nav-menus.php">' . __( 'Menus', 'stockie' ) . '</a>)</em>',
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3374d",
                            "operator" => "!=",
                            "value" => "hamburger"
                        ]
                    ]
                ],
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229asf124а11ауеmod",
                "label" => __( 'Hamburger menu', 'stockie' ),
                "name" => "global_hamburger_menu",
                "type" => "stockie_menu",
                "instructions" => __( 'Choose from already pre-made menus', 'stockie' ) . '&nbsp;<em>( ' . __( 'Appearance', 'stockie' ) . '&nbsp;>&nbsp;' . '<a target="_blank" href="./nav-menus.php">' . __( 'Menus', 'stockie' ) . '</a>)</em>',
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3374d",
                            "operator" => "!=",
                            "value" => "full"
                        ]
                    ]
                ],
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bsa31d56",
                "label" => __( 'Hamburger menu position', 'stockie' ),
                "name" => "global_page_header_menu_position",
                "type" => "select",
                "instructions" => __( 'Choose hamburger position for all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3374d",
                            "operator" => "!=",
                            "value" => "full"
                        ]
                    ]
                ],
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "right" => __( 'Right', 'stockie' ),
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59229bsa3110874uj",
                "label" => __( 'Hamburger mobile menu position', 'stockie' ),
                "name" => "global_page_header_mobile_menu_position",
                "type" => "select",
                "instructions" => __( 'Choose hamburger mobile position for all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3374d",
                            "operator" => "!=",
                            "value" => "full"
                        ]
                    ]
                ],
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "right" => __( 'Right', 'stockie' ),
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59229bda317ae_modd",
                "label" => __( 'Overlay menu layout', 'stockie' ),
                "name" => "global_fullscreen_menu_style",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for overlay menu', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3374d",
                            "operator" => "!=",
                            "value" => "full"
                        ]
                    ]
                ],
                "choices" => [
                    "default" => __( 'Default', 'stockie' ),
                    "centered" => __( 'Centered', 'stockie' ),
                    "split" => __( 'Compact', 'stockie' ),
                ],
                "image_option_value" => [
                    [
                        "name" => "default",
                        "description" => __( 'Default', 'stockie' ),
                        "src" => "acf__image_31.svg"
                    ],
                    [
                        "name" => "centered",
                        "description" => __( 'Centered', 'stockie' ),
                        "src" => "acf__image_32.svg"
                    ],
                    [
                        "name" => "split",
                        "description" => __( 'Compact', 'stockie' ),
                        "src" => "acf__image_33.svg"
                    ]
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => [
                    "default"
                ],
                "layout" => "vertical",
                "return_format" => "value",
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "placeholder" => ""
            ],
            [
                "key" => "field_59229bda33b33dandmod",
                "label" => __( 'Overlay menu background', 'stockie' ),
                "name" => "global_fullscreen_menu_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose overlay background color', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3374d",
                            "operator" => "==",
                            "value" => "hamburger"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style3"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style4"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style5"
                        ]
                    ]
                ],
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda33f44867i7a6",
                "label" => __( 'Overlay menu typography', 'stockie' ),
                "name" => "global_fullscreen_menu_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography styles for fullscreen menu', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda3374d",
                            "operator" => "==",
                            "value" => "hamburger"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style3"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style4"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style5"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59229bda33f44",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "global_header_menu_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for header', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59374453f44415",
                "label" => __( 'Menu counter', 'stockie' ),
                "name" => "global_header_counters_visibility",
                "type" => "true_false",
                "instructions" => __( 'Show counter on multi level menu', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59221bd413bf",
                "label" => __( 'Mobile Menu', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937445484415",
                "label" => __( 'Mobile menu position', 'stockie' ),
                "name" => "global_mobile_menu_position",
                "type" => "select",
                "instructions" => __( 'Choose mobile menu position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => "Slide from Left",
                    "right" => "Slide from Right"
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59267bda33b33234fd4",
                "label" => __( 'Mobile header menu color', 'stockie' ),
                "name" => "global_mobile_header_menu_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose color for header items', 'stockie' ),
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda33b33234fas",
                "label" => __( 'Mobile background color', 'stockie' ),
                "name" => "global_mobile_menu_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background overlay color', 'stockie' ),
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda36234d1",
                "label" => __( 'Mobile menu typography', 'stockie' ),
                "name" => "global_mobile_menu_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for mobile menu', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_5937445364415",
                "label" => __( 'Search visibility', 'stockie' ),
                "name" => "global_mobile_search_visibility",
                "type" => "true_false",
                "instructions" => __( 'Show search on mobile menu', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59374453a84415",
                "label" => __( 'Social icons position', 'stockie' ),
                "name" => "global_header_mobile_social_position",
                "type" => "select",
                "instructions" => __( 'Choose social icons location for mobile menu', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "default" => "Default",
                    "inside" => "Inside Overlay Menu"
                ],
                "default_value" => [
                    "default"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5941bd413bs",
                "label" => __( 'One Page Menu', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59229bda3432amods",
                "label" => __( 'One Page Menu', 'stockie' ),
                "name" => "global_header_onepage_mode",
                "type" => "true_false",
                "instructions" => __( 'Enable one page menu? Handle anchor links as section scroll trigger. Read', 'stockie' ) . '&nbsp;<a target="_blank" href="https://docs.clbthemes.com/ohio/tips-tricks/#onepage_menu">' . __( 'the setup guide', 'stockie' ) . '</a>',
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'stockie' ),
                "ui_off_text" => __( 'No', 'stockie' )
            ],
            [
                "key" => "field_5941bd413bf234",
                "label" => __( 'WPML', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592fe13500c38",
                "label" => __( 'WPML language switcher', 'stockie' ),
                "name" => "global_wpml_show_in_header",
                "type" => "true_false",
                "instructions" => __( 'Enable WPML language switcher', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_5941bd413bf",
                "label" => __( 'Other', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937sc63g152s346",
                "label" => '<h4>' . __( 'Search', 'stockie' ) . '</h4>',
                "name" => "",
                "type" => "message"
            ],
            [
                "key" => "field_592d43df9e26c",
                "label" => __( 'Search', 'stockie' ),
                "name" => "global_header_hide_search",
                "type" => "true_false",
                "instructions" => __( 'Hide the search icon on your website?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_5937sc63g152s346bth",
                "label" => '<h4>' . __( 'Menu Button', 'stockie' ) . '</h4>',
                "name" => "",
                "type" => "message"
            ],
            [
                "key" => "field_592fe13500c39",
                "label" => __( 'Menu button', 'stockie' ),
                "name" => "global_button_for_header",
                "type" => "true_false",
                "instructions" => __( 'Enable button in header', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592fe1ar3500c30",
                "label" => __( 'Menu button attributes', 'stockie' ),
                "name" => "global_link_header_button",
                "type" => "link",
                "instructions" => __( 'Set up button option', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fe13500c39",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-menu"
                ]
            ]
        ],
        "menu_order" => 1,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;
