<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_59229bda27ee2",
        "title" => __( 'Header Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_59229bda313bf",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a52b48cexmod15",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59229bda317ae",
                "label" => __( 'Header layout', 'stockie' ),
                "name" => "global_header_menu_style",
                "type" => "image_option",
                "instructions" => __( 'Choose header template', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "style1",
                        "description" => __( 'Default', 'stockie' ),
                        "src" => "acf__image_01.svg"
                    ],
                    [
                        "name" => "style3",
                        "description" => __( 'Top Logo', 'stockie' ),
                        "src" => "acf__image_03.svg"
                    ],
                    [
                        "name" => "style4",
                        "description" => __( 'Centered Menu', 'stockie' ),
                        "src" => "acf__image_04.svg"
                    ],
                    [
                        "name" => "style5",
                        "description" => __( 'Centered Logo', 'stockie' ),
                        "src" => "acf__image_05.svg"
                    ],
                    [
                        "name" => "style6",
                        "description" => __( 'Sidebar Menu', 'stockie' ),
                        "src" => "acf__image_06.svg"
                    ],
                    [
                        "name" => "style7",
                        "description" => __( 'Panel Menu', 'stockie' ),
                        "src" => "acf__image_07.svg"
                    ]
                ],
                "default_value" => "style1"
            ],
            [
                "key" => "field_59229bda31f95",
                "label" => __( 'Blank spacer under header', 'stockie' ),
                "name" => "global_header_menu_add_cap",
                "type" => "radio",
                "instructions" => __( 'We recommend use this setting for transparent and fixed header navigation', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style6"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style7"
                        ]
                    ]
                ],
                "choices" => [
                    "yes" => __( 'Add Spacer', 'stockie' ),
                    "no" => __( 'Don\'t Add Spacer', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "no",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59229bda31bb0",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_header_menu_use_wrapper",
                "type" => "true_false",
                "instructions" => __( 'Use header content wrapper', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592d3cfcc0e1c",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_header_menu_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up header height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style6"
                        ],
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style7"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda1s33b3d",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_header_menu_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose header background color', 'stockie' ),
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda34745",
                "label" => __( 'Bottom border', 'stockie' ),
                "name" => "global_header_menu_hide_border",
                "type" => "true_false",
                "instructions" => __( 'Hide bottom border from header?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59229bda34f19",
                "label" => __( 'Bottom border type', 'stockie' ),
                "name" => "global_header_menu_border_type",
                "type" => "select",
                "instructions" => __( 'Choose border stroke type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda34745",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "solid" => __( 'Solid', 'stockie' ),
                    "dashed" => __( 'Dashed', 'stockie' ),
                    "dotted" => __( 'Dotted', 'stockie' ),
                    "double" => __( 'Double', 'stockie' )
                ],
                "default_value" => [
                    "solid"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59229bda34b30",
                "label" => __( 'Bottom border color', 'stockie' ),
                "name" => "global_header_menu_border_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose bottom border color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda34745",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59224bda313bf",
                "label" => __( 'Sticky Header', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59229bda3432a",
                "label" => __( 'Sticky header', 'stockie' ),
                "name" => "global_header_menu_fixed",
                "type" => "true_false",
                "instructions" => __( 'Enable sticky header, when you scrolling the page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda317ae",
                            "operator" => "!=",
                            "value" => "style6"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593743a434383415",
                "label" => __( 'Sticky header on mobile', 'stockie' ),
                "name" => "global_header_mobile_menu_fixed",
                "type" => "true_false",
                "instructions" => __( 'Enable sticky header on mobile devices', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59374453f84415",
                "label" => __( 'Initial offset', 'stockie' ),
                "name" => "global_header_fixed_initial_offset",
                "type" => "number",
                "instructions" => __( 'Scroll position when sticky header begins to animate <em>(Use pixels)</em>', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "150",
                "placeholder" => "",
                "prepend" => "",
                "append" => "px",
                "min" => 1,
                "max" => 100000,
                "step" => ""
            ],
            [
                "key" => "field_5937433334383415",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_header_fixed_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up sticky header height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0
            ],
            [
                "key" => "field_593743334383415",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_header_fixed_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose sticky header background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda33f448347i7a6",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "global_header_fixed_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography styles for sticky header', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593744334383415",
                "label" => __( 'Bottom border', 'stockie' ),
                "name" => "global_fixed_header_menu_hide_border",
                "type" => "true_false",
                "instructions" => __( 'Hide bottom border from sticky header?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59374433f83415",
                "label" => __( 'Bottom border type', 'stockie' ),
                "name" => "global_fixed_header_menu_border_type",
                "type" => "select",
                "instructions" => __( 'Choose border stroke type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593744334383415",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "solid" => __( 'Solid', 'stockie' ),
                    "dashed" => __( 'Dashed', 'stockie' ),
                    "dotted" => __( 'Dotted', 'stockie' ),
                    "double" => __( 'Double', 'stockie' )
                ],
                "default_value" => [
                    "solid"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59374433f84415",
                "label" => __( 'Bottom border color', 'stockie' ),
                "name" => "global_fixed_header_menu_border_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose bottom border color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593744334383415",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda35325",
                "label" => __( 'Subheader', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59229bda35701",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_header_menu_hide_contacts_bar",
                "type" => "true_false",
                "instructions" => __( 'Hide subheader from all pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592d3dfbff372",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_subheader_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up subheader height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda366f4",
                "label" => __( 'Content items <em>(left side)</em>', 'stockie' ),
                "name" => "global_header_menu_subheader_items_left",
                "type" => "repeater",
                "instructions" => __( 'Add content items to subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "collapsed" => "",
                "min" => 0,
                "max" => 20,
                "layout" => "table",
                "button_label" => __( '+ Add item', 'stockie' ),
                "sub_fields" => [
                    [
                        "key" => "field_59229bda6c954",
                        "label" => __( 'Items list', 'stockie' ),
                        "name" => "items",
                        "type" => "text",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "wrapper" => [
                            "width" => "",
                            "class" => "",
                            "id" => ""
                        ],
                        "default_value" => "",
                        "placeholder" => "",
                        "prepend" => "",
                        "append" => "",
                        "maxlength" => 500
                    ]
                ]
            ],
            [
                "key" => "field_59229bda366f5",
                "label" => __( 'Content items <em>(right side)</em>', 'stockie' ),
                "name" => "global_header_menu_subheader_items_right",
                "type" => "repeater",
                "instructions" => __( 'Add content items to subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "collapsed" => "",
                "min" => 0,
                "max" => 20,
                "layout" => "table",
                "button_label" => __( '+ Add item', 'stockie' ),
                "sub_fields" => [
                    [
                        "key" => "field_59229bda6c955",
                        "label" => __( 'Items list', 'stockie' ),
                        "name" => "items",
                        "type" => "text",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "wrapper" => [
                            "width" => "",
                            "class" => "",
                            "id" => ""
                        ],
                        "default_value" => "",
                        "placeholder" => "",
                        "prepend" => "",
                        "append" => "",
                        "maxlength" => 500
                    ]
                ]
            ],
            [
                "key" => "field_59229bdasqw512g",
                "label" => __( 'Currency switcher', 'stockie' ),
                "name" => "global_woocommerce_header_currency_switcher",
                "type" => "true_false",
                "instructions" => __( 'Enable currency switcher in subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6dfsa4w",
                "label" => __( 'Language switcher', 'stockie' ),
                "name" => "global_woocommerce_header_lanhuage_switcher",
                "type" => "true_false",
                "instructions" => __( 'Enable language switcher in subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59229bda36adb",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_header_menu_contacts_bar_background",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for subheader ', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59229bda36ed1",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "global_header_menu_contacts_bar_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-header"
                ]
            ]
        ],
        "menu_order" => 1,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;
