<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_592d60af343c5",
        "title" => __( 'General Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_54224ad4313bf",
                "label" => __( 'Theme Styling', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a52b48cexmod151",
                "label" => __( '', 'stockie' ),
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_591ac509cfa00",
                "label" => __( 'Brand color', 'stockie' ),
                "name" => "global_page_brand_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose the accent color for your website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_5937e3a43b38cexmod15",
                "label" => __( 'Links color', 'stockie' ),
                "name" => "global_page_links_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose the color for your website links', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_5937e3a43b38234",
                "label" => __( 'Buttons color', 'stockie' ),
                "name" => "global_page_buttons_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose the color for your website buttons', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_5937e3a33b35exmod15",
                "label" => __( 'Borders color', 'stockie' ),
                "name" => "global_page_borders_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose the color for your website borders', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_54229ad4313bf",
                "label" => __( 'Site Identity', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a52b48cexmod151",
                "label" => __( '', 'stockie' ),
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59229bda32383",
                "label" => __( 'Brand logo', 'stockie' ),
                "name" => "global_logo_type",
                "type" => "radio",
                "instructions" => __( 'Choose logo type for your website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "sitename" => __( 'Text Logo', 'stockie' ),
                    "image" => __( 'Custom Image', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "sitename",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937e3a52b38cexmod15",
                "label" => __( 'Text Logo', 'stockie' ),
                "name" => "global_branding_text_logo",
                "type" => "text",
                "instructions" => __( 'Enter the text for your website logo', 'stockie' ),
                "conditional_logic" => 0
            ],
            [
                "key" => "field_59256ac3f42ec",
                "label" => __( 'Text Logo settings', 'stockie' ),
                "name" => "global_header_menu_logo_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography styles for site name', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda32383",
                            "operator" => "==",
                            "value" => "sitename"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59229bda32f63",
                "label" => __( 'Logo light variant', 'stockie' ),
                "name" => "global_logo_image",
                "type" => "clone",
                "instructions" => __( 'Upload light-colored variant. Used for fullscreen menu by default', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda32383",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "clone" => [
                    "field_5936b2dd92771",
                    "field_5936b357132bf",
                    "field_5936b371132c0"
                ],
                "display" => "group",
                "layout" => "table",
                "prefix_label" => 0,
                "prefix_name" => 0
            ],
            [
                "key" => "field_5936add283a9a",
                "label" => __( 'Logo dark variant', 'stockie' ),
                "name" => "global_logo_image_dark_variant",
                "type" => "clone",
                "instructions" => __( 'Upload dark-colored variant. Used for scrolled fixed header by default', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda32383",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "clone" => [
                    "field_5936af24f4b7e",
                    "field_5936afd421bba",
                    "field_5936affb21bbb"
                ],
                "display" => "group",
                "layout" => "table",
                "prefix_label" => 0,
                "prefix_name" => 0
            ],
            [
                "key" => "field_5937e1905d075",
                "label" => __( 'Logo by default', 'stockie' ),
                "name" => "global_header_logo_by_default",
                "type" => "select",
                "instructions" => __( 'Choose default logo variant', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59229bda32383",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "light_variant" => __( 'Light Variant', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937e1905d075_fixed",
                "label" => __( 'Logo for sticky header', 'stockie' ),
                "name" => "global_header_logo_when_fixed",
                "type" => "select",
                "instructions" => __( 'Choose logo variant for sticky header', 'stockie' ),
                "required" => 0,
                "choices" => [
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "light_variant" => __( 'Light Variant', 'stockie' ),
                    "inherit" => __( 'Default logo variant', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' ),
                    "sitename" => __( 'Text Logo', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "dark_variant",
                "layout" => "vertical",
                "return_format" => "value"
            ],
            [
                "key" => "field_5936add283a9a_fix",
                "label" => __( 'Logo image for sticky header', 'stockie' ),
                "name" => "global_logo_image_fixed_variant",
                "type" => "clone",
                "instructions" => __( 'Upload logo variant for sticky header', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5937e1905d075_fixed",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "clone" => [
                    "field_5936af24f4b7e_fix",
                    "field_5936afd421bba_fix",
                    "field_5936affb21bbb_fix"
                ],
                "display" => "group",
                "layout" => "table",
                "prefix_label" => 0,
                "prefix_name" => 0
            ],
            [
                "key" => "field_54224ad4314bf",
                "label" => __( 'Site Preloader', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_591ac509d3e51",
                "label" => __( 'Preloader', 'stockie' ),
                "name" => "global_page_preloader",
                "type" => "true_false",
                "instructions" => __( 'Enable preloader animation', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_5937e3a3234324234",
                "label" => __( 'Preloader type', 'stockie' ),
                "name" => "global_preloader_type",
                "type" => "image_option",
                "instructions" => __( 'Choose loading image for website preloader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_591ac509d3e51",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => "fading_circle",
                "image_option_value" => [
                    [
                        "name" => "fading_circle",
                        "description" => __( 'Fading spinner', 'stockie' ),
                        "src" => "acf__image_13.svg"
                    ],
                    [
                        "name" => "circle",
                        "description" => __( 'Circle spinner', 'stockie' ),
                        "src" => "acf__image_11.svg"
                    ],
                    [
                        "name" => "waves",
                        "description" => __( 'Waves', 'stockie' ),
                        "src" => "acf__image_08.svg"
                    ],
                    [
                        "name" => "double_bounce",
                        "description" => __( 'Double bounce', 'stockie' ),
                        "src" => "acf__image_09.svg"
                    ],
                    [
                        "name" => "three_bounce",
                        "description" => __( 'Three bounce', 'stockie' ),
                        "src" => "acf__image_10.svg"
                    ],
                    [
                        "name" => "cube_loader",
                        "description" => __( 'Cube loader', 'stockie' ),
                        "src" => "acf__image_12.svg"
                    ],
                    [
                        "name" => "folding_cube",
                        "description" => __( 'Folding cube', 'stockie' ),
                        "src" => "acf__image_14.svg"
                    ],
                    [
                        "name" => "custom_loader",
                        "description" => __( 'Custom Image', 'stockie' ),
                        "src" => "acf__image_custom.svg"
                    ]
                ],
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_5rqsf22dd92771",
                "label" => __( 'Custom preloader', 'stockie' ),
                "name" => "global_custom_preloader",
                "type" => "image",
                "instructions" => __( 'Upload a custom preloader image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5937e3a3234324234",
                            "operator" => "==",
                            "value" => "custom_loader"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_592d5938aee39",
                "label" => __( 'Preloader color', 'stockie' ),
                "name" => "global_preloader_shapes_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose color for preloader shape', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_592d4579aee38",
                "label" => __( 'Preloader background color', 'stockie' ),
                "name" => "global_preloader_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Set background color for preloader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59249ad4313bf",
                "label" => __( 'Other', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_591ac509d4234",
                "label" => __( 'Back to top', 'stockie' ),
                "name" => "global_page_show_arrow",
                "type" => "true_false",
                "instructions" => __( 'Show back to top arrow on all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_591ac509d4235",
                "label" => __( 'Back to top for mobile', 'stockie' ),
                "name" => "global_page_show_arrow_mobile",
                "type" => "true_false",
                "instructions" => __( 'Hide back to top arrow on mobile devices', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_591ac509d4234",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_591ac509d465a",
                "label" => __( 'Back to top color', 'stockie' ),
                "name" => "global_page_arrow_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for back to top button', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_591ac509d4234",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;