<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_592fd88fb4838",
        "title" => __( 'Footer Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_592fdb59946d8",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a52b488cexmod60",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_592fd8901e284",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_footer_hide",
                "type" => "true_false",
                "instructions" => __( 'Hide footer from all pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Hide",
                "ui_off_text" => "Show"
            ],
            [
                "key" => "field_592fd8901ea9a",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_footer_is_wrapped",
                "type" => "true_false",
                "instructions" => __( 'Add footer content wrapper to all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_5940e34gvedrgiqw",
                "label" => __( 'Widget title text color', 'stockie' ),
                "name" => "global_footer_widget_title_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose widget title text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_5940ebca457f2",
                "label" => __( 'Content text color', 'stockie' ),
                "name" => "global_footer_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose content text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_592fd8901ca70",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_footer_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose footer background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_592fd8901ce59",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_footer_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for footer', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => 1200,
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_592fd8901d26a",
                "label" => __( 'Background size', 'stockie' ),
                "name" => "global_footer_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fd8901d6a3",
                "label" => __( 'Background position', 'stockie' ),
                "name" => "global_footer_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd8901d26a",
                            "operator" => "!=",
                            "value" => "cover"
                        ],
                        [
                            "field" => "field_592fd8901d26a",
                            "operator" => "!=",
                            "value" => "100per"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [
                    "center_bottom"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fd8901da75",
                "label" => __( 'Background repeat', 'stockie' ),
                "name" => "global_footer_background_repeat",
                "type" => "select",
                "instructions" => __( 'Repeat type of background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd8901d26a",
                            "operator" => "!=",
                            "value" => "cover"
                        ],
                        [
                            "field" => "field_592fd8901d26a",
                            "operator" => "!=",
                            "value" => "100per"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593916111579e",
                "label" => __( 'Sticky footer', 'stockie' ),
                "name" => "global_footer_is_sticky",
                "type" => "true_false",
                "instructions" => __( 'Set sticky (fixed) footer on all pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_592fdb63946d9",
                "label" => __( 'Copyright Bar', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592fd8901ee80",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_footer_hide_copyright",
                "type" => "true_false",
                "instructions" => __( 'Hide copyright section from all pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592fd8901d6a1",
                "label" => __( 'Copyright content position', 'stockie' ),
                "name" => "global_footer_copyright_alignment",
                "type" => "select",
                "instructions" => __( 'Choose copyright content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left_and_right" => __( 'Left and Right', 'stockie' ),
                    "center" => __( 'Center', 'stockie' )
                ],
                "default_value" => [
                    "left_and_right"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fd8901f24bae3",
                "label" => __( 'Copyright content', 'stockie' ),
                "name" => "global_footer_copyright_center",
                "type" => "text",
                "instructions" => __( 'Add some content to copyright section. You can use HTML tags', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd8901d6a1",
                            "operator" => "==",
                            "value" => "center"
                        ]
                    ]
                ],
                "default_value" => "\u00a9 2020, Stockie Theme. Made with passion by <a href=\"http:\/\/clbthemes.com\" target=\"_blank\">Colabrio<\/a>.",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_592fd8901f24baes",
                "label" => __( 'Left content item', 'stockie' ),
                "name" => "global_footer_copyright_left",
                "type" => "text",
                "instructions" => __( 'Add some content to copyright section <em>(Use HTML tags)</em>', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd8901d6a1",
                            "operator" => "==",
                            "value" => "left_and_right"
                        ]
                    ]
                ],
                "default_value" => "\u00a9 2020, Stockie Theme. Made with passion by <a href=\"http:\/\/clbthemes.com\" target=\"_blank\">Colabrio<\/a>.",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_592fd8901f24bfee",
                "label" => __( 'Right content item', 'stockie' ),
                "name" => "global_footer_copyright_right",
                "type" => "text",
                "instructions" => __( 'Add some content to copyright section <em>(Use HTML tags)</em>', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd8901d6a1",
                            "operator" => "==",
                            "value" => "left_and_right"
                        ]
                    ]
                ],
                "default_value" => "All right reserved.",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_592fd8901fa31",
                "label" => __( 'Copyright text color', 'stockie' ),
                "name" => "global_footer_copyright_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose copyright section text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_592fd8901fa32",
                "label" => __( 'Copyright links color', 'stockie' ),
                "name" => "global_footer_copyright_links_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose copyright section links color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_592fd8901f63a",
                "label" => __( 'Copyright background', 'stockie' ),
                "name" => "global_footer_copyright_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose section background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_592fdb17946d7",
                "label" => __( 'Other', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937a7a521f8sebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Logo Widget', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_592fd8901ba9e",
                "label" => __( 'Brand logo', 'stockie' ),
                "name" => "global_footer_logo_type",
                "type" => "select",
                "instructions" => __( 'Choose footer logo type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "light_variant" => __( 'Light Variant', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' ),
                    "sitename" => __( 'Text Logo', 'stockie' )
                ],
                "default_value" => [
                    "light_variant"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fd8901beb6",
                "label" => __( 'Text Logo settings', 'stockie' ),
                "name" => "global_footer_logo_font_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Custom typography settings for site name', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd8901ba9e",
                            "operator" => "==",
                            "value" => "sitename"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592fd8901c689",
                "label" => __( 'Logo image', 'stockie' ),
                "name" => "global_footer_logo_image",
                "type" => "image",
                "instructions" => __( 'Upload custom image for footer logo', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592fd8901ba9e",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => 10,
                "min_height" => 10,
                "min_size" => "",
                "max_width" => 1600,
                "max_height" => 800,
                "max_size" => 5,
                "mime_types" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-footer"
                ]
            ]
        ],
        "menu_order" => 1,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;