<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_593be7a6c2017",
        "title" => "Shop Settings",
        "title" => __( 'Shop Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_591b4f20ed84e",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a51b48cexmod155",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_58539i234317ae",
                "label" => __( 'Shop grid layout', 'stockie' ),
                "name" => "global_woocommerce_grid_type",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for product items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "type_1",
                        "description" => __( 'Classic', 'stockie' ),
                        "src" => "acf__image_20.svg"
                    ],
                    [
                        "name" => "type_2",
                        "description" => __( 'Minimal', 'stockie' ),
                        "src" => "acf__image_21.svg"
                    ],
                    [
                        "name" => "type_3",
                        "description" => __( 'Scattered', 'stockie' ),
                        "src" => "acf__image_22.svg"
                    ],
                    [
                        "name" => "type_4",
                        "description" => __( 'Carousel', 'stockie' ),
                        "src" => "acf__image_23.svg"
                    ]
                ],
                "default_value" => "type_1"
            ],
            [
                "key" => "field_58539i234317ar",
                "label" => __( 'Shop grid hover effects', 'stockie' ),
                "name" => "global_woocommerce_grid_hover",
                "type" => "image_option",
                "instructions" => __( 'Choose hover type for product items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "type_1",
                        "description" => __( 'Nav Buttons', 'stockie' ),
                        "src" => "acf__image_40.svg"
                    ],
                    [
                        "name" => "type_2",
                        "description" => __( 'Image Overlay', 'stockie' ),
                        "src" => "acf__image_38.svg"
                    ],
                    [
                        "name" => "type_3",
                        "description" => __( 'Color Overlay', 'stockie' ),
                        "src" => "acf__image_39.svg"
                    ]
                ],
                "default_value" => "type_1"
            ],
            [
                "key" => "field_59gb29bd1alsifuj90o",
                "label" => __( 'Overlay background color', 'stockie' ),
                "name" => "global_woocommerce_overlay_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose overlay background color', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_58539i234317ar",
                            "operator" => "==",
                            "value" => "type_3"
                        ]
                    ]
                ],
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593be7afs51sfg",
                "label" => __( 'Product images in gallery', 'stockie' ),
                "name" => "global_woocommerce_product_images_count",
                "type" => "text",
                "instructions" => __( 'Choose the number of product images for single product gallery', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "2",
                "placeholder" => "",
                "prepend" => "",
                "append" => __( 'images', 'stockie' ),
                "formatting" => "html",
                "maxlength" => ""
            ],
            [
                "key" => "field_ew3bqa6dfc31e",
                "label" => __( 'Mouse wheel scroll', 'stockie' ),
                "name" => "global_woocommerce_slider_mouse_scroll",
                "type" => "true_false",
                "instructions" => __( 'Enable mouse wheel scroll navigation', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_58539i234317ae",
                            "operator" => "==",
                            "value" => "type_4"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6dfc31e",
                "label" => __( 'Masonry layout', 'stockie' ),
                "name" => "global_woocommerce_masonry_layout",
                "type" => "true_false",
                "instructions" => __( 'Enable masonry layout for product items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_58539i234317ae",
                            "operator" => "!=",
                            "value" => "type_4"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_592d60af8a7feq21",
                "label" => __( 'Grid animation', 'stockie' ),
                "name" => "global_woocommerce_animation_type",
                "type" => "select",
                "instructions" => __( 'Choose grid animation type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be8a6dfc31e",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "default" => __( 'Disable Animation', 'stockie' ),
                    "sync" => __( 'Sync Animation', 'stockie' ),
                    "async" => __( 'Async Animation', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "masonry",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d60af8ac17d31sra",
                "label" => __( 'Grid animation effect', 'stockie' ),
                "name" => "global_woocommerce_animation_effect",
                "type" => "select",
                "instructions" => __( 'Choose product items appear effect', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d60af8a7feq21",
                            "operator" => "!=",
                            "value" => "default"
                        ]
                    ]
                ],
                "choices" => [
                    "fade-up" => __( 'Fade Up', 'stockie' ),
                    "fade-down" => __( 'Fade Down', 'stockie' ),
                    "fade-right" => __( 'Fade Right', 'stockie' ),
                    "fade-left" => __( 'Fade Left', 'stockie' ),
                    "flip-up" => __( 'Flip Up', 'stockie' ),
                    "flip-down" => __( 'Flip Down', 'stockie' ),
                    "zoom-in" => __( 'Zoom In', 'stockie' ),
                    "zoom-out" => __( 'Zoom Out', 'stockie' )
                ],
                "default_value" => [
                    "fade-up"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5ghpd60af8ac1asf1245gf",
                "label" => __( 'Grid alignment', 'stockie' ),
                "name" => "global_woocommerce_text_alignment",
                "type" => "select",
                "instructions" => __( 'Choose text alignment for product items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_58383c7ed01ae_shop_count",
                "label" => __( 'Product items per page', 'stockie' ),
                "name" => "global_woocommerce_products_on_page",
                "type" =>"text",
                "instructions" => __( 'Choose the number of product items per page', 'stockie' ),
                "required" => 0,
                "append" => __( 'products', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_58539i234317ae",
                            "operator" => "!=",
                            "value" => "type_4"
                        ]
                    ]
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "maxlength" => "2",
                "placeholder" => ""
            ],
            [
                "key" => "field_58383c7ed02ae",
                "label" => __( 'Product items per row', 'stockie' ),
                "name" => "global_woocommerce_products_in_row",
                "type" =>"stockie_ecommerce_columns",
                "instructions" => __( 'Choose the number of product items per row', 'stockie' ),
                "default_value" => [
                    "large" => "3",
                    "medium" => "2",
                    "small" => "2"
                ]
            ],
            [
                "key" => "field_59374323b383615",
                "label" => __( 'Pagination', 'stockie' ),
                "name" => "global_woocommerce_pagination_type",
                "type" => "select",
                "instructions" => __( 'Choose pagination type for shop page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "simple" => __( 'Simple', 'stockie' ),
                    "lazy_scroll" => __( 'Lazy Load', 'stockie' ),
                    "lazy_button" => __( 'Load More', 'stockie' )
                ],
                "default_value" => [
                    "simple"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593743237383615",
                "label" => __( 'Pagination position', 'stockie' ),
                "name" => "global_woocommerce_pagination_position",
                "type" => "select",
                "instructions" => __( 'Choose pagination position for shop page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5937a0a52148cexmod23s15",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Product Cards', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ], 
            [
                "key" => "field_59gfsdfsda32b3as15",
                "label" => __( 'Quickview button', 'stockie' ),
                "name" => "global_quickview_button",
                "type" => "true_false",
                "instructions" => __( 'Enable quickview feature on product items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_59gb29bda32b3as15",
                "label" => __( 'Product card background color', 'stockie' ),
                "name" => "global_woocommerce_shop_title_wrap_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose product card background color', 'stockie' ),
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_58539i234317ae",
                            "operator" => "==",
                            "value" => "type_4"
                        ]
                    ]
                ],
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59gb29bda32b3a",
                "label" => __( 'Sale tag background color', 'stockie' ),
                "name" => "global_woocommerce_shop_sale_tag_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose sale tag background color', 'stockie' ),
                "conditional_logic" => 0,
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_59gb29bda32b3b",
                "label" => __( 'Out of stock tag background color', 'stockie' ),
                "name" => "global_woocommerce_shop_out_stock_tag_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose out of stock tag background color', 'stockie' ),
                "conditional_logic" => 0,
                "required" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593f4haf12422a",
                "label" => __( 'Product title typography settings', 'stockie' ),
                "name" => "global_woocommerce_shop_product_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for product grid titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593f4haf12422b",
                "label" => __( 'Product category typography settings', 'stockie' ),
                "name" => "global_woocommerce_shop_product_category_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for product grid category', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59af4haf12422c",
                "label" => __( 'Product price typography settings', 'stockie' ),
                "name" => "global_woocommerce_shop_product_price_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for product grid price', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593be7a6d2429",
                "label" => __( 'Shop Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593be7a6d437b",
                "label" => __( 'Breadcrumbs visibility', 'stockie' ),
                "name" => "global_woocommerce_page_show_breadcrumbs",
                "type" => "radio",
                "instructions" => __( 'Show breadcrumbs section on shop pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => __( 'Hide', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6fas124d437b",
                "label" => __( 'Category slug', 'stockie' ),
                "name" => "global_woocommerce_page_show_category_breadcrumbs",
                "type" => "radio",
                "instructions" => __( 'Show product categories in breadcrumbs?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => __( 'Hide', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "yes",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59fb433sbgd33615",
                "label" => __( 'Breadcrumbs slug', 'stockie' ),
                "name" => "global_woocommerce_breadcrumbs_slug",
                "type" => "text",
                "instructions" => __( 'Enter custom text for breadcrumbs slug', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593be7a6d4778",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_woocommerce_page_is_wrapped",
                "type" => "radio",
                "instructions" => __( 'Add page content wrapper to shop pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593edd79aa843",
                            "operator" => "!=",
                            "value" => "yes"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Enable', 'stockie' ),
                    "no" => __( 'Disable', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7fasa6dfq41",
                "label" => __( 'Custom content position', 'stockie' ),
                "name" => "global_shop_content_position",
                "type" => "select",
                "instructions" => __( 'Choose WPBakery Page Builder page content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => false,
                "choices" => [
                    "top" => __( 'Top - Before Products', 'stockie' ),
                    "bottom" => __( 'Bottom - After Products', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593edd79aa843",
                "label" => __( 'Boxed page layout', 'stockie' ),
                "name" => "global_woocommerce_use_boxed_wrapper",
                "type" => "radio",
                "instructions" => __( 'Wrap Shop pages in boxed container', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6d2871",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "global_woocommerce_page_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose background type for shop pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "color" => __( 'Custom Color', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6d2bfc",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_woocommerce_page_background_image",
                "type" => "image",
                "instructions" => __( 'Custom background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d2871",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_593be7a6d2fe1",
                "label" => __( 'Background size', 'stockie' ),
                "name" => "global_woocommerce_page_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d2871",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "auto"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d33d2",
                "label" => __( 'Background position', 'stockie' ),
                "name" => "global_woocommerce_page_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d2fe1",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_593be7a6d2871",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ],
                    [
                        [
                            "field" => "field_593be7a6d2fe1",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_593be7a6d2871",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d37bb",
                "label" => __( 'Background repeat', 'stockie' ),
                "name" => "global_woocommerce_page_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose repeat type for background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d2fe1",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_593be7a6d2871",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ],
                    [
                        [
                            "field" => "field_593be7a6d2fe1",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_593be7a6d2871",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d3b96",
                "label" => __( 'Background attachment', 'stockie' ),
                "name" => "global_woocommerce_page_background_is_attached",
                "type" => "true_false",
                "instructions" => __( 'Fix background image for shop pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d2871",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_593be7a6d3f97",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_woocommerce_page_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for shop pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593743s37383615",
                "label" => __( 'Sidebar', 'stockie' ),
                "name" => "global_woocommerce_sidebar",
                "type" => "select",
                "instructions" => __( 'Choose sidebar position for shop pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_58539i234317ae",
                            "operator" => "!=",
                            "value" => "type_4"
                        ]
                    ]
                ],
                "choices" => [
                    "without" => __( 'Disable', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "without"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_583be7a6d2429",
                "label" => __( 'Product Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5953234sdf7ae",
                "label" => __( 'Single product layout', 'stockie' ),
                "name" => "global_ecommerce_product_type",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for product pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "type1",
                        "description" => __( 'Type 1', 'stockie' ),
                        "src" => "acf__image_15.svg"
                    ],
                    [
                        "name" => "type2",
                        "description" => __( 'Type 2', 'stockie' ),
                        "src" => "acf__image_16.svg"
                    ],
                    [
                        "name" => "type3",
                        "description" => __( 'Type 3', 'stockie' ),
                        "src" => "acf__image_17.svg"
                    ],
                    [
                        "name" => "type4",
                        "description" => __( 'Type 4', 'stockie' ),
                        "src" => "acf__image_18.svg"
                    ],
                    [
                        "name" => "type5",
                        "description" => __( 'Type 5', 'stockie' ),
                        "src" => "acf__image_19.svg"
                    ]
                ],
                "default_value" => "type1"
            ],
            [
                "key" => "field_47272c6ed00ae_laytype",
                "label" => __( 'View mode', 'stockie' ),
                "name" => "global_woocommerce_view_mode",
                "type" => "select",
                "instructions" => __( 'Choose view mode for product pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => __( 'Left Gallery', 'stockie' ),
                    "right" => __( 'Right Gallery', 'stockie' )
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be8a6dfa11893d",
                "label" => __( 'Gallery zoom', 'stockie' ),
                "name" => "global_woocommerce_product_images_zoom",
                "type" => "true_false",
                "instructions" => __( 'Enable images\' zoom for product page gallery?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6d18qlgt",
                "label" => __( 'Sticky Product', 'stockie' ),
                "name" => "global_woocommerce_product_sticky",
                "type" => "true_false",
                "instructions" => __( 'Enable Sticky product for product page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6d18930",
                "label" => __( 'Sale tag', 'stockie' ),
                "name" => "global_woocommerce_product_sale_tag",
                "type" => "true_false",
                "instructions" => __( 'Enable Sale tag for product page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6d1893a",
                "label" => __( 'Lightbox preview', 'stockie' ),
                "name" => "global_woocommerce_product_lightbox_preview",
                "type" => "true_false",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6d1893b",
                "label" => __( 'SKU', 'stockie' ),
                "name" => "global_woocommerce_product_sku",
                "type" => "true_false",
                "instructions" => __( 'Enable SKU for product page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6d1893c",
                "label" => __( 'Category', 'stockie' ),
                "name" => "global_woocommerce_product_category",
                "type" => "true_false",
                "instructions" => __( 'Enable category for product page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be8a6d1893d",
                "label" => __( 'Tags', 'stockie' ),
                "name" => "global_woocommerce_product_tags",
                "type" => "true_false",
                "instructions" => __( 'Enable tags for product page?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593743234451as47tr",
                "label" => __( 'Add to Cart with AJAX', 'stockie' ),
                "name" => "global_woocommerce_add_to_cart_ajax",
                "type" => "true_false",
                "instructions" => __( 'Enable product purchasing without refreshing the page', 'stockie' ),
                "default_value" => true,
                "ui" => true
            ],
            [
               "key" => "field_59fb4ad44a1dtd336199",
               "label" => __( 'Number of related products', 'stockie' ),
               "name" => "global_woocommerce_product_related_amount",
               "type" => "text",
               "instructions" => __( 'Enter a number of related products output. Up to 12', 'stockie' ),
               "required" => 0,
               "default_value" => "3",
               "new_lines" => "",
               "esc_html" => 0
            ],
            [
                "key" => "field_5937a0a52148cexmod23s152323232",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Typography Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593f4haf12422c",
                "label" => __( 'Product title typography', 'stockie' ),
                "name" => "global_woocommerce_single_product_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for simple product titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592f4aff12422a",
                "label" => __( 'Product price typography', 'stockie' ),
                "name" => "global_woocommerce_single_product_price_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for simple product price', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593f4hff12422b",
                "label" => __( 'Product meta typography', 'stockie' ),
                "name" => "global_woocommerce_single_product_category_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for product meta', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593be7a6cb6d8",
                "label" => __( 'Header', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593be7a6cbac1",
                "label" => __( 'Header layout', 'stockie' ),
                "name" => "global_woocommerce_header_menu_style",
                "type" => "image_option",
                "instructions" => __( 'Choose header template', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "inherit",
                        "description" => __( 'Use from Theme Settings', 'stockie' ),
                        "src" => "acf__image_inherited.svg"
                    ],
                    [
                        "name" => "style1",
                        "description" => __( 'Default', 'stockie' ),
                        "src" => "acf__image_01.svg"
                    ],
                    [
                        "name" => "style3",
                        "description" => __( 'Top Logo', 'stockie' ),
                        "src" => "acf__image_03.svg"
                    ],
                    [
                        "name" => "style4",
                        "description" => __( 'Centered Menu', 'stockie' ),
                        "src" => "acf__image_04.svg"
                    ],
                    [
                        "name" => "style5",
                        "description" => __( 'Centered Logo', 'stockie' ),
                        "src" => "acf__image_05.svg"
                    ],
                    [
                        "name" => "style6",
                        "description" => __( 'Sidebar Menu', 'stockie' ),
                        "src" => "acf__image_06.svg"
                    ],
                    [
                        "name" => "style7",
                        "description" => __( 'Panel Menu', 'stockie' ),
                        "src" => "acf__image_07.svg"
                    ]
                ],
                "default_value" => "inherit"
            ],
            [
                "key" => "field_59412ba9ad9b7",
                "label" => __( 'Blank spacer under header', 'stockie' ),
                "name" => "global_woocommerce_header_add_cap",
                "type" => "radio",
                "instructions" => __( 'We recommend use this setting for transparent and fixed header navigation', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Add Spacer', 'stockie' ),
                    "no" => __( 'Don\'t Add Spacer', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6cbea5",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_woocommerce_header_menu_use_wrapper",
                "type" => "radio",
                "instructions" => __( 'Use header content wrapper', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59412c4ddd0b7",
                "label" => __( 'Header styles', 'stockie' ),
                "name" => "global_woocommerce_header_menu_style_settings",
                "type" => "radio",
                "instructions" => __( 'Define header custom styles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' ),
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59413906d625b",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_woocommerce_header_menu_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up header height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412c4ddd0b7",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6cca51",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_woocommerce_header_menu_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412c4ddd0b7",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6cce2c",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "global_woocommerce_header_menu_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Content text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412c4ddd0b7",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593be7a6cd5f7",
                "label" => __( 'Bottom border', 'stockie' ),
                "name" => "global_woocommerce_header_menu_hide_border",
                "type" => "true_false",
                "instructions" => __( 'Hide bottom border from header?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412c4ddd0b7",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_593be7a6cddf0",
                "label" => __( 'Bottom border type', 'stockie' ),
                "name" => "global_woocommerce_header_menu_border_type",
                "type" => "select",
                "instructions" => __( 'Choose border stroke type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412c4ddd0b7",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593be7a6cd5f7",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "solid" => __( 'Solid', 'stockie' ),
                    "dashed" => __( 'Dashed', 'stockie' ),
                    "dotted" => __( 'Dotted', 'stockie' ),
                    "double" => __( 'Double', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6cda06",
                "label" => __( 'Bottom border color', 'stockie' ),
                "name" => "global_woocommerce_header_menu_border_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose bottom border color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412c4ddd0b7",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_593be7a6cd5f7",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_5937a0a52148cexmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Sticky Header', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593be7a6ced67",
                "label" => __( 'Sticky header', 'stockie' ),
                "name" => "global_woocommerce_header_menu_fixed",
                "type" => "radio",
                "instructions" => __( 'Enable sticky header, when you scrolling the page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937e0a52148cexmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Logo Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_59412a19f4b88",
                "label" => __( 'Brand logo', 'stockie' ),
                "name" => "global_woocommerce_header_logo_style",
                "type" => "select",
                "instructions" => __( 'Select header logo style', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "light_variant" => __( 'Light Variant', 'stockie' ),
                    "sitename" => __( 'Text Logo', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59412ac638d56",
                "label" => __( 'Text Logo settings', 'stockie' ),
                "name" => "global_woocommerce_header_sitename_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Custom typography settings', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412a19f4b88",
                            "operator" => "==",
                            "value" => "sitename"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_59412af638d57",
                "label" => __( 'Custom logo', 'stockie' ),
                "name" => "global_woocommerce_header_custom_logo",
                "type" => "image",
                "instructions" => __( 'Custom loaded image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_59412a19f4b88",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_593770a52148cexmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Menu Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593be7a6cc66e",
                "label" => __( 'Menu type', 'stockie' ),
                "name" => "global_woocommerce_menu_type",
                "type" => "radio",
                "instructions" => __( 'Choose menu type for shop pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "full" => __( 'Extended menu', 'stockie' ),
                    "hamburger" => __( 'Hamburger menu', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593770a5214bcexmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Subheader Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593be7a6ce1ba",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_woocommerce_header_menu_add_contacts_bar",
                "type" => "radio",
                "instructions" => __( 'Show subheader bar on shop pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => __( 'Hide', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_594104c4f2c34",
                "label" => __( 'Subheader styles', 'stockie' ),
                "name" => "global_woocommerce_header_menu_contacts_bar_style",
                "type" => "radio",
                "instructions" => __( 'Choose subheader style for shop pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_59410542f2c35",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_woocommerce_header_menu_contacts_bar_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up subheader height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_594104c4f2c34",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6ce5b9",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_woocommerce_header_menu_contacts_bar_background",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color for subheader', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_594104c4f2c34",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6ce975",
                "label" => __( 'Typography', 'stockie' ),
                "name" => "global_woocommerce_header_menu_contacts_bar_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Custom typography settings', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_594104c4f2c34",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593be7a6cf173",
                "label" => __( 'Page Headline', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593be7a6d2062",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_woocommerce_header_use_hero",
                "type" => "radio",
                "instructions" => __( 'Hide page headline from shop pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Hide', 'stockie' ),
                    "no" => __( 'Show', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6d1893",
                "label" => __( 'Fullscreen height', 'stockie' ),
                "name" => "global_woocommerce_header_height_fullscreen",
                "type" => "true_false",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No"
            ],
            [
                "key" => "field_593be7a6d1c53",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_woocommerce_header_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up page headline height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d1893",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6cf58a",
                "label" => __( 'Subtitle text', 'stockie' ),
                "name" => "global_woocommerce_header_subtitle",
                "type" => "text",
                "instructions" => __( 'Custom subtitle text', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "formatting" => "html",
                "maxlength" => ""
            ],
            [
                "key" => "field_593d5de953e57",
                "label" => __( 'Content position', 'stockie' ),
                "name" => "global_woocommerce_header_title_align",
                "type" => "radio",
                "instructions" => __( 'Choose page headline content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "layout" => "horizontal",
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be851ebe2f",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "global_woocommerce_header_title_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose background type for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "color" => __( 'Background Color', 'stockie' ),
                    "image" => __( 'Custom Image', 'stockie' )
                ],
                "default_value" => "",
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "layout" => "horizontal",
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d10ac",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_woocommerce_header_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose header background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be851ebe2f",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6cf964",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_woocommerce_header_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be851ebe2f",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_593be7a6cfd29",
                "label" => __( 'Background size', 'stockie' ),
                "name" => "global_woocommerce_header_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be851ebe2f",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d014b",
                "label" => __( 'Background position', 'stockie' ),
                "name" => "global_woocommerce_header_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6cfd29",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_593be851ebe2f",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ],
                    [
                        [
                            "field" => "field_593be7a6cfd29",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_593be851ebe2f",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d0501",
                "label" => __( 'Background repeat', 'stockie' ),
                "name" => "global_woocommerce_header_background_repeat",
                "type" => "select",
                "instructions" => __( 'Repeat type of background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6cfd29",
                            "operator" => "==",
                            "value" => "auto"
                        ],
                        [
                            "field" => "field_593be851ebe2f",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ],
                    [
                        [
                            "field" => "field_593be7a6cfd29",
                            "operator" => "==",
                            "value" => "contain"
                        ],
                        [
                            "field" => "field_593be851ebe2f",
                            "operator" => "==",
                            "value" => "image"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d08c2",
                "label" => __( 'Background overlay', 'stockie' ),
                "name" => "global_woocommerce_header_use_overlay",
                "type" => "radio",
                "instructions" => __( 'Add colored overlay over background image?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6d0cb4",
                "label" => __( 'Background overlay color', 'stockie' ),
                "name" => "global_woocommerce_header_overlay_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background overlay color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d08c2",
                            "operator" => "==",
                            "value" => "yes"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6d14a6",
                "label" => __( 'Typography settings', 'stockie' ),
                "name" => "global_woocommerce_page_typography_settings",
                "type" => "radio",
                "instructions" => __( 'Set up typography for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593d4af12422c",
                "label" => __( 'Title settings', 'stockie' ),
                "name" => "global_woocommerce_header_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for hero titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d14a6",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593d4b332422d",
                "label" => __( 'Subtitle settings', 'stockie' ),
                "name" => "global_woocommerce_header_subtitle_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typography for subtitles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593be7a6d14a6",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_593be7a6d4b64",
                "label" => __( 'Footer', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593be7a6d725e",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_woocommerce_footer_hide",
                "type" => "radio",
                "instructions" => __( 'Hide footer from shop pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Footer Settings', 'stockie' ),
                    "yes" => __( 'Hide', 'stockie' ),
                    "no" => __( 'Show', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6d7644",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_woocommerce_footer_is_wrapped",
                "type" => "radio",
                "instructions" => __( 'Add footer content wrapper?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Footer Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5940ecc23rfrewdfas",
                "label" => __( 'Widget title text color', 'stockie' ),
                "name" => "global_woocommerce_footer_widget_title_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose widget title text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_5940ecce7fe58",
                "label" => __( 'Content text color', 'stockie' ),
                "name" => "global_woocommerce_footer_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose content text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_5940e1dbc5ce2",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "global_woocommerce_footer_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose background type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Footer Settings', 'stockie' ),
                    "color" => __( 'Background Color', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6d5ec9",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_woocommerce_footer_background_image",
                "type" => "image",
                "instructions" => __( 'Upload background image for footer', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5940e1dbc5ce2",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => 1200,
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_593be7a6d62c5",
                "label" => __( 'Background size', 'stockie' ),
                "name" => "global_woocommerce_footer_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5940e1dbc5ce2",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d66b1",
                "label" => __( 'Background position', 'stockie' ),
                "name" => "global_woocommerce_footer_background_position",
                "type" => "select",
                "instructions" => __( 'Choose background image position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5940e1dbc5ce2",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [

                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d6aac",
                "label" => __( 'Background repeat', 'stockie' ),
                "name" => "global_woocommerce_footer_background_repeat",
                "type" => "select",
                "instructions" => __( 'Choose repeat type for background image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5940e1dbc5ce2",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d5706",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_woocommerce_footer_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose footer background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5940e1dbc5ce2",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_5940e241c5ce3",
                "label" => __( 'Footer widget logo type', 'stockie' ),
                "name" => "global_woocommerce_footer_widget_logo_type",
                "type" => "select",
                "instructions" => __( 'Choose footer logo type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Footer Settings', 'stockie' ),
                    "dark_variant" => __( 'Dark Variant', 'stockie' ),
                    "light_variant" => __( 'Light Variant', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' ),
                    "sitename" => __( 'Text Logo', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593be7a6d4f36",
                "label" => __( 'Footer site name settings', 'stockie' ),
                "name" => "global_woocommerce_footer_sitename_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Custom site name typography', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5940e241c5ce3",
                            "operator" => "==",
                            "value" => "sitename"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_5940e2cbc5ce4",
                "label" => __( 'Footer custom logo', 'stockie' ),
                "name" => "global_woocommerce_footer_custom_logo",
                "type" => "image",
                "instructions" => __( 'Custom loaded image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_5940e241c5ce3",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "thumbnail",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_5940e516ada44",
                "label" => __( 'Sticky footer', 'stockie' ),
                "name" => "global_woocommerce_footer_is_sticky",
                "type" => "radio",
                "instructions" => __( 'Set sticky footer on shop pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Footer Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5935e0a52b48cexmod60",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Copyright Bar', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593be7a6d7a67",
                "label" => __( 'Copyright section visibility', 'stockie' ),
                "name" => "global_woocommerce_footer_show_copyright_section",
                "type" => "radio",
                "instructions" => __( 'Show copyright section on shop pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Footer Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => __( 'Hide', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_593be7a6d7e8e",
                "label" => __( 'Copyright section background', 'stockie' ),
                "name" => "global_woocommerce_footer_copyright_section_background",
                "type" => "stockie_color",
                "instructions" => __( 'Choose section background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6d82b3",
                "label" => __( 'Copyright section text color', 'stockie' ),
                "name" => "global_woocommerce_footer_copyright_section_text_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose section content text color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593be7a6d82b4",
                "label" => __( 'Copyright section links color', 'stockie' ),
                "name" => "global_woocommerce_footer_copyright_section_links_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose section content links color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => ""
            ],
            [
                "key" => "field_593beba6d4b64",
                "label" => __( 'Other', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593743234457tr",
                "label" => __( 'Cart icon', 'stockie' ),
                "name" => "global_woocommerce_cart_icon",
                "type" => "true_false",
                "instructions" => __( 'Show a cart icon in the header', 'stockie' ),
                "default_value" => true,
                "ui" => true
            ],
            [
                "key" => "field_593743234457ta",
                "label" => __( 'Account icon', 'stockie' ),
                "name" => "global_woocommerce_account_icon",
                "type" => "true_false",
                "instructions" => __( 'Show an account icon in the header', 'stockie' ),
                "default_value" => true,
                "ui" => true
            ],
            [
                "key" => "field_593743234457235",
                "label" => __( 'One page checkout', 'stockie' ),
                "name" => "global_woocommerce_one_page_checkout",
                "type" => "true_false",
                "instructions" => __( 'Enable one page checkout mode', 'stockie' ),
                "default_value" => false,
                "ui" => true
            ],
            [
                "key" => "field_593743234457234",
                "label" => __( 'Cart recounting with AJAX', 'stockie' ),
                "name" => "global_woocommerce_cart_ajax_recounting",
                "type" => "true_false",
                "instructions" => __( 'Enable product quantity recounting without refreshing the page', 'stockie' ),
                "default_value" => true,
                "ui" => true
            ],
            [
                "key" => "field_593770a5214bc1xmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Sharing Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_593743w37383615",
                "label" => __( 'Sharing', 'stockie' ),
                "name" => "global_woocommerce_sharing",
                "type" => "true_false",
                "instructions" => __( 'Disable sharing feature for product pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "new_lines" => "",
                "esc_html" => 0,
                "ui" => true
            ],
            [
                "key" => "field_593743e37383615",
                "label" => __( 'Sharing networks', 'stockie' ),
                "name" => "global_woocommerce_sharing_networks",
                "type" => "select",
                "instructions" => __( 'Choose sharing social networks', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593743w37383615",
                            "operator" => "!=",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "facebook" => "Facebook",
                    "twitter" => "Twitter",
                    "pinterest" => "Pinterest",
                    "linkedin" => "LinkedIn"
                ],
                "default_value" => [],
                "allow_null" => 0,
                "multiple" => 1,
                "ui" => 1,
                "ajax" => 1,
                "return_format" => "value",
                "placeholder" => ""
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-woocommerce"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;
