<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_592d60af343cf",
        "title" => __( 'Blog Settings', 'stockie' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_592d60ah8a413",
                "label" => __( 'General', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937e0a52b48cexmod18",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "message" => '<p class="message">' . '<span class="dashicons dashicons-editor-help"></span>' . __( 'These settings apply to all the pages of your site. Use local Page Settings to override some options for individual pages.', 'stockie') . '</p>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_592d60af8b3f8",
                "label" => __( 'Blog layout', 'stockie' ),
                "name" => "global_blog_item_layout_type",
                "type" => "image_option",
                "instructions" => __( 'Choose layout type for blog grid', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "image_option_value" => [
                    [
                        "name" => "classic",
                        "description" => __( 'Classic', 'stockie' ),
                        "src" => "acf__image_24.svg"
                    ],
                    [
                        "name" => "simple",
                        "description" => __( 'Simple', 'stockie' ),
                        "src" => "acf__image_25.svg"
                    ],
                    [
                        "name" => "overlay",
                        "description" => __( 'Overlay', 'stockie' ),
                        "src" => "acf__image_25.1.svg"
                    ]
                ],
                "default_value" => "simple",
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592fd6fa1246v12ffaqwba22c",
                "label" => __( 'Grid image size', 'stockie' ),
                "name" => "global_blog_images_size",
                "type" => "select",
                "instructions" => __( 'Choose image size for blog items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "thumbnail" => __( 'Thumbnail', 'stockie' ),
                    "medium" => __( 'Small', 'stockie' ),
                    "medium_large" => __( 'Medium', 'stockie' ),
                    "large" => __( 'Large', 'stockie' ),
                    "full" => __( 'Original', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "medium_large",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d60af8b80c",
                "label" => __( 'Boxed', 'stockie' ),
                "name" => "global_blog_items_boxed_style",
                "type" => "true_false",
                "instructions" => __( 'Use boxed layout for blog post items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d60af8b3f8",
                            "operator" => "!=",
                            "value" => "overlay"
                        ],
                        [
                            "field" => "field_592d60af8b3f8",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No",
                "message" => "",
                "default_value" => 1
            ],
            [
                "key" => "field_592d60af8a7ff",
                "label" => __( 'Grid layout', 'stockie' ),
                "name" => "global_blog_page_layout",
                "type" => "radio",
                "instructions" => __( 'Choose grid layout type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "classic" => __( 'Classic', 'stockie' ),
                    "masonry" => __( 'Masonry', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "masonry",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d60af8bc07",
                "label" => __( 'Grid spacing', 'stockie' ),
                "name" => "global_blog_items_without_padding",
                "type" => "true_false",
                "instructions" => __( 'Remove spacing between grid items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "ui" => 1,
                "ui_on_text" => "Yes",
                "ui_off_text" => "No",
                "message" => "",
                "default_value" => 0
            ],
            [
                "key" => "field_592d60af8ac17",
                "label" => __( 'Blog items per row', 'stockie' ),
                "name" => "global_blog_columns_in_row",
                "type" => "stockie_columns",
                "instructions" => __( 'Choose the number of blog items per row', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d60af8a7ff",
                            "operator" => "==",
                            "value" => "masonry"
                        ]
                    ]
                ],
                "default_value" => "3-2-1-1",
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => "",
                "use_inherit" => false
            ],
            [
                "key" => "field_592d60af8a7ffmods",
                "label" => __( 'Grid animation', 'stockie' ),
                "name" => "global_blog_page_animation_type",
                "type" => "select",
                "instructions" => __( 'Choose grid animation type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "default" => __( 'Disable Animation', 'stockie' ),
                    "sync" => __( 'Sync Animation', 'stockie' ),
                    "async" => __( 'Async Animation', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "masonry",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d60af8ac17d2mod",
                "label" => __( 'Grid animation effect', 'stockie' ),
                "name" => "global_blog_page_animation_effect",
                "type" => "select",
                "instructions" => __( 'Choose blog items appear effect', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d60af8a7ffmods",
                            "operator" => "!=",
                            "value" => "default"
                        ]
                    ]
                ],
                "choices" => [
                    "fade-up" => __( 'Fade Up', 'stockie' ),
                    "fade-down" => __( 'Fade Down', 'stockie' ),
                    "fade-right" => __( 'Fade Right', 'stockie' ),
                    "fade-left" => __( 'Fade Left', 'stockie' ),
                    "flip-up" => __( 'Flip Up', 'stockie' ),
                    "flip-down" => __( 'Flip Down', 'stockie' ),
                    "zoom-in" => __( 'Zoom In', 'stockie' ),
                    "zoom-out" => __( 'Zoom Out', 'stockie' )
                ],
                "default_value" => [
                    "fade-up"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d60af8a413",
                "label" => __( 'Blog Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593743443383615",
                "label" => __( 'Breadcrumbs visibility', 'stockie' ),
                "name" => "global_blog_page_breadcrumbs_visibility",
                "type" => "radio",
                "instructions" => __( 'Hide breadcrumbs on blog pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => __( 'Hide', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_5937434433s3615",
                "label" => __( 'Breadcrumbs slug', 'stockie' ),
                "name" => "global_page_home_breadcrumb_slug",
                "type" => "text",
                "instructions" => __( 'Enter custom text for breadcrumbs slug', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_592faswe51fv2c",
                "label" => __( 'Custom content position', 'stockie' ),
                "name" => "global_post_content_position",
                "type" => "select",
                "instructions" => __( 'Choose WPBakery Page Builder page content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "top" => __( 'Top - Before Blog', 'stockie' ),
                    "bottom" => __( 'Bottom - After Blog', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_591ef18a3ef37",
                "label" => __( 'Categories filter', 'stockie' ),
                "name" => "global_breadcrumbs_show_cats",
                "type" => "true_false",
                "instructions" => __( 'Show categories filter on your website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_591ef1773ef36",
                "label" => __( 'Tags filter', 'stockie' ),
                "name" => "global_breadcrumbs_show_tags",
                "type" => "true_false",
                "instructions" => __( 'Show tags filter on your website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_591ef1473ef35",
                "label" => __( 'Authors filter', 'stockie' ),
                "name" => "global_breadcrumbs_show_author",
                "type" => "true_false",
                "instructions" => __( 'Show author filter on your website', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_592d60af8b000",
                "label" => __( 'Blog items per page', 'stockie' ),
                "name" => "global_blog_posts_per_page",
                "type" => "number",
                "instructions" => __( 'Choose the number of blog items per page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => 16,
                "placeholder" => "",
                "prepend" => "",
                "append" => "posts",
                "min" => 1,
                "max" => 100,
                "step" => 1
            ],
            [
                "key" => "field_592d60af8b001",
                "label" => __( 'Pagination', 'stockie' ),
                "name" => "global_blog_pagination_type",
                "type" => "select",
                "instructions" => __( 'Choose pagination type for blog page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "simple" => __( 'Standard', 'stockie' ),
                    "lazy_scroll" => __( 'Lazy load', 'stockie' ),
                    "lazy_button" => __( 'Load more', 'stockie' )
                ],
                "default_value" => [
                    "simple"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_59374afs43d8361523f",
                "label" => __( 'Pagination position', 'stockie' ),
                "name" => "global_blog_pagination_position",
                "type" => "select",
                "instructions" => __( 'Choose pagination position for blog page', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "left"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d60af8bfef",
                "label" => __( 'Sidebar', 'stockie' ),
                "name" => "global_blog_sidebar",
                "type" => "radio",
                "instructions" => __( 'Choose sidebar position for blog pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "right" => __( 'Right', 'stockie' ),
                    "without" => __( 'Disable', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d60af8c3d8",
                "label" => __( 'Post Page', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593dc7d2bfa16",
                "label" => __( 'Breadcrumbs visibility', 'stockie' ),
                "name" => "global_blog_page_show_breadcrumbs",
                "type" => "radio",
                "instructions" => __( 'Hide breadcrumbs on post pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Show', 'stockie' ),
                    "no" => __( 'Hide', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d7105a8cdb",
                "label" => __( 'Content wrapper', 'stockie' ),
                "name" => "global_post_page_add_wrapper",
                "type" => "radio",
                "instructions" => __( 'Add content wrapper to post pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593908a3311be",
                            "operator" => "!=",
                            "value" => "yes"
                        ]
                    ]
                ],
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_591ac5d9d31f3",
                "label" => __( 'Content wrapper width', 'stockie' ),
                "name" => "global_post_content_wrapper_width",
                "type" => "text",
                "instructions" => __( 'Define container wrapper width', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "default_value" => "",
                "placeholder" => "1326px",
                "prepend" => "Use CSS units",
                "append" => "",
                "maxlength" => 200
            ],
            [
                "key" => "field_593908a3311be",
                "label" => __( 'Boxed', 'stockie' ),
                "name" => "global_post_use_boxed_wrapper",
                "type" => "radio",
                "instructions" => __( 'Use boxed layout for blog post items', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Page Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d714deeb14",
                "label" => __( 'Navigation', 'stockie' ),
                "name" => "global_post_hide_previous_n_next",
                "type" => "true_false",
                "instructions" => __( 'Hide <em>"Prev and next posts"</em> navigation?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_592d716deeb15",
                "label" => __( 'Related posts', 'stockie' ),
                "name" => "global_post_hide_related_posts",
                "type" => "true_false",
                "instructions" => __( 'Hide block with related posts?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_59374a3443d8361523f",
                "label" => __( 'Post tags', 'stockie' ),
                "name" => "global_post_hide_tags",
                "type" => "true_false",
                "instructions" => __( 'Hide post tags on post pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_59374a3fdf523f",
                "label" => __( 'Post comments', 'stockie' ),
                "name" => "global_post_hide_comments",
                "type" => "true_false",
                "instructions" => __( 'Hide post comments on post pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_5937dfab71d1b",
                "label" => __( 'Sidebar', 'stockie' ),
                "name" => "global_post_single_sidebar",
                "type" => "select",
                "instructions" => __( 'Choose sidebar position for post pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "left" => __( 'Left', 'stockie' ),
                    "right" => __( 'Right', 'stockie' ),
                    "without" => __( 'Disable', 'stockie' )
                ],
                "default_value" => [
                    "without"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5937e0a52b48cexmod1",
                "label" => __( 'Page Headline', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_592d6d3b368b2",
                "label" => __( 'Visibility', 'stockie' ),
                "name" => "global_post_hide_header_title",
                "type" => "radio",
                "instructions" => __( 'Hide page headline from all post pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Hide', 'stockie' ),
                    "no" => __( 'Show', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d8434bfbfa",
                "label" => __( 'Fullscreen height', 'stockie' ),
                "name" => "global_post_title_height_fullscreen",
                "type" => "radio",
                "instructions" => __( 'Enable fullscreen height for page headline?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "yes" => __( 'Yes', 'stockie' ),
                    "no" => __( 'No', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d845bbfbfb",
                "label" => __( 'Height', 'stockie' ),
                "name" => "global_post_header_height",
                "type" => "stockie_responsive_height",
                "instructions" => __( 'Set up page headline height', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d8434bfbfa",
                            "operator" => "!=",
                            "value" => "no"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_592d72f6d085b",
                "label" => __( 'Subtitle text', 'stockie' ),
                "name" => "global_post_hide_subtitle",
                "type" => "select",
                "instructions" => __( 'Custom subtitle text', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "generated" => __( 'Post Meta', 'stockie' ),
                    "custom" => __( 'Custom Subtitle', 'stockie' ),
                    "hidden" => __( 'Hidden', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "",
                "layout" => "vertical",
                "return_format" => "value"
            ],
            [
                "key" => "field_593ddc099a870",
                "label" => __( 'Custom subtitle text', 'stockie' ),
                "name" => "global_post_custom_subtitle",
                "type" => "text",
                "instructions" => __( 'Write custom subtitle for every post', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d72f6d085b",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => "",
                "placeholder" => "",
                "prepend" => "",
                "append" => "",
                "maxlength" => ""
            ],
            [
                "key" => "field_592d7197eeb16",
                "label" => __( 'Content position', 'stockie' ),
                "name" => "global_post_header_title_align",
                "type" => "radio",
                "instructions" => __( 'Choose page headline content position', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "left" => __( 'Left', 'stockie' ),
                    "center" => __( 'Center', 'stockie' ),
                    "right" => __( 'Right', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d626d879de",
                "label" => __( 'Background type', 'stockie' ),
                "name" => "global_post_title_background_type",
                "type" => "radio",
                "instructions" => __( 'Choose page headline background type for all post pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "post_thumbnail" => __( 'Post Thumbnail', 'stockie' ),
                    "color" => __( 'Background Color', 'stockie' ),
                    "custom" => __( 'Custom Image', 'stockie' )
                ],
                "default_value" => [
                    "inherit"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "layout" => "horizontal",
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d69654e10f",
                "label" => __( 'Background color', 'stockie' ),
                "name" => "global_post_title_background_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "!=",
                            "value" => "inherit"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_592d638e879df",
                "label" => __( 'Background image', 'stockie' ),
                "name" => "global_post_title_background_image",
                "type" => "image",
                "instructions" => __( 'Upload page headline background image for all post pages', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "return_format" => "url",
                "preview_size" => "medium",
                "library" => "all",
                "min_width" => "",
                "min_height" => "",
                "min_size" => "",
                "max_width" => "",
                "max_height" => "",
                "max_size" => "",
                "mime_types" => ""
            ],
            [
                "key" => "field_592d69e4383d6",
                "label" => __( 'Background image size', 'stockie' ),
                "name" => "global_post_title_background_size",
                "type" => "select",
                "instructions" => __( 'Choose background image size type', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ]
                    ]
                ],
                "choices" => [
                    "auto" => __( 'Auto', 'stockie' ),
                    "cover" => __( 'Cover', 'stockie' ),
                    "contain" => __( 'Contain', 'stockie' ),
                    "100per" => __( '100% 100%', 'stockie' )
                ],
                "default_value" => [
                    "cover"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d6a39383d8",
                "label" => __( 'Background image position', 'stockie' ),
                "name" => "global_post_title_background_position",
                "type" => "select",
                "instructions" => __( 'Background position for image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ]
                ],
                "choices" => [
                    "center" => __( 'Center', 'stockie' ),
                    "left_top" => __( 'Left Top', 'stockie' ),
                    "left_center" => __( 'Left Center', 'stockie' ),
                    "left_bottom" => __( 'Left Bottom', 'stockie' ),
                    "center_top" => __( 'Center Top', 'stockie' ),
                    "center_bottom" => __( 'Center Bottom', 'stockie' ),
                    "right_top" => __( 'Right Top', 'stockie' ),
                    "right_center" => __( 'Right Center', 'stockie' ),
                    "right_bottom" => __( 'Right Bottom', 'stockie' )
                ],
                "default_value" => [
                    "center"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d6c37d15db",
                "label" => __( 'Background image repeat', 'stockie' ),
                "name" => "global_post_title_background_repeat",
                "type" => "select",
                "instructions" => __( 'Repeat setting for image', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "auto"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ],
                        [
                            "field" => "field_592d69e4383d6",
                            "operator" => "==",
                            "value" => "contain"
                        ]
                    ]
                ],
                "choices" => [
                    "repeat" => __( 'Repeat', 'stockie' ),
                    "no_repeat" => __( 'No Repeat', 'stockie' ),
                    "repeat_y" => __( 'Repeat by Y', 'stockie' ),
                    "repeat_x" => __( 'Repeat by X', 'stockie' )
                ],
                "default_value" => [
                    "repeat"
                ],
                "allow_null" => 0,
                "multiple" => 0,
                "ui" => 0,
                "ajax" => 0,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_592d6dbf5673e",
                "label" => __( 'Background overlay', 'stockie' ),
                "name" => "global_post_use_title_overlay",
                "type" => "true_false",
                "instructions" => __( 'Add colored overlay over background image?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_592d6e2c56740",
                "label" => __( 'Background overlay color', 'stockie' ),
                "name" => "global_post_title_background_overlay_color",
                "type" => "stockie_color",
                "instructions" => __( 'Choose background overlay color', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d6dbf5673e",
                            "operator" => "==",
                            "value" => "1"
                        ],
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "post_thumbnail"
                        ]
                    ],
                    [
                        [
                            "field" => "field_592d6dbf5673e",
                            "operator" => "==",
                            "value" => "1"
                        ],
                        [
                            "field" => "field_592d626d879de",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "default_value" => ""
            ],
            [
                "key" => "field_592d71e9e9b9c",
                "label" => __( 'Typography settings', 'stockie' ),
                "name" => "global_post_typography_settings",
                "type" => "radio",
                "instructions" => __( 'Set up typography for page headline', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "choices" => [
                    "inherit" => __( 'Use from Theme Settings', 'stockie' ),
                    "custom" => __( 'Custom', 'stockie' )
                ],
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "inherit",
                "layout" => "horizontal",
                "return_format" => "value"
            ],
            [
                "key" => "field_592d7239e9b9d",
                "label" => __( 'Title settings', 'stockie' ),
                "name" => "global_post_header_title_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typograhy for hero titles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d71e9e9b9c",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592d7c3fb4ea1",
                "label" => __( 'Subtitle settings', 'stockie' ),
                "name" => "global_post_page_text_typo",
                "type" => "stockie_typo",
                "instructions" => __( 'Set up typograhy for subtitles', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_592d71e9e9b9c",
                            "operator" => "==",
                            "value" => "custom"
                        ]
                    ]
                ],
                "add_theme_inherited" => true
            ],
            [
                "key" => "field_592d60af8a413auth",
                "label" => __( 'Other', 'stockie' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_5937a7a521481ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Sharing Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_5937433fdf523f",
                "label" => __( 'Sharing', 'stockie' ),
                "name" => "global_post_hide_social",
                "type" => "true_false",
                "instructions" => __( 'Disable sharing feature for post pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_5937fd3fdf523f",
                "label" => __( 'Sharing networks', 'stockie' ),
                "name" => "global_post_sharing_networks",
                "type" => "select",
                "instructions" => __( 'Choose sharing social networks', 'stockie' ),
                "required" => 0,
                "conditional_logic" => [],
                "choices" => [
                    "facebook" => "Facebook",
                    "twitter" => "Twitter",
                    "linkedin" => "LinkedIn",
                    "pinterest" => "Pinterest"
                ],
                "default_value" => [],
                "allow_null" => 0,
                "multiple" => 1,
                "ui" => 1,
                "ajax" => 1,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_5937a7a521f81ebmod23",
                "label" => "",
                "name" => "",
                "type" => "message",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "label" => '<h4>' . __( 'Author Settings', 'stockie' ) . '</h4>',
                "new_lines" => "",
                "esc_html" => 0
            ],
            [
                "key" => "field_592d716deeb14",
                "label" => __( 'Author visibility', 'stockie' ),
                "name" => "global_post_hide_author_widget",
                "type" => "true_false",
                "instructions" => __( 'Hide author widget for all post pages?', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 0,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_5937e0a52b873",
                "label" => __( 'Author social links', 'stockie' ),
                "name" => "global_author_social_links",
                "type" => "repeater",
                "instructions" => __( 'Add some links to author\'s social networks', 'stockie' ),
                "required" => 0,
                "conditional_logic" => 0,
                "collapsed" => "",
                "min" => 0,
                "max" => 0,
                "layout" => "table",
                "button_label" => "+ Add Author",
                "sub_fields" => [
                    [
                        "key" => "field_5937e0a52f6f4",
                        "label" => __( 'Author', 'stockie' ),
                        "name" => "author",
                        "type" => "user",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "wrapper" => [
                            "width" => "",
                            "class" => "",
                            "id" => ""
                        ],
                        "role" => "",
                        "allow_null" => 0,
                        "multiple" => 0
                    ],
                    [
                        "key" => "field_5937e0a52fac9",
                        "label" => __( 'Links', 'stockie' ),
                        "name" => "links",
                        "type" => "repeater",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "wrapper" => [
                            "width" => "",
                            "class" => "",
                            "id" => ""
                        ],
                        "collapsed" => "",
                        "min" => 0,
                        "max" => 0,
                        "layout" => "table",
                        "button_label" => "+ Add Link",
                        "sub_fields" => [
                            [
                                "key" => "field_5937e0a534d96",
                                "label" => __( 'Social networks', 'stockie' ),
                                "name" => "social_networks",
                                "type" => "select",
                                "instructions" => "",
                                "required" => 0,
                                "conditional_logic" => 0,
                                "wrapper" => [
                                    "width" => "",
                                    "class" => "",
                                    "id" => ""
                                ],
                                "choices" => [
                                    "facebook" => "Facebook",
                                    "twitter" => "Twitter",
                                    "instagram" => "Instagram",
                                    "linkedin" => "LinkedIn",
                                    "pinterest" => "Pinterest",
                                    "youtube" => "Youtube"
                                ],
                                "default_value" => [
                                    "facebook"
                                ],
                                "allow_null" => 0,
                                "multiple" => 0,
                                "ui" => 0,
                                "ajax" => 0,
                                "return_format" => "value",
                                "placeholder" => ""
                            ],
                            [
                                "key" => "field_5937e0a535178",
                                "label" => __( 'URL', 'stockie' ),
                                "name" => "url",
                                "type" => "url",
                                "instructions" => "",
                                "required" => 0,
                                "conditional_logic" => 0,
                                "wrapper" => [
                                    "width" => "",
                                    "class" => "",
                                    "id" => ""
                                ],
                                "default_value" => "",
                                "placeholder" => ""
                            ]
                        ]
                    ]
                ]
            ]
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-blog"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;
