<?php

if ( ! function_exists( 'stockie_return_posted_on' ) ) {
	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 */
	function stockie_posted_time() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() )
		);

		return $time_string;
	}

	function stockie_return_posted_on() {
		$time_string = stockie_posted_time();

		$posted_on = sprintf( '%s', $time_string );

		echo '<span class="author">' . esc_html( get_the_author() ) . '</span>';
		echo '<b></b>';
		echo ' <span class="date">' . $posted_on . '</span>';

	}
}

if ( ! function_exists( 'stockie_return_entry_footer' ) ) {
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function stockie_return_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			global $post;
			$hide_tags = StockieSettings::get( 'post_hide_tags', 'global' );
			$hide_social = StockieSettings::get( 'post_hide_social', 'global' );

			if ( !$hide_tags ) {
				echo '<div class="entry-footer-tags">';
				/* translators: used between list items, there is a space after the comma */
				/*$categories_list = get_the_category_list( ' ' );
				if ( $categories_list && stockie_categorized_blog() ) {
					$categories_list = preg_replace( '/(<a)(.+?>)/i', '$1 class="brand-color brand-border-color" $2 ', $categories_list );
					printf( '<span class="category subtitle-font">%1$s</span>', $categories_list ); // WPCS: XSS OK.
				}*/
				/* translators: used between list items, there is a space after the comma */
				$tags_list = get_the_tag_list( '', ', ' );
				if ( $tags_list ) {
					$tags = explode( ', ', $tags_list );
					foreach( $tags as $tag ) {
						printf( '<span class="tag">%1$s</span>', $tag ); // WPCS: XSS OK.
					}
				}
				echo '</div>';
			}

			echo '<div class="entry-footer-share">';
			if ( !$hide_social ) {
				do_shortcode( '[stockie_share_blog]' );
			}
			echo '</div>';
		}

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			/* translators: %s: post title */
			comments_popup_link( sprintf( esc_html__( 'Leave a Comment %1$s on %2$s', 'stockie' ), '<span class="screen-reader-text">', get_the_title() . '</span>' ) );
			echo '</span>';
		}

		edit_post_link(
			get_the_title( '<span class="screen-reader-text">"', '"</span>', false )
		);
	}

}

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function stockie_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'stockie_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'stockie_categories', $all_the_cool_cats );
	}

	return true;
}

/**
 * Flush out the transients used in stockie_categorized_blog.
 */
function stockie_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'stockie_categories' );
}