<?php

function stockie_enqueue_admin_style()
{
    $fonts_type = StockieSettings::get( 'font_type', 'global' );
    if ( $fonts_type == 'adobe_fonts') {
        $fonts_url = '//use.typekit.net/' . StockieSettings::get( 'adobekit_url', 'global' ) . '.css';
        wp_enqueue_style( 'adobe-font', esc_url( $fonts_url ) );
    }

    wp_enqueue_style( 'fontawesome-font', get_template_directory_uri() . '/assets/fonts/fa/css/all.css' );
    wp_enqueue_style( 'ionicons-font', get_template_directory_uri() . '/assets/css/ionicons.min.css' );
    wp_enqueue_style( 'select2css', get_template_directory_uri() . '/assets/css/select2.min.css' );
    wp_enqueue_script( 'select2', get_template_directory_uri() . '/assets/js/libs/select2.min.js' );
    wp_enqueue_script( 'admin-scripts', get_template_directory_uri() . '/assets/js/admin.min.js' );
}

add_action( 'admin_head', 'stockie_enqueue_admin_style' );

// Styles including
function stockie_enqueue_own_styles()
{
    wp_enqueue_style( 'stockie-style', get_stylesheet_uri(), array(), '1.0.15' );
    if ( is_rtl() ) {
        wp_enqueue_style( 'stockie-rtl', get_template_directory_uri() . '/rtl.css' );
    }
    wp_enqueue_style( 'stockie-grid', get_template_directory_uri() . '/assets/css/grid.min.css', false );
    require_once( get_template_directory().'/inc/dynamic_css/index.php' );

    // User custom JS
    $stockie_custom_js_header = StockieSettings::get( 'header_javascript', 'global' );
    if ( $stockie_custom_js_header ) {
        echo $stockie_custom_js_header;
    }
}

add_action( 'wp_enqueue_scripts', 'stockie_enqueue_own_styles' );

function deregister_my_styles() {
    wp_deregister_style( 'yith-wcan-frontend' );
}
add_action( 'wp_print_styles', 'deregister_my_styles', 100 );

function stockie_enqueue_own_styles_secondary()
{
    wp_enqueue_style( 'aos', get_template_directory_uri() . '/assets/css/aos.css', false );
    wp_enqueue_style( 'ionicons', get_template_directory_uri() . '/assets/css/ionicons.min.css', false );
    wp_enqueue_style( 'fontawesome-font-css', get_template_directory_uri() . '/assets/fonts/fa/css/all.css', false );
    wp_register_style( 'shortcodes-settings', false );
    wp_enqueue_style( 'shortcodes-settings' );
    wp_add_inline_style( 'shortcodes-settings', StockieLayout::get_shortcodes_css_buffer( false ) );

    // User custom JS
    $stockie_custom_js_footer = StockieSettings::get( 'footer_javascript', 'global' );
    if ( $stockie_custom_js_footer ) {
        echo $stockie_custom_js_footer;
    }

    if ( function_exists( 'WC' ) ) {
        if ( !is_checkout() ) {
            wp_enqueue_style( 'select2css', get_template_directory_uri() . '/assets/css/select2.min.css' );
        }
    }
}

add_action( 'wp_footer', 'stockie_enqueue_own_styles_secondary' );

// Scripts including
function stockie_enqueue_own_scripts()
{
    
    if ( isset( $GLOBALS['stockie_google_fonts'] ) ) {
        $google_fonts_string = StockieHelper::parse_google_fonts_to_query_string( $GLOBALS['stockie_google_fonts'] );
        if ( $google_fonts_string ) {
            wp_enqueue_style( 'stockie-global-fonts', $google_fonts_string, array(), '&display=swap' );
        }
    }

    wp_enqueue_script( 'jquery-masonry' );
    wp_enqueue_script( 'underscore' );
    wp_enqueue_script( 'aos', get_template_directory_uri() . '/assets/js/libs/aos.min.js', array( 'jquery' ), false, true );
    wp_enqueue_script( 'isotope', get_template_directory_uri() . '/assets/js/libs/isotope.pkgd.min.js', array( 'jquery' ), false, true );
    wp_enqueue_script( 'jquery-mega-menu', get_template_directory_uri() . '/assets/js/libs/jquery.mega-menu.min.js', array( 'jquery' ), false, true );
    if ( is_singular() && comments_open() && get_option( 'thread_comments') ) {
        wp_enqueue_script( 'comment-reply' );
    }
    if ( !is_page( array( 'cart', 'checkout' ) ) ) {
        wp_enqueue_script( 'select2', get_template_directory_uri() . '/assets/js/libs/select2.min.js' );
    }

    wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/libs/owl.carousel.min.js', array( 'jquery' ), false, true );

    if ( StockieHelper::is_script_required( 'multiscroll') ) { // Multiscreen
        wp_enqueue_script( 'multiscroll', get_template_directory_uri() . '/assets/js/libs/jquery.multiscroll.min.js', array( 'jquery' ), '1.0.0', true );
    }
    if ( StockieHelper::is_script_required( 'countdown-box') ) { // Count Box
        wp_enqueue_script( 'jquery-countdown', get_template_directory_uri() . '/assets/js/libs/jquery.countdown.min.js', array( 'jquery' ), '1.0.0', true );
    }
    if ( StockieHelper::is_script_required( 'typed') ) { // Typed.js
        wp_enqueue_script( 'typed', get_template_directory_uri() . '/assets/js/libs/typed.min.js', array( 'jquery' ), '1.0.0', true );
    }
    if ( StockieHelper::is_script_required( 'google-maps') ) { // Google Maps
        wp_enqueue_script( 'jquery-maps', get_template_directory_uri() . '/assets/js/libs/jquery.google-maps.min.js', array( 'jquery' ), '1.0.0', true );
    }
    if ( ( isset( $GLOBALS['stockie_use_map'] ) && $GLOBALS['stockie_use_map'] ) || StockieHelper::is_script_required( 'google-maps' ) ) { // Google Maps
        $api_key = '';
        if ( function_exists( 'get_field' ) ) {
            $settings_api_key = get_field( 'global_google_maps_api_key', 'option' );
        } else {
            $settings_api_key = get_option( 'options_global_google_maps_api_key' );
            if ( empty($settings_api_key ) ) {
                $settings_api_key = false;
            }
        }
        if ( $settings_api_key ) {
            $api_key = $settings_api_key;
        }
        wp_enqueue_script( 'google-maps', '//maps.googleapis.com/maps/api/js?v=3.exp&sensor=false&key=' . urlencode( esc_attr( $api_key ) ), false, NULL, true );
    }

    wp_enqueue_script( 'wc-add-to-cart-variation' );
    wp_enqueue_script( 'stockie-main', get_template_directory_uri() . '/assets/js/main.min.js', array( 'jquery' ), false, true );

    $stockieVariables = array(
        'url' => esc_url( admin_url( 'admin-ajax.php' ) ),
        'view_cart' => esc_html__( 'View Cart', 'stockie' ),
        'add_to_cart_message' => esc_html__( 'has been added to the cart', 'stockie' ),
    );

    if ( function_exists( 'WC' ) ) {
        $stockieVariables['decimal_separator'] = wc_get_price_decimal_separator();
        $stockieVariables['thousand_separator'] = wc_get_price_thousand_separator();
        $stockieVariables['currency_symbol'] = get_woocommerce_currency_symbol();
    }

    if ( function_exists( 'wc_get_cart_url' ) ) {
        $stockieVariables['cart_page'] = esc_url( wc_get_cart_url() );
    }

    $stockieVariables['subscribe_popup_enable'] = StockieSettings::get( 'subscribe_popup_switch', 'global' );
    if ( $stockieVariables['subscribe_popup_enable'] ) {
        if ( StockieSettings::get( 'subscribe_popup_display_trigger', 'global') ) {
            $stockieVariables['subscribe_popup_type'] = StockieSettings::get( 'subscribe_popup_display_trigger', 'global' );
            switch ( $stockieVariables['subscribe_popup_type'] ) {
                case 'time':
                    $stockieVariables['subscribe_popup_var'] = StockieSettings::get( 'delay_subcribe_popup', 'global' );
                    break;
                case 'scroll':
                    $stockieVariables['subscribe_popup_var'] = StockieSettings::get( 'subscribe_popup_scroll_percent', 'global' );
                    break;
            }
        }
    }

    $stockieVariables['notification_enable'] = StockieSettings::get( 'notification_bar', 'global' );
    if ( $stockieVariables['notification_enable'] ) {
        $stockieVariables['notification_expires'] = StockieSettings::get( 'subscribe_popup_expires', 'global' );
        if ( !$stockieVariables['notification_expires'] ) {
            $stockieVariables['notification_expires'] = 360;
        }
    }

    $stockieVariables['saleL10n'] = esc_html__( 'Sale', 'stockie' );

    wp_localize_script( 'stockie-main', 'stockieVariables', $stockieVariables);
}

add_action( 'wp_footer', 'stockie_enqueue_own_scripts' );

// Font icons pack in footer
function stockie_enqueue_icon_fonts()
{
    $fonts = StockieHelper::parse_iconset_to_url( $GLOBALS['stockie_icon_fonts'] );
    if ( $fonts ) {
        foreach ( $fonts as $key => $value ) {
            wp_enqueue_style( 'icon-pack-' . $key, $value, array(), '2.0.0' );
        }
    }
}

add_action( 'wp_footer', 'stockie_enqueue_icon_fonts' );

add_filter( 'next_post_link', 'stockie_next_product_link_url' );
function stockie_next_product_link_url( $link )
{
    if ( !empty( $link ) ) {
        preg_match( "/<a href=\"(.+)\" .+/", $link, $url );
        return $url[1];
    }

}

add_filter( 'previous_post_link', 'stockie_previous_product_link_url' );
function stockie_previous_product_link_url($link)
{
    if ( !empty( $link ) ) {
        preg_match( "/<a href=\"(.+)\" .+/", $link, $url );
        return $url[1];
    }
}