<?php
/*
	Custom user CSS style
	
	Table of contents: (you can use search)
	# 1. Variables
	# 2. Global custom CSS
	# 3. Current page custom CSS
	# 4. Current page custom CSS
	# 5. Current project custom CSS
	# 6. View
*/


# 1. Variables

$global_css		= false;
$page_css 		= false;
$post_css 		= false;
$project_css 	= false;


# 2. Global custom CSS
$global_css            = StockieSettings::get( 'page_custom_css', 'global' );
$global_large_css      = StockieSettings::get( 'page_custom_large_css', 'global' );
$global_medium_css     = StockieSettings::get( 'page_custom_medium_css', 'global' );
$global_small_css      = StockieSettings::get( 'page_custom_small_css', 'global' );

# 3. Current page custom CSS
$page_css = StockieSettings::get( 'page_custom_css' );

# 4. Current page custom CSS
$post_css = StockieSettings::get( 'post_custom_css' );

# 5. Current project custom CSS
$project_css = StockieSettings::get( 'project_custom_css' );


# 6. View

if ( $global_css ) {
	StockieLayout::append_to_dynamic_css_buffer( $global_css );
}
if ( $global_large_css ) {
	StockieLayout::append_to_dynamic_css_buffer( $global_large_css, 'desktop' );
}
if ( $global_medium_css ) {
	StockieLayout::append_to_dynamic_css_buffer( $global_medium_css, 'tablet' );
}
if ( $global_small_css ) {
	StockieLayout::append_to_dynamic_css_buffer( $global_small_css, 'mobile' );
}
if ( $page_css ) {
	StockieLayout::append_to_dynamic_css_buffer( $page_css );
}
if ( $post_css ) {
	StockieLayout::append_to_dynamic_css_buffer( $post_css );
}
if ( $project_css ) {
	StockieLayout::append_to_dynamic_css_buffer( $project_css );
}