<?php
/*
	Typography custom style

	Table of contents: (you can use search)
	# 1. Variables
	# 2. Text typography
	# 2.1. Text responsive typography
	# 2.2. Post text typography
	# 3. Title typography
	# 3.1. Title responsive sizes
	# 3.2. Post title typography
	# 4. Subtitle typography
	# 4.1. Subtitle responsive typography
	# 5. View
	# 6. Subscribe popup
	# 6.1 Heading
	# 6.2 Description
	# 6.3 Background
*/


# 1. Variables

$title_typo = false;
$title_responsive_sizes = false;
$subtitle_typo = false;
$subtitle_responsive_sizes = false;
$text_typo = false;
$text_responsive_sizes = false;
$post_title_typo = false;
$post_text_typo = false;
$subcribe_popup_title_typo = false;
$subcribe_popup_description_typo = false;
$subscribe_background_color = false;



# 2. Text typography

$text_typo = StockieSettings::get( 'page_text_typo', 'global' );


# 2.1. Text responsive typography

$_text_font_sizes_raw = StockieSettings::get( 'page_paragraphs_font_sizes', 'global' );
$text_responsive_sizes = StockieHelper::parse_responsive_font_sizes( $_text_font_sizes_raw );


# 2.2. Post text typography

if ( StockieSettings::page_is( 'single' ) ) {
	if ( StockieSettings::get( 'post_typography_settings', 'global' ) == 'custom' ) {
		$post_text_typo = StockieSettings::get( 'post_page_text_typo', 'global' );
	}
}


# 3. Title typography

if ( StockieSettings::page_is( 'single' ) ) {
	if ( StockieSettings::get( 'post_typography_settings', 'global' ) == 'custom' ) {
		$title_typo = StockieSettings::get( 'post_header_title_typo', 'global' );
	} else {
		$title_typo = StockieSettings::get( 'page_headings_typo', 'global' );
	}
} else {
	$title_typo = StockieSettings::get( 'page_headings_typo', 'global' );
}


# 3.1. Title responsive sizes

$_title_font_sizes_raw = StockieSettings::get( 'page_titles_font_sizes', 'global' );
$title_responsive_sizes = StockieHelper::parse_responsive_font_sizes( $_title_font_sizes_raw );


# 3.2. Post title typography

if ( StockieSettings::page_is( 'single' ) ) {
	if ( StockieSettings::get( 'post_typography_settings', 'global' ) == 'custom' ) {
		$post_title_typo = StockieSettings::get( 'post_header_title_typo', 'global' );
	}
}


# 4. Subtitle typography

$subtitle_typo = StockieSettings::get( 'page_subtitles_typo', 'global' );


# 4.1. Subtitle responsive typography

$_subtitle_font_sizes_raw = StockieSettings::get( 'page_subtitles_font_sizes', 'global' );
$subtitle_responsive_sizes = StockieHelper::parse_responsive_font_sizes( $_subtitle_font_sizes_raw );

# 5. View

// Global settings
/* Texts */
$_style_selectors = 'body';
$_responsive_selectors = $_style_selectors;
$_css = StockieHelper::parse_acf_typo_to_css( $text_typo );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = 'input, select, textarea, .accordion-box .buttons h5.title, .woocommerce div.product accordion-box.outline h5';
$_responsive_selectors .= ', ' . $_style_selectors;
$_css = StockieHelper::parse_acf_typo_to_css( $text_typo, array( 'rule' => 'exclude', 'fields' => array( 'color' ) ) );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $text_responsive_sizes ) {
	$_responsive_css = StockieHelper::get_all_responsive_font_css( $text_responsive_sizes, $_responsive_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_responsive_css );
}

/* Headings */
// $_style_selectors = 'h1, h2, h3, h4, h5, h6, .box-count, .mini_cart_item-desc .font-titles, .woo-c_product .font-titles, .tabNav_link.active, .icon-box-headline, .fullscreen-nav .menu-link, .postNav_item_inner_heading';
$_responsive_selectors = $_style_selectors;
$_css = StockieHelper::parse_acf_typo_to_css( $title_typo );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = '.countdown-box .box-time .box-count, .chart-box-pie-content';
$_responsive_selectors .= ', ' . $_style_selectors;
$_css = StockieHelper::parse_acf_typo_to_css( $title_typo, array( 'rule' => 'exclude', 'fields' => array( 'line-height' ) ) );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = 'h1, h2, h3, h4, h5, h6, .box-count, .font-titles, .tabNav_link.active, .icon-box-headline, .postNav_item_inner_heading, .btn, .button, a.button, .heading .title, .socialbar.inline a, .vc_row .vc-bg-side-text, .counter-box-count, .fullscreen-nav .menu-link';


$_css = StockieHelper::parse_acf_typo_to_css( $title_typo, array( 'rule' => 'include', 'fields' => array( 'font-family' ) ) );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = '.portfolio-item h4, .portfolio-item h4.title, .portfolio-item h4 a:not(.btn), ';
$_style_selectors .= '.portfolio-item-2 h4, .portfolio-item-2 h4.title, .portfolio-item-2 h4 a:not(.btn), ul.products li.product a:not(.btn)';
$_css = StockieHelper::parse_acf_typo_to_css( $title_typo, array( 'rule' => 'exclude', 'fields' => array( 'font-size', 'line-height' ) ) );
if ($_css) {
	$_css .= 'font-size:inherit;';
	$_css .= 'line-height:inherit;';
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = '.blog-item h3.title';
$_css = StockieHelper::parse_acf_typo_to_css( $title_typo, array( 'rule' => 'exclude', 'fields' => array( 'font-size', 'line-height' ) ) );
if ($_css) {
	$_css .= 'line-height: initial;';
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	$_style_block .= '.blog-item h3.title a{';
	$_style_block .= 'font-size: initial;';
	$_style_block .= '}';
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = '.portfolio-item-2 h4';
$_css = StockieHelper::parse_acf_typo_to_css( $title_typo, array( 'rule' => 'exclude', 'fields' => array( 'font-size', 'color' ) ) );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $title_responsive_sizes ) {
	$_responsive_css = StockieHelper::get_all_responsive_font_css( $title_responsive_sizes, $_responsive_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_responsive_css );
}


/* Subheadings */
$_style_selectors = 'p.subtitle, .subtitle-font, a.category, .heading .title, .heading .subtitle';
$_responsive_selectors = $_style_selectors;
$_css = StockieHelper::parse_acf_typo_to_css( $subtitle_typo );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = 'span.category > a, div.category > a';
$_css = StockieHelper::parse_acf_typo_to_css( $subtitle_typo, array( 'rule' => 'exclude', 'fields' => array( 'font-size', 'line-height' ) ) );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = '.portfolio-item .subtitle-font, .woocommerce ul.products li.product .subtitle-font.category, ';
$_style_selectors .= '.woocommerce ul.products li.product .subtitle-font.category > a';
$_css = StockieHelper::parse_acf_typo_to_css( $subtitle_typo, array( 'rule' => 'exclude', 'fields' => array( 'font-size', 'line-height' ) ) );
if ($_css) {
	$_css .= 'font-size:inherit;';
	$_css .= 'line-height:inherit;';
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = 'input.classic::-webkit-input-placeholder, .contact-form.classic input::-webkit-input-placeholder, ';
$_style_selectors .= '.contact-form.classic textarea::-webkit-input-placeholder, input.classic::-moz-placeholder';
$_responsive_selectors .= ', ' . $_style_selectors;
$_css = StockieHelper::parse_acf_typo_to_css( $subtitle_typo );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = '.contact-form.classic input::-moz-placeholder, .contact-form.classic textarea::-moz-placeholder';
$_css = StockieHelper::parse_acf_typo_to_css( $subtitle_typo );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

$_style_selectors = 'input.classic:-ms-input-placeholder, .contact-form.classic input:-ms-input-placeholder, ';
$_style_selectors .= '.contact-form.classic textarea:-ms-input-placeholder';
$_css = StockieHelper::parse_acf_typo_to_css( $subtitle_typo );
if ($_css) {
	$_style_block = StockieHelper::wrap_css_to_selector( $_css, $_style_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $subtitle_responsive_sizes ) {
	$_responsive_css = StockieHelper::get_all_responsive_font_css( $subtitle_responsive_sizes, $_responsive_selectors );
	StockieLayout::append_to_dynamic_css_buffer( $_responsive_css );
}


// Post text
if ( StockieHelper::parse_acf_typo_to_css( $post_text_typo ) ) {
	// --- start of CSS ---
	$_style_block  = '.header-title .subtitle{';
	$_style_block .= StockieHelper::parse_acf_typo_to_css( $post_text_typo );
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

// Post headings
if ( StockieHelper::parse_acf_typo_to_css( $post_title_typo ) ) {
	// --- start of CSS ---
	$_style_block  = '#main .post .entry-content h1.page-title,';
	$_style_block .= '#main .post .entry-content h2.page-title,';
	$_style_block .= '#main .post .entry-content h3.page-title,';
	$_style_block .= '#main .post .entry-content h4.page-title,';
	$_style_block .= '#main .post .entry-content h5.page-title{';
	$_style_block .= StockieHelper::parse_acf_typo_to_css( $post_title_typo );
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}



if ( StockieSettings::get( 'subcribe_popup_typo', 'global' ) ) {
	$subcribe_popup_title_typo = json_decode( StockieSettings::get( 'subcribe_popup_typo', 'global' ) );
	$subcribe_popup_title_typo_css = StockieHelper::parse_acf_typo_to_css( $subcribe_popup_title_typo );

	if ( $subcribe_popup_title_typo_css ) {
		// --- start of CSS ---
		$_style_block = '.subscribe-popup .subscribe-content-header {';
		$_style_block .= $subcribe_popup_title_typo_css;
		$_style_block .= '}';
		// --- end of CSS ---
		StockieLayout::append_to_dynamic_css_buffer( $_style_block );
	}

}

if ( StockieSettings::get( 'details_text_subcribe_popup_typo', 'global' ) ) {
	$subcribe_popup_description_typo = json_decode( StockieSettings::get( 'details_text_subcribe_popup_typo', 'global' ) );
	$subcribe_popup_description_typo_css = StockieHelper::parse_acf_typo_to_css( $subcribe_popup_description_typo );

	if ( $subcribe_popup_description_typo_css ) {
		// --- start of CSS ---
		$_style_block = '.subscribe-popup .subscribe-content-subheader {';
		$_style_block .= $subcribe_popup_description_typo_css;
		$_style_block .= '}';
		// --- end of CSS ---
		StockieLayout::append_to_dynamic_css_buffer( $_style_block );
	}

}

if ( StockieSettings::get( 'subcribe_popup_background_color', 'global' ) ) {
	$subscribe_background_color = StockieSettings::get( 'subcribe_popup_background_color', 'global' );
	$subscribe_background_color_css = 'background-color: ' . $subscribe_background_color;

	if ( $subscribe_background_color_css ) {
		// --- start of CSS ---
		$_style_block = '.subscribe-popup .subscribe {';
		$_style_block .= $subscribe_background_color_css;
		$_style_block .= '}';
		// --- end of CSS ---
		StockieLayout::append_to_dynamic_css_buffer( $_style_block );
	}

}
