<?php
/*
	Page custom style
	
	Table of contents: (you can use search)
	# 1. Variables
	# 2. Colors
	# 3. View
*/

if ( ! StockieSettings::page_is( 'projects_page' ) ) {
	return false;
}

# 1. Variables

$title_color       = false;
$category_color    = false;
$category_bg_color = false;
$more_color        = false;
$overlay_color     = false;
$background_color  = false;

$title_color_css       = '';
$category_color_css = '';
$category_bg_color_css = '';
$more_color_css        = '';
$overlay_color_css     = '';
$background_color_css  = '';

// Get layout
$projects_layout_item = StockieSettings::get( 'portfolio_item_layout_type' );
if ( ! $projects_layout_item || $projects_layout_item == 'inherit' ) {
	$projects_layout_item = StockieSettings::get( 'portfolio_item_layout_type', 'global' );
}


# 2. Colors

$title_color = StockieSettings::get( 'portfolio_page_title_color' );
if ( ! $title_color ) {
	$title_color = StockieSettings::get( 'portfolio_page_title_color', 'global' );
}
if ( $title_color ) {
	$title_color_css = 'color:' . $title_color . ';';
}

$category_color = StockieSettings::get( 'portfolio_page_category_color' );
if ( ! $category_color ) {
	$category_color = StockieSettings::get( 'portfolio_page_category_color', 'global' );
}
if ( $category_color ) {
	$category_color_css = 'color:' . $category_color . ';';
}

$category_bg_color = StockieSettings::get( 'portfolio_page_category_bg_color' );
if ( ! $category_bg_color ) {
	$category_bg_color = StockieSettings::get( 'portfolio_page_category_bg_color', 'global' );
}
if ( $category_bg_color ) {
	$category_bg_color_css = 'background-color:' . $category_bg_color . ';';
}

$more_color = StockieSettings::get( 'portfolio_page_more_color' );
if ( ! $more_color ) {
	$more_color = StockieSettings::get( 'portfolio_page_more_color', 'global' );
}
if ( $more_color ) {
	$more_color_css = 'color:' . $more_color . ';';
}

$overlay_color = StockieSettings::get( 'portfolio_page_overlay_color' );
if ( ! $overlay_color ) {
	$overlay_color = StockieSettings::get( 'portfolio_page_overlay_color', 'global' );
}
if ( $overlay_color ) {
	$overlay_color_css = 'background-color:' . $overlay_color . ';';
}

$background_color = StockieSettings::get( 'portfolio_page_background_color' );
if ( ! $background_color ) {
	$background_color = StockieSettings::get( 'portfolio_page_background_color', 'global' );
}
if ( $background_color ) {
	$background_color_css = 'background-color:' . $background_color . ';';
}


# 6. View

if ( $title_color_css ) {
	// --- start of CSS ---
	$_style_block = '.portfolio-item .description h4.title{';
	$_style_block .= $title_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $category_color_css ) {
	// --- start of CSS ---
	$_style_block = '.portfolio-item .tag, .portfolio-item.grid-1:hover .tag{';
	$_style_block .= $category_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $category_bg_color_css ) {
	// --- start of CSS ---
	$_style_block = '.portfolio-item .tag{';
	$_style_block .= $category_bg_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $more_color_css ) {
	// --- start of CSS ---
	$_style_block = '';
	switch ( $projects_layout_item ) {
		default:
			$_style_block .= '.portfolio-item .btn-link, .portfolio-item .more .ion{';
			break;
	}
	$_style_block .= $more_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $overlay_color_css ) {
	// --- start of CSS ---
	$_style_block = '';
	switch ( $projects_layout_item ) {
		default:
			$_style_block .= '.portfolio-item.grid-1:after, .portfolio-item.grid-2.hover-2 .overlay{';
			break;
	}
	$_style_block .= $overlay_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}