<?php
/*
	Header title custom style

	Table of contents: (you can use search)
	# 1. Variables
	# 2. Background color
	# 3. Background image
	# 3.1. Background image size
	# 3.2. Background image position
	# 3.3. Background image repeat
	# 4. Title settings
	# 5. Subtitle settings
	# 6. Choose background overlay color
	# 7. Header title height
	# 8. View
*/


# 1. Variables

$header_title_height 	= false;
$background_color 		= false;
$background_image 		= false;
$background_size 		= false;
$background_position 	= false;
$background_repeat 		= false;
$title_typo			    = false;
$subtitle_typo 			= false;
$single_poduct_title_typo = false;
$single_poduct_category_typo = false;
$single_product_price_typo = false;
$shop_grid_title_typo    = false;
$shop_grid_category_typo = false;
$shop_grid_price_typo    = false;
$shop_sale_tag_background_color = false;
$shop_out_stock_tag_background_color = false;
$overlay_color 			 = false;
$shop_title_wrap_background_color = false;

$back_button_type = false;
$back_button_typo = false;
$background_color_css 	 = '';
$background_image_css 	 = '';
$background_size_css 	 = '';
$background_position_css = '';
$background_repeat_css 	 = '';
$title_typo_css 		    = '';
$subtitle_typo_css 		 = '';
$overlay_color_css 		 = '';
$header_title_height_css = '';


# 2. Background color

if ( StockieSettings::page_is( 'single' ) ) {
	$background_color = StockieSettings::get( 'post_title_background_color' );
	if ( ! $background_color && in_array( StockieSettings::get( 'post_title_background' ), array( 'inherit', NULL ) ) ) {
		$background_color = StockieSettings::get( 'post_title_background_color', 'global' );
		if ( ! $background_color && in_array( StockieSettings::get( 'post_title_background_type', 'global' ), array( 'inherit', NULL ) ) ) {
			$background_color = StockieSettings::get( 'header_background_color', 'global' );
		}
	}
} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
	$background_color = StockieSettings::get( 'header_background_color' );
	if ( ! $background_color && in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
		$background_color = StockieSettings::get( 'woocommerce_header_background_color', 'global' );
		if ( ! $background_color && in_array( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ), array( 'inherit', NULL ) ) ) {
			$background_color = StockieSettings::get( 'header_background_color', 'global' );
		}
	}
} elseif ( StockieSettings::page_is( 'project' ) ) {
	$background_color = StockieSettings::get( 'header_background_color' );
	if ( ! $background_color && in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
		if ( in_array( StockieSettings::get( 'portfolio_header_title_type', 'global' ), array( 'inherit', NULL ) ) ) {
			$background_color = StockieSettings::get( 'header_background_color', 'global' );
		} else {
			$background_color = StockieSettings::get( 'portfolio_title_background_color', 'global' );
		}
	}
} else {
	$background_color = StockieSettings::get( 'header_background_color' );
	if ( ! $background_color && in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
		$background_color = StockieSettings::get( 'header_background_color', 'global' );
	}
}

if ( $background_color ) {
	$background_color_css = 'background-color:' . $background_color . ';';
}


# 3. Background image

if ( StockieSettings::page_is( 'single' ) ) {
	switch ( StockieSettings::get( 'post_title_background' ) ) {
		case 'post_thumbnail':
			$post_thumbnail_images = wp_get_attachment_image_src( get_post_thumbnail_id(), 'thumbnail-size', true);
			if ( is_array( $post_thumbnail_images ) ) {
				$background_image = $post_thumbnail_images[0];
			}
			break;
		case 'loaded_image':
			$background_image = StockieSettings::get( 'post_title_background_image' );
			break;
		case 'color':
			$background_image = false;
			break;
		case 'inherit':
		default:
			switch ( StockieSettings::get( 'post_title_background_type', 'global' ) ) {
				case 'post_thumbnail':
					$post_thumbnail_images = wp_get_attachment_image_src( get_post_thumbnail_id(), 'thumbnail-size', true);
					if ( is_array( $post_thumbnail_images ) ) {
						$background_image = $post_thumbnail_images[0];
					}
					break;
				case 'loaded_image':
					$background_image = StockieSettings::get( 'post_title_background_image', 'global' );
					break;
				case 'color':
					$background_image = false;
					break;
				default:
					if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
						$background_image = StockieSettings::get( 'header_title_background_image', 'global' );
					}
					break;
			}
			break;
	}
} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
	$_woocommerce_inherit = true;
	if ( StockieSettings::page_is( 'product_category' ) ) {
		global $wp_query;
		$cat = $wp_query->get_queried_object();
		$thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
		if ( $thumbnail_id ) {
			$background_image = wp_get_attachment_url( $thumbnail_id );
			$_woocommerce_inherit = false;
		}
	}
	if ( $_woocommerce_inherit ) {
		if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
			$background_image = StockieSettings::get( 'header_background_image' );
		} elseif ( in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'image' ) {
				$background_image = StockieSettings::get( 'woocommerce_header_background_image', 'global' );
			} elseif ( in_array( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ), array( 'inherit', NULL ) ) ) {
				if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
					$background_image = StockieSettings::get( 'header_title_background_image', 'global' );
				}
			}
		}
	}
} elseif ( StockieSettings::page_is( 'project' ) ) {
	if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
		$background_image = StockieSettings::get( 'header_background_image' );
	} elseif ( in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
		if ( StockieSettings::get( 'portfolio_header_title_type', 'global' ) == 'custom' ) {
			$background_image = StockieSettings::get( 'portfolio_title_background_image', 'global' );
		} elseif ( in_array( StockieSettings::get( 'portfolio_header_title_type', 'global' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
			 	$background_image = StockieSettings::get( 'header_title_background_image', 'global' );
			}
		}
	}
} else {
    if( has_post_thumbnail() && !is_home() ){
		$post = get_post( 'page ' );
		
        $background_image = get_the_post_thumbnail_url($post, 'full');
    } else {
        if (StockieSettings::get('header_background_type') == 'image') {
            $background_image = StockieSettings::get('header_background_image');
        } elseif (StockieSettings::get('header_background_type') == 'inherit'
            || StockieSettings::get('header_background_type') === NULL) {
            if (StockieSettings::get('header_title_background_type', 'global') == 'image') {
                $background_image = StockieSettings::get('header_title_background_image', 'global');
            }
        }
    }
}

if ( $background_image ) {
	$background_image_css = 'background-image:url(\'' . $background_image . '\');';
}


# 3.1. Background image size

if ( StockieSettings::page_is( 'single' ) ) {
	switch ( StockieSettings::get( 'post_title_background' ) ) {
		case 'post_thumbnail':
		case 'loaded_image':
		$background_size = StockieSettings::get( 'post_title_background_size' );
			break;
		case 'color':
	 	$background_size = false;
			break;
		default:
			switch ( StockieSettings::get( 'post_title_background_type', 'global' ) ) {
				case 'post_thumbnail':
				case 'custom':
					$background_size = StockieSettings::get( 'post_title_background_size', 'global' );
					break;
				case 'color':
					$background_size = false;
					break;
				default:
					if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
						$background_size = StockieSettings::get( 'header_title_background_size', 'global' );
					}
					break;
			}
			break;
	}
} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
	if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
		$background_size = StockieSettings::get( 'header_background_size' );
	} elseif ( StockieSettings::get( 'header_background_type' ) == 'inherit'
				|| StockieSettings::get( 'header_background_type' ) === NULL ) {
		if ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'custom' ) {
			$background_size = StockieSettings::get( 'woocommerce_header_background_size', 'global' );
		} elseif ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'inherit'
					|| StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) === NULL ) {
			if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
				$background_size = StockieSettings::get( 'header_title_background_size', 'global' );
			}
		}
	}
} elseif ( StockieSettings::page_is( 'project' ) ) {
	if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
		$background_size = StockieSettings::get( 'header_background_size' );
	} elseif ( in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
		if ( StockieSettings::get( 'portfolio_header_title_type', 'global' ) == 'custom' ) {
			$background_size = StockieSettings::get( 'portfolio_title_background_size', 'global' );
		} elseif ( in_array( StockieSettings::get( 'portfolio_header_title_type', 'global' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
				$background_size = StockieSettings::get( 'header_title_background_size', 'global' );
			}
		}
	}
} else {
	if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
		$background_size = StockieSettings::get( 'header_background_size' );
	} elseif ( in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
		if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
			$background_size = StockieSettings::get( 'header_title_background_size', 'global' );
		}
	}
}

switch ( $background_size ) {
	case 'auto':
		$background_size_css = 'background-size:auto;';
		break;
	case 'cover':
		$background_size_css = 'background-size:cover;';
		break;
	case 'contain':
		$background_size_css = 'background-size:contain;';
		break;
	case '100per':
		$background_size_css = 'background-size:100% 100%;';
		break;
}


# 3.2. Background image position

if ( $background_size == 'auto' || $background_size == 'contain' ) {
	if ( StockieSettings::page_is( 'single' ) ) {
		switch ( StockieSettings::get( 'post_title_background' ) ) {
			case 'post_thumbnail':
			case 'loaded_image':
				$background_position = StockieSettings::get( 'post_title_background_position' );
				break;
			case 'color':
		 		$background_position = false;
				break;
			default:
				switch ( StockieSettings::get( 'post_title_background_type', 'global' ) ) {
					case 'post_thumbnail':
					case 'custom':
						$background_position = StockieSettings::get( 'post_title_background_position', 'global' );
						break;
					case 'color':
						$background_position = false;
						break;
					default:
						if ( StockieSettings::get( 'header_title_background_type' == 'image' ) ) {
							$background_position = StockieSettings::get( 'header_title_background_position', 'global' );
						}
						break;
				}
				break;
		}
	} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
		if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
			$background_position = StockieSettings::get( 'header_background_position' );
		} elseif ( StockieSettings::get( 'header_background_type' ) == 'inherit'
					|| StockieSettings::get( 'header_background_type' ) === NULL ) {
			if ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'custom' ) {
				$background_position = StockieSettings::get( 'woocommerce_header_background_position', 'global' );
			} elseif ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'inherit'
						|| StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) === NULL ) {
				if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
					$background_position = StockieSettings::get( 'header_title_background_position', 'global' );
				}
			}
		}
	} elseif ( StockieSettings::page_is( 'project' ) ) {
		if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
			$background_position = StockieSettings::get( 'header_background_position' );
		} elseif ( in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'portfolio_header_title_type', 'global' ) == 'image' ) {
				$background_position = StockieSettings::get( 'portfolio_title_background_position', 'global' );
			} elseif ( in_array( StockieSettings::get( 'portfolio_header_title_type', 'global' ), array( 'inherit', NULL ) ) ) {
				if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
					$background_position = StockieSettings::get( 'header_title_background_position', 'global' );
				}
			}
		}
	} else {
		if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
			$background_position = StockieSettings::get( 'header_background_position' );
		} elseif ( StockieSettings::get( 'header_background_type' ) == 'inherit'
					|| StockieSettings::get( 'header_background_type' ) === NULL ) {
			if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
				$background_position = StockieSettings::get( 'header_title_background_position', 'global' );
			}
		}
	}

	if ( $background_position ) {
		switch ( $background_position ) {
			case 'left_top':
				$background_position_css = 'background-position:left top;';
				break;
			case 'left_center':
				$background_position_css = 'background-position:left center;';
				break;
			case 'left_bottom':
				$background_position_css = 'background-position:left bottom;';
				break;
			case 'center_top':
				$background_position_css = 'background-position:center top;';
				break;
			case 'center':
				$background_position_css = 'background-position:center center;';
				break;
			case 'center_right':
				$background_position_css = 'background-position:center bottom;';
				break;
			case 'right_top':
				$background_position_css = 'background-position:right top;';
				break;
			case 'right_center':
				$background_position_css = 'background-position:right center;';
				break;
			case 'right_bottom':
				$background_position_css = 'background-position:right bottom;';
				break;
		}
	}
}


# 3.3. Background image repeat

if ( $background_size == 'auto' || $background_size == 'contain' ) {
	if ( StockieSettings::page_is( 'single' ) ) {
		switch ( StockieSettings::get( 'post_title_background' ) ) {
			case 'post_thumbnail':
			case 'loaded_image':
				$background_repeat = StockieSettings::get( 'post_title_background_repeat' );
				break;
			case 'color':
		 		$background_repeat = false;
				break;
			default:
				switch ( StockieSettings::get( 'post_title_background_type', 'global' ) ) {
					case 'post_thumbnail':
					case 'custom':
						$background_repeat = StockieSettings::get( 'post_title_background_repeat', 'global' );
						break;
					case 'color':
						$background_repeat = false;
						break;
					default:
						if ( StockieSettings::get( 'header_title_background_type' == 'image' ) ) {
							$background_repeat = StockieSettings::get( 'header_title_background_repeat', 'global' );
						}
						break;
				}
				break;
		}
	} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
		if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
			$background_repeat = StockieSettings::get( 'header_background_repeat' );
		} elseif ( StockieSettings::get( 'header_background_type' ) == 'inherit'
					|| StockieSettings::get( 'header_background_type' ) === NULL ) {
			if ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'custom' ) {
				$background_repeat = StockieSettings::get( 'woocommerce_header_background_repeat', 'global' );
			} elseif ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'inherit'
						|| StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) === NULL ) {
				if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
					$background_repeat = StockieSettings::get( 'header_background_repeat', 'global' );
				}
			}
		}
	} elseif ( StockieSettings::page_is( 'project' ) ) {
		if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
			$background_repeat = StockieSettings::get( 'header_background_repeat' );
		} elseif ( in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'portfolio_header_title_type', 'global' ) == 'image' ) {
				$background_repeat = StockieSettings::get( 'portfolio_title_background_repeat', 'global' );
			} elseif ( in_array( StockieSettings::get( 'portfolio_header_title_type', 'global' ), array( 'inherit', NULL ) ) ) {
				if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
					$background_repeat = StockieSettings::get( 'header_background_repeat', 'global' );
				}
			}
		}
	} else {
		if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
			$background_repeat = StockieSettings::get( 'header_background_repeat' );
		} elseif ( StockieSettings::get( 'header_background_type' ) == 'inherit'
					|| StockieSettings::get( 'header_background_type' ) === NULL ) {
			if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
				$background_repeat = StockieSettings::get( 'header_background_repeat', 'global' );
			}
		}
	}

	if ( $background_repeat ) {
		switch ( $background_repeat ) {
			case 'repeat':
				$background_repeat_css = 'background-repeat: repeat;';
				break;
			case 'no_repeat':
				$background_repeat_css = 'background-repeat: no-repeat;';
				break;
			case 'repeat_x':
				$background_repeat_css = 'background-repeat: repeat-x;';
				break;
			case 'repeat_y':
				$background_repeat_css = 'background-repeat: repeat-y;';
				break;
		}
	}
}


# 4. Title typography

if ( StockieSettings::page_is( 'single' ) ) {
	if ( StockieSettings::get( 'post_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'post_header_title_typo' ) ) {
			$title_typo = json_decode( StockieSettings::get( 'post_header_title_typo' ) );
		}
	} elseif ( StockieSettings::get( 'post_typography_settings' ) == 'inherit'
				|| StockieSettings::get( 'post_typography_settings' ) === NULL ) {
		if ( StockieSettings::get( 'post_typography_settings', 'global' ) == 'custom' ) {
			if ( StockieSettings::get( 'post_header_title_typo', 'global' ) ) {
				$title_typo = json_decode( StockieSettings::get( 'post_header_title_typo', 'global' ) );
			}
		} elseif ( StockieSettings::get( 'post_typography_settings', 'global' ) == 'inherit'
					|| StockieSettings::get( 'post_typography_settings', 'global' ) === NULL ) {
			if ( StockieSettings::get( 'header_tilte_typo', 'global' ) ) {
				$title_typo = json_decode( StockieSettings::get( 'header_tilte_typo', 'global' ) );
			}
		}
	}
} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
	if ( StockieSettings::get( 'page_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'page_header_title_typo' ) ) {
			$title_typo = json_decode( StockieSettings::get( 'page_header_title_typo' ) );
		}
	} elseif ( StockieSettings::get( 'page_typography_settings' ) == 'inherit'
				|| StockieSettings::get( 'page_typography_settings' ) === NULL ) {
		if ( StockieSettings::get( 'woocommerce_page_typography_settings', 'global' ) == 'custom' ) {
			if ( StockieSettings::get( 'woocommerce_header_title_typo', 'global' ) ) {
				$title_typo = json_decode( StockieSettings::get( 'woocommerce_header_title_typo', 'global' ) );
			}
		} elseif ( StockieSettings::get( 'woocommerce_page_typography_settings', 'global' ) == 'inherit'
					|| StockieSettings::get( 'woocommerce_page_typography_settings', 'global' ) === NULL ) {
			if ( StockieSettings::get( 'header_tilte_typo', 'global' ) ) {
				$title_typo = json_decode( StockieSettings::get( 'header_tilte_typo', 'global' ) );
			}
		}elseif ( StockieSettings::get( 'woocommerce_simple_product_title_typo', 'global' ) ) {
				$title_typo = json_decode( StockieSettings::get( 'woocommerce_simple_product_title_typo', 'global' ) );
			}
		}

} elseif ( StockieSettings::page_is( 'project' ) ) {
	if ( StockieSettings::get( 'page_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'page_header_title_typo' ) ) {
			$title_typo = json_decode( StockieSettings::get( 'page_header_title_typo' ) );
		}
	} elseif ( in_array( StockieSettings::get( 'page_typography_settings' ), array( 'inherit', NULL ) ) ) {
		if ( StockieSettings::get( 'portfolio_typography_settings', 'global' ) == 'custom' ) {
			if ( StockieSettings::get( 'project_header_title_typo', 'global' ) ) {
				$title_typo = json_decode( StockieSettings::get( 'project_header_title_typo', 'global' ) );
			}
		} elseif ( in_array( StockieSettings::get( 'portfolio_typography_settings', 'global' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'header_tilte_typo', 'global' ) ) {
				$title_typo = json_decode( StockieSettings::get( 'header_tilte_typo', 'global' ) );
			}
		}
	}
} else {
	if ( StockieSettings::get( 'page_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'page_header_title_typo' ) ) {
			$title_typo = json_decode( StockieSettings::get( 'page_header_title_typo' ) );
		}
	} elseif ( StockieSettings::get( 'page_typography_settings' ) == 'inherit'
				|| StockieSettings::get( 'page_typography_settings' ) === NULL ) {
		if ( StockieSettings::get( 'header_tilte_typo', 'global' ) ) {
			$title_typo = json_decode( StockieSettings::get( 'header_tilte_typo', 'global' ) );
		}
	}
}
$title_typo_css = StockieHelper::parse_acf_typo_to_css( $title_typo );


# 5. Subtitle typography

if ( StockieSettings::page_is( 'single' ) ) {
	if ( StockieSettings::get( 'post_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'post_header_subtitle_typo' ) ) {
			$subtitle_typo = json_decode( StockieSettings::get( 'post_header_subtitle_typo' ) );
		}
	} elseif ( StockieSettings::get( 'post_typography_settings' ) == 'inherit'
				|| StockieSettings::get( 'post_typography_settings' ) === NULL ) {
		if ( StockieSettings::get( 'post_typography_settings', 'global' ) == 'custom' ) {
			if ( StockieSettings::get( 'post_header_subtitle_typo', 'global' ) ) {
				$subtitle_typo = json_decode( StockieSettings::get( 'post_header_subtitle_typo', 'global' ) );
			}
		} elseif ( StockieSettings::get( 'post_typography_settings', 'global' ) == 'inherit'
					|| StockieSettings::get( 'post_typography_settings', 'global' ) === NULL ) {
			if ( StockieSettings::get( 'header_subtilte_typo', 'global' ) ) {
				$subtitle_typo = json_decode( StockieSettings::get( 'header_subtilte_typo', 'global' ) );
			}
		}
	}
} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
	if ( StockieSettings::get( 'page_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'page_header_subtitle_typo' ) ) {
			$subtitle_typo = json_decode( StockieSettings::get( 'page_header_subtitle_typo' ) );
		}
	} elseif ( StockieSettings::get( 'page_typography_settings' ) == 'inherit'
				|| StockieSettings::get( 'page_typography_settings' ) === NULL ) {
		if ( StockieSettings::get( 'woocommerce_page_typography_settings', 'global' ) == 'custom' ) {
			if ( StockieSettings::get( 'woocommerce_header_subtitle_typo', 'global' ) ) {
				$subtitle_typo = json_decode( StockieSettings::get( 'woocommerce_header_subtitle_typo', 'global' ) );
			}
		} elseif ( StockieSettings::get( 'woocommerce_page_typography_settings', 'global' ) == 'inherit'
					|| StockieSettings::get( 'woocommerce_page_typography_settings', 'global' ) === NULL ) {
			if ( StockieSettings::get( 'header_subtilte_typo', 'global' ) ) {
				$subtitle_typo = json_decode( StockieSettings::get( 'header_subtilte_typo', 'global' ) );
			}


		}
	}
} elseif ( StockieSettings::page_is( 'project' ) ) {
	if ( StockieSettings::get( 'page_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'page_header_subtitle_typo' ) ) {
			$subtitle_typo = json_decode( StockieSettings::get( 'page_header_subtitle_typo' ) );
		}
	} elseif ( in_array( StockieSettings::get( 'page_typography_settings' ), array( 'inherit', NULL ) ) ) {
		if ( StockieSettings::get( 'portfolio_typography_settings', 'global' ) == 'custom' ) {
			if ( StockieSettings::get( 'project_header_subtitle_typo', 'global' ) ) {
				$subtitle_typo = json_decode( StockieSettings::get( 'project_header_subtitle_typo', 'global' ) );
			}
		} elseif ( in_array( StockieSettings::get( 'portfolio_typography_settings', 'global' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'header_subtilte_typo', 'global' ) ) {
				$subtitle_typo = json_decode( StockieSettings::get( 'header_subtilte_typo', 'global' ) );
			}
		}
	}
} else {
	if ( StockieSettings::get( 'page_typography_settings' ) == 'custom' ) {
		if ( StockieSettings::get( 'page_header_subtitle_typo' ) ) {
			$subtitle_typo = json_decode( StockieSettings::get( 'page_header_subtitle_typo' ) );
		}
	} elseif ( StockieSettings::get( 'page_typography_settings' ) == 'inherit'
				|| StockieSettings::get( 'page_typography_settings' ) === NULL ) {
		if ( StockieSettings::get( 'header_subtilte_typo', 'global' ) ) {
			$subtitle_typo = json_decode( StockieSettings::get( 'header_subtilte_typo', 'global' ) );
		}
	}
}

$subtitle_typo_css = StockieHelper::parse_acf_typo_to_css( $subtitle_typo );

if ( StockieSettings::page_is( 'ecommerce' ) ) {
	if ( StockieSettings::get( 'woocommerce_shop_product_title_typo', 'global' ) ) {
		$shop_grid_title_typo = json_decode( StockieSettings::get( 'woocommerce_shop_product_title_typo', 'global' ) );
	}
	if (StockieSettings::get( 'woocommerce_shop_product_category_typo', 'global' ) ) {
		$shop_grid_category_typo = json_decode( StockieSettings::get( 'woocommerce_shop_product_category_typo', 'global' ) );
	}
	if (StockieSettings::get( 'woocommerce_shop_product_price_typo', 'global' ) ) {
		$shop_grid_price_typo = json_decode( StockieSettings::get( 'woocommerce_shop_product_price_typo', 'global' ) );
	}
}

$shop_grid_title_typo_css= StockieHelper::parse_acf_typo_to_css( $shop_grid_title_typo );

$shop_grid_category_typo_css= StockieHelper::parse_acf_typo_to_css( $shop_grid_category_typo );

$shop_grid_price_typo_css= StockieHelper::parse_acf_typo_to_css( $shop_grid_price_typo );

if ( StockieSettings::page_is( 'ecommerce' ) ) {
    // Single product
	if ( StockieSettings::get( 'woocommerce_single_product_title_typo' ) ) {
		$single_poduct_title_typo = json_decode( StockieSettings::get( 'woocommerce_single_product_title_typo' ) );
	}
    // Global setting
    if ( !isset($single_poduct_title_typo->color) && StockieSettings::get( 'woocommerce_single_product_title_typo', 'global' ) ) {
		$single_poduct_title_typo = json_decode( StockieSettings::get( 'woocommerce_single_product_title_typo', 'global' ) );
	}
    // Single product
	if ( StockieSettings::get( 'woocommerce_single_product_category_typo' ) ) {
		$single_poduct_category_typo = json_decode( StockieSettings::get( 'woocommerce_single_product_category_typo' ) );
	}
    // Global setting
	if ( !isset($single_poduct_category_typo->color) &&  StockieSettings::get( 'woocommerce_single_product_category_typo', 'global' ) ) {
		$single_poduct_category_typo = json_decode( StockieSettings::get( 'woocommerce_single_product_category_typo', 'global' ) );
	}
    // Single product
	if ( StockieSettings::get( 'woocommerce_single_product_price_typo' ) ) {
		$single_product_price_typo = json_decode( StockieSettings::get( 'woocommerce_single_product_price_typo' ) );
	}
    // Global setting
	if ( !isset($single_product_price_typo->color) && StockieSettings::get( 'woocommerce_single_product_price_typo', 'global' ) ) {
		$single_product_price_typo = json_decode( StockieSettings::get( 'woocommerce_single_product_price_typo', 'global' ) );
	}
}

$single_poduct_title_typo_css = StockieHelper::parse_acf_typo_to_css( $single_poduct_title_typo );
$single_poduct_category_typo_css = StockieHelper::parse_acf_typo_to_css( $single_poduct_category_typo );

$single_product_price_typo_css = StockieHelper::parse_acf_typo_to_css( $single_product_price_typo );

if ( StockieSettings::page_is( 'ecommerce' ) ) {
	if ( StockieSettings::get( 'woocommerce_shop_sale_tag_background_color', 'global' ) ) {
		$shop_sale_tag_background_color =  StockieSettings::get( 'woocommerce_shop_sale_tag_background_color', 'global' ) ;
	}
	if (StockieSettings::get( 'woocommerce_shop_out_stock_tag_background_color', 'global' ) ) {
		$shop_out_stock_tag_background_color =  StockieSettings::get( 'woocommerce_shop_out_stock_tag_background_color', 'global' );
	}
	if ( StockieSettings::get( 'woocommerce_shop_title_wrap_background_color', 'global' ) ) {
		$shop_title_wrap_background_color =  StockieSettings::get( 'woocommerce_shop_title_wrap_background_color', 'global' ) ;
	}
}

if ( $shop_sale_tag_background_color ) {
	$shop_sale_tag_background_color_css = 'background-color:' . $shop_sale_tag_background_color . ';';
}
if ( $shop_out_stock_tag_background_color ) {
	$shop_out_stock_tag_background_color_css = 'background-color:' . $shop_out_stock_tag_background_color . ';';
}

if ( $shop_title_wrap_background_color ) {
	$shop_title_wrap_background_color_css = 'background-color:' . $shop_title_wrap_background_color . ';';
}



# 6. Choose background overlay color

if ( StockieSettings::page_is( 'single' ) ) {
	switch ( StockieSettings::get( 'post_title_background' ) ) {
		case 'post_thumbnail':
		case 'loaded_image':
			if ( StockieSettings::get( 'post_title_use_overlay' ) == 'yes' ) {
				$overlay_color = StockieSettings::get( 'post_title_background_overlay' );
			} elseif ( StockieSettings::get( 'post_title_use_overlay' ) == 'inherit'
						|| StockieSettings::get( 'post_title_use_overlay' ) === NULL ) {
				switch ( StockieSettings::get( 'post_title_background_type', 'global' ) ) {
					case 'post_thumbnail':
					case 'custom':
						if ( StockieSettings::get( 'post_use_title_overlay', 'global' ) ) {
							$overlay_color = StockieSettings::get( 'post_title_background_overlay_color', 'global' );
						}
						break;
					case 'color':
						break;
					default:
						if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
							if ( StockieSettings::get( 'header_use_overlay', 'global' ) ) {
								$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
							}
						}
						break;
				}
			}
			break;
		case 'color':
			break;
		default:
			switch ( StockieSettings::get( 'post_title_background_type', 'global' ) ) {
				case 'post_thumbnail':
				case 'custom':
					if ( StockieSettings::get( 'post_use_title_overlay', 'global' ) ) {
						$overlay_color = StockieSettings::get( 'post_title_background_overlay_color', 'global' );
					}
					break;
				case 'color':
					break;
				default:
					if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
						if ( StockieSettings::get( 'header_use_overlay', 'global' ) ) {
							$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
						}
					}
					break;
			}
	}
} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
	if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
		if ( StockieSettings::get( 'header_use_overlay' ) == 'yes' ) {
			$overlay_color = StockieSettings::get( 'header_overlay_color' );
		} elseif ( StockieSettings::get( 'header_use_overlay' ) == 'inherit'
					|| StockieSettings::get( 'header_use_overlay' ) === NULL ) {
			if ( StockieSettings::get( 'woocommerce_header_title_background_type', 'global' ) == 'custom' ) {
				if ( StockieSettings::get( 'woocommerce_header_use_overlay', 'global' ) == 'yes' ) {
					$overlay_color = StockieSettings::get( 'woocommerce_header_overlay_color', 'global' );
				} elseif ( StockieSettings::get( 'woocommerce_header_use_overlay', 'global' ) == 'inherit'
							|| StockieSettings::get( 'woocommerce_header_use_overlay', 'global' ) === NULL ) {
					if ( StockieSettings::get( 'header_use_overlay', 'global' )
						&& StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
						$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
					}
				}
			} elseif ( StockieSettings::get( 'woocommerce_title_background_type', 'global' ) == 'inherit'
						|| StockieSettings::get( 'woocommerce_title_background_type', 'global' ) === NULL ) {
				if ( StockieSettings::get( 'header_use_overlay', 'global' )
					&& StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
					$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
				}
			}
		}
	} elseif ( StockieSettings::get( 'header_background_type' ) == 'inherit'
				|| StockieSettings::get( 'header_background_type' ) === NULL ) {
		if ( StockieSettings::get( 'woocommerce_header_use_overlay', 'global' ) == 'yes' ) {
			$overlay_color = StockieSettings::get( 'woocommerce_header_overlay_color', 'global' );
		} elseif ( StockieSettings::get( 'woocommerce_header_use_overlay', 'global' ) == 'inherit'
					|| StockieSettings::get( 'woocommerce_header_use_overlay', 'global' ) === NULL ) {
			if ( StockieSettings::get( 'header_use_overlay', 'global' )
				&& StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
				$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
			}
		}
	}
} elseif ( StockieSettings::page_is( 'project' ) ) {
	if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
		if ( StockieSettings::get( 'header_use_overlay' ) == 'yes' ) {
			$overlay_color = StockieSettings::get( 'header_overlay_color' );
		} elseif ( in_array( StockieSettings::get( 'header_use_overlay' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'portfolio_header_title_type', 'global' ) == 'custom' ) {
				if ( StockieSettings::get( 'portfolio_use_title_overlay', 'global' ) == 'yes' ) {
					$overlay_color = StockieSettings::get( 'portfolio_title_background_overlay_color', 'global' );
				} elseif ( in_array( StockieSettings::get( 'portfolio_use_title_overlay', 'global' ), array( 'inherit', NULL ) ) ) {
					if ( StockieSettings::get( 'header_use_overlay', 'global' )
						&& StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
						$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
					}
				}
			} elseif ( in_array( StockieSettings::get( 'portfolio_header_title_type', 'global' ), array( 'inherit', NULL ) ) ) {
				if ( StockieSettings::get( 'header_use_overlay', 'global' )
					&& StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
					$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
				}
			}
		}
	} elseif ( in_array( StockieSettings::get( 'header_background_type' ), array( 'inherit', NULL ) ) ) {
		if ( StockieSettings::get( 'portfolio_header_title_type', 'global' ) == 'custom'
				&& StockieSettings::get( 'portfolio_use_title_overlay', 'global' ) ) {
			$overlay_color = StockieSettings::get( 'portfolio_title_background_overlay_color', 'global' );
		} elseif ( in_array( StockieSettings::get( 'portfolio_header_title_type', 'global' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'header_use_overlay', 'global' )
					&& StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
				$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
			}
		}
	}
} else {
	if ( StockieSettings::get( 'header_background_type' ) == 'image' ) {
		if ( StockieSettings::get( 'header_use_overlay' ) == 'yes' ) {
			$overlay_color = StockieSettings::get( 'header_overlay_color' );
		} elseif ( in_array( StockieSettings::get( 'header_use_overlay' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'header_use_overlay', 'global' )
				&& StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
				$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
			}
		}
	} elseif ( StockieSettings::get( 'header_background_type' ) == 'inherit'
				|| StockieSettings::get( 'header_background_type' ) === NULL ) {
		if ( StockieSettings::get( 'header_title_background_type', 'global' ) == 'image' ) {
			if ( StockieSettings::get( 'header_use_overlay', 'global' ) ) {
				$overlay_color = StockieSettings::get( 'header_overlay_color', 'global' );
			}
		}
	}
}

if ( $overlay_color && substr( trim( $overlay_color ), 0, 4 ) != 'rgba' ) {
	$overlay_color = StockieHelper::hex_to_rgba( $overlay_color, 0.6 );
}
if ( ! $background_image || ! StockieSettings::header_title_use_overlay() ) {
	$overlay_color = 'transparent';
}

if ( $overlay_color ) {
	$overlay_color_css = 'background-color:' . $overlay_color . ';';
}


# 7. Header title height

if ( StockieSettings::page_is( 'single' ) ) {
	$header_title_height = StockieSettings::get( 'post_title_height' );
	if ( ! $header_title_height ) {
		$header_title_height = StockieSettings::get( 'post_header_height', 'global' );
		if ( ! $header_title_height ) {
			$header_title_height = StockieSettings::get( 'header_height', 'global' );
		}
	}
} elseif ( StockieSettings::page_is( 'ecommerce' ) ) {
	$header_title_height = StockieSettings::get( 'header_height' );
	if ( ! $header_title_height ) {
		$header_title_height = StockieSettings::get( 'woocommerce_header_height', 'global' );
		if ( ! $header_title_height ) {
			$header_title_height = StockieSettings::get( 'header_height', 'global' );
		}
	}
} elseif ( StockieSettings::page_is( 'project' ) ) {
	$header_title_height = StockieSettings::get( 'header_height' );
	if ( ! $header_title_height ) {
		if ( StockieSettings::get( 'project_header_title_height_settings', 'global' ) == 'custom' ) {
			$header_title_height = StockieSettings::get( 'project_header_height', 'global' );
		} else {
			$header_title_height = StockieSettings::get( 'header_height', 'global' );
		}
	}
} else {
	$header_title_height = StockieSettings::get( 'header_height' );
	if ( ! $header_title_height ) {
		$header_title_height = StockieSettings::get( 'header_height', 'global' );
	}
}

if ( StockieSettings::header_title_is_full_height() ) {
	$header_title_height = false;
}

if ( $header_title_height ) {
	$header_title_height_css .= 'min-height:${height}px;';

	$header_title_height_css = StockieHelper::parse_responsive_height_to_css( $header_title_height, $header_title_height_css );
}


# 8. Back button

if ( StockieSettings::page_is( 'single' ) ) {
    $back_button_type = StockieSettings::get('post_typography_settings' );
    if ( in_array($back_button_type, array( 'inherit', NULL ) ) ) {
        $back_button_typo = StockieSettings::get('header_back_typo', 'global');
    } else {
        $back_button_typo = StockieSettings::get('header_back_typo');
    }
} else {
    $back_button_type = StockieSettings::get('page_typography_settings' );
    if ( in_array($back_button_type, array( 'inherit', NULL ) ) ) {
        $back_button_typo = StockieSettings::get('header_back_typo', 'global');
    } else {
        $back_button_typo = StockieSettings::get('header_back_typo');
    }
}


# 9. View

if($back_button_typo) {
    $back_button_typo_css = StockieHelper::parse_acf_typo_to_css($back_button_typo);
    // --- start of CSS ---
    $_style_block = '.back-link a.btn-link {';
    $_style_block .= $back_button_typo_css;
    $_style_block .= '}';
    // --- end of CSS ---
    StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $background_color_css || $background_image_css || $background_image_css || $background_size_css
	|| $background_position_css || $background_repeat_css ) {
	// --- start of CSS ---
	$_style_block = '.header-title .bg-image{';
	$_style_block .= $background_color_css;
	$_style_block .= $background_image_css;
	$_style_block .= $background_size_css;
	$_style_block .= $background_position_css;
	$_style_block .= $background_repeat_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $header_title_height_css ) {
	$header_title_height_classes = '.header-title';

	if ( $header_title_height_css['desktop'] ) {
		$_style_block = $header_title_height_classes . '{' . $header_title_height_css['desktop'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'desktop' );
	}
	if ( $header_title_height_css['tablet'] ) {
		$_style_block = $header_title_height_classes . '{' . $header_title_height_css['tablet'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'tablet' );
	}
	if ( $header_title_height_css['mobile'] ) {
		$_style_block = $header_title_height_classes . '{' . $header_title_height_css['mobile'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'mobile' );
	}
}

if ( $overlay_color_css ) {
	// --- start of CSS ---
	$_style_block = '.header-title::after{';
	$_style_block .= $overlay_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

// Title and subtitle
if ( $title_typo_css ) {
	// --- start of CSS ---
	$_style_block = '.header-title h1.page-title{';
	$_style_block .= $title_typo_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $subtitle_typo_css ) {
	// --- start of CSS ---
	$_style_block = '.header-title .subtitle{';
	$_style_block .= $subtitle_typo_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $single_poduct_title_typo_css ) {
	// --- start of CSS ---
	$_style_block = '.woo_c-product .product_title{';
	$_style_block .= $single_poduct_title_typo_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $single_poduct_category_typo_css  ) {
	// --- start of CSS ---
	$_style_block = '.product_meta{';
	$_style_block .= $single_poduct_category_typo_css ;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $single_product_price_typo_css  ) {
	// --- start of CSS ---
	$_style_block = '.woo-summary-content .price .amount{';
	$_style_block .= $single_product_price_typo_css ;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $shop_grid_title_typo_css ) {
	// --- start of CSS ---
	$_style_block = '.woocommerce ul.woo_c-products .wc-product-title-wrap h5 a{';
	$_style_block .= $shop_grid_title_typo_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $shop_grid_category_typo_css  ) {
	// --- start of CSS ---
	$_style_block = '.woocommerce ul.woo_c-products .wc-product-title-wrap .category a{';
	$_style_block .= $shop_grid_category_typo_css ;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
if ( $shop_grid_price_typo_css  ) {
	// --- start of CSS ---
	$_style_block = '.woocommerce ul.woo_c-products .wc-product-title-wrap .price, .woocommerce ul.woo_c-products .wc-product-title-wrap .add-to-cart a{';
	$_style_block .= $shop_grid_price_typo_css ;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( !empty( $shop_sale_tag_background_color_css ) ) {
	// --- start of CSS ---
	$_style_block = '.woocommerce .woo-onsale, .woo_c-product .price-discount{';
	$_style_block .= $shop_sale_tag_background_color_css ;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( !empty( $shop_out_stock_tag_background_color_css ) ) {
	// --- start of CSS ---
	$_style_block = '.woocommerce .woo-onsale.out{';
	$_style_block .= $shop_out_stock_tag_background_color_css ;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( !empty( $shop_title_wrap_background_color_css ) ) {
	// --- start of CSS ---
	$_style_block = '.shop-product-type_4 .wc-product-title-wrap {';
	$_style_block .= $shop_title_wrap_background_color_css ;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}
