<?php
/*
	Header navigation custom style
	
	Table of contents: (you can use search)
	# 1. Variables
	# 2. Background color
	# 3. Header menu typography
	# 4. Border state
	# 4.1. Border type
	# 4.2. Border color
	# 5. Header height
	# 6. Site name typography
	# 7. View
*/


# 1. Variables

$background_color 	= false;
$fixed_background_color = false;
$mobile_background_color = false;
$header_typo 		   = false;
$fixed_typo 		   = false;
$mobile_typo 		   = false;
$mobile_color 		   = false;
$border_hide 		   = false;
$border_type 		   = false;
$border_color 		   = false;
$fixed_border_hide   = false;
$fixed_border_type   = false;
$fixed_border_color  = false;
$header_height 		= false;
$fixed_height        = false;
$sitename_typo 		= false;

$background_color_css 	= '';
$fixed_background_color_css = '';
$mobile_header_menu_color_css = '';
$mobile_background_color_css = '';
$background_color_css_border = '';
$header_typo_css 		   = '';
$fixed_typo_css 		   = '';
$mobile_typo_css 		   = '';
$mobile_color_css 		= '';
$border_css 			   = '';
$fixed_border_css 	   = '';
$header_height_css 		= '';
$fixed_height_css 		= '';
$sitename_typo_css 		= '';


# 2. Background color

if ( StockieSettings::get( 'header_menu_style_settings' ) == 'custom' ) {
	$background_color = StockieSettings::get( 'header_menu_background_color' );
} else {
	if ( StockieSettings::page_is( 'ecommerce' ) ) {
		if ( StockieSettings::get( 'woocommerce_header_menu_style_settings', 'global' ) == 'custom' ) {
			$background_color = StockieSettings::get( 'woocommerce_header_menu_background_color', 'global' );
		} else {
			$background_color = StockieSettings::get( 'header_menu_background_color', 'global' );
		}
	} else {
		$background_color = StockieSettings::get( 'header_menu_background_color', 'global' );
	}
}
if ( $background_color ) {
	$background_color_css = 'background-color:' . $background_color . ';';
}

$fixed_background_color = StockieSettings::get( 'header_fixed_background_color', 'global' );
if ( $fixed_background_color ) {
	$fixed_background_color_css = 'background-color:' . $fixed_background_color . ';';
}

$mobile_header_menu_color = StockieSettings::get( 'mobile_header_menu_color', 'global' );
if ( $mobile_header_menu_color ) {
	$mobile_header_menu_color_css .= 'color:' . $mobile_header_menu_color . ';';
}

$mobile_background_color = StockieSettings::get( 'mobile_menu_background_color', 'global' );
if ( $mobile_background_color ) {
	$mobile_background_color_css = 'background-color:' . $mobile_background_color . ';';
}


# 3. Header menu typography
if ( StockieSettings::page_is( 'ecommerce' ) ) {
	if ( StockieSettings::get( 'woocommerce_header_menu_style_settings', 'global' ) == 'custom' ) {
		$header_typo = StockieSettings::get( 'woocommerce_header_menu_text_typo', 'global' );
	} else {
		$header_typo = StockieSettings::get( 'header_menu_text_typo', 'global' );
	}
} else {
	if ( StockieSettings::get( 'header_menu_style_settings' ) == 'custom' ) {
		$header_typo = StockieSettings::get( 'header_menu_text_typo' );
	} else {
		$header_typo = StockieSettings::get( 'header_menu_text_typo', 'global' );
	}
}

$header_typo_css = StockieHelper::parse_acf_typo_to_css( $header_typo );

$fixed_typo = StockieSettings::get( 'header_fixed_text_typo', 'global' );
$fixed_typo_css = StockieHelper::parse_acf_typo_to_css( $fixed_typo );

$mobile_typo = StockieSettings::get( 'mobile_menu_typo', 'global' );
$mobile_typo_css = StockieHelper::parse_acf_typo_to_css( $mobile_typo );

if ( $mobile_color ) {
	$mobile_color_css = 'color:' . $mobile_color . ';';
}

# 4. Border state

if ( StockieSettings::get( 'header_menu_style_settings' ) == 'custom' ) {
	$border_hide = StockieSettings::get( 'header_menu_hide_border' );
} else {
	if ( StockieSettings::page_is( 'ecommerce' ) ) {
		if ( StockieSettings::get( 'woocommerce_header_menu_style_settings', 'global' ) == 'custom' ) {
			$border_hide = StockieSettings::get( 'woocommerce_header_menu_hide_border', 'global' );
		} else {
			$border_hide = StockieSettings::get( 'header_menu_hide_border', 'global' );
			$border_hide = ( $border_hide ) ? 'yes' : 'no';
		}
	} else {
		$border_hide = StockieSettings::get( 'header_menu_hide_border', 'global' );
		$border_hide = ( $border_hide ) ? 'yes' : 'no';
	}
}

$border_hide = ( bool ) ( $border_hide == 'yes' );

$fixed_border_hide = ( bool ) ( StockieSettings::get( 'fixed_header_menu_hide_border', 'global' ) == 'yes' );

if ( $border_hide ) {
	$border_css .= 'border:none;';
}

if ( $fixed_border_hide ) {
	$fixed_border_css .= 'border:none;';
}

# 4.1. Border type

if ( ! $border_hide ) {
	if ( StockieSettings::get( 'header_menu_style_settings' ) == 'custom' ) {
		$border_type = StockieSettings::get( 'header_menu_border_type' );
	} else {
		if ( StockieSettings::page_is( 'ecommerce' ) ) {
			if ( StockieSettings::get( 'woocommerce_header_menu_style_settings', 'global' ) == 'custom' ) {
				$border_type = StockieSettings::get( 'woocommerce_header_menu_border_type', 'global' );
			} else {
				$border_type = StockieSettings::get( 'header_menu_border_type', 'global' );
			}
		} else {
			$border_type = StockieSettings::get( 'header_menu_border_type', 'global' );
		}
	}

	if ( $border_type ) {
		$border_css .= 'border-bottom-style:' . $border_type . ';';
	}
}

if ( ! $fixed_border_hide ) {
	$fixed_border_type = StockieSettings::get( 'fixed_header_menu_border_type', 'global' );

	if ( $fixed_border_type ) {
		$fixed_border_css .= 'border-bottom-style:' . $fixed_border_type . ';';
	}
}


# 4.2. Border color

if ( ! $border_hide ) {
	if ( StockieSettings::get( 'header_menu_style_settings' ) == 'custom' ) {
		$border_color = StockieSettings::get( 'header_menu_border_color' );
	} else {
		if ( StockieSettings::page_is( 'ecommerce' ) ) {
			if ( StockieSettings::get( 'woocommerce_header_menu_style_settings', 'global' ) == 'custom' ) {
				$border_color = StockieSettings::get( 'woocommerce_header_menu_border_color', 'global' );
			} else {
				$border_color = StockieSettings::get( 'header_menu_border_color', 'global' );
			}
		} else {
			$border_color = StockieSettings::get( 'header_menu_border_color', 'global' );
		}
	}

	if ( $border_color ) {
		$border_css .= 'border-bottom-color:' . $border_color . ';';
	}
}

if ( ! $fixed_border_hide ) {
	$fixed_border_color = StockieSettings::get( 'fixed_header_menu_border_color', 'global' );

	if ( $fixed_border_color ) {
		$fixed_border_css .= 'border-bottom-color:' . $fixed_border_color . ';';
	}
}


# 5. Header height
if ( StockieSettings::get( 'header_menu_style_settings' ) == 'custom' ) {
	$header_height = StockieSettings::get( 'header_menu_height' );
} else {
	if ( StockieSettings::page_is( 'ecommerce' ) ) {
		if ( StockieSettings::get( 'woocommerce_header_menu_style_settings', 'global' ) == 'custom' ) {
			$header_height = StockieSettings::get( 'woocommerce_header_menu_height', 'global' );
		} else {
			$header_height = StockieSettings::get( 'header_menu_height', 'global' );
		}
	} else {
		$header_height = StockieSettings::get( 'header_menu_height', 'global' );
	}
}


if ( $header_height ) {

	$header_height_css .= 'height:${height}px;';

	$header_height_css = StockieHelper::parse_responsive_height_to_css( $header_height, $header_height_css );
}


$fixed_height = StockieSettings::get( 'header_fixed_height', 'global' );

if ( $fixed_height ) {

	$fixed_height_css .= 'height:${height}px;';

	$fixed_height_css = StockieHelper::parse_responsive_height_to_css( $fixed_height, $fixed_height_css );
}



# 6. Site name typography

if ( StockieSettings::get( 'header_logo_style' ) == 'sitename' ) {
	$sitename_typo = StockieSettings::get( 'header_menu_sitename_typo' );
} elseif ( in_array( StockieSettings::get( 'header_logo_style' ), array( 'inherit', NULL ) ) ) {
	if ( StockieSettings::page_is( 'ecommerce' ) ) {
		if ( StockieSettings::get( 'woocommerce_header_logo_style', 'global' ) == 'sitename' ) {
			$sitename_typo = StockieSettings::get( 'woocommerce_header_sitename_typo', 'global' );
		} elseif ( in_array( StockieSettings::get( 'woocommerce_header_logo_style', 'global' ), array( 'inherit', NULL ) ) ) {
			if ( StockieSettings::get( 'logo_type', 'global' ) == 'sitename' ) {
				$sitename_typo = StockieSettings::get( 'header_menu_logo_typo', 'global' );
			}
		}
	} else {
		if ( StockieSettings::get( 'logo_type', 'global' ) == 'sitename' ) {
			$sitename_typo = StockieSettings::get( 'header_menu_logo_typo', 'global' );
		}
	}
}

$sitename_typo_css = StockieHelper::parse_acf_typo_to_css( $sitename_typo );


# 7. View
if ( $background_color_css || $header_typo_css ) {
	// --- start of CSS ---
	$_style_block = '.site-header:not(.header-fixed):not(.mobile-header) .menu > li > a, .site-header:not(.header-fixed) .menu-other .cart-total a, .site-header:not(.header-fixed) .menu-other li > a, .site-header:not(.header-fixed) .select-styled, .site-header:not(.header-fixed) .hamburger-menu .hamburger  {';
	$_style_block .= $header_typo_css;
	$_style_block .= '}';

	// background
	$_style_block .= '#masthead.site-header{';
	$_style_block .= $background_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $fixed_typo_css ) {
	// --- start of CSS ---
	$_style_block = '.header-fixed .menu  li > a, .header-fixed .menu-other .cart-total a, .header-fixed .menu-other  li > a, .hamburger-menu .hamburger {';
	$_style_block .= $fixed_typo_css;
	$_style_block .= '}';
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $mobile_color_css ) {
	// --- start of CSS ---
	$_style_block = 'header#masthead{';
	$_style_block .= $mobile_color_css;
	$_style_block .= '}';
	StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'mobile' );
}

if ( $fixed_background_color_css ) {
	// background
	$_style_block = '#masthead.site-header.header-fixed{';
	$_style_block .= $fixed_background_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $mobile_header_menu_color_css ) {
	// background
	$_style_block = '.site-header:not(.header-fixed) .menu li > a, .site-header:not(.header-fixed) .menu-other .cart-total a, .site-header:not(.header-fixed) .menu-other > li > a, .site-header:not(.header-fixed) .select-styled, .site-header:not(.header-fixed) .hamburger-menu .hamburger {';
	$_style_block .= $mobile_header_menu_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'mobile' );
}

if ( $mobile_typo_css ) {
	// --- start of CSS ---
	$_style_block = '.site-header .menu > li > a.menu-link, .main-nav .nav-item a, .main-nav .copyright, .main-nav .copyright a {';
	$_style_block .= $mobile_typo_css;
	$_style_block .= '}';
	StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'mobile' );
}

if ( $mobile_background_color_css ) {
	// background
	$_style_block = '.main-nav .mbl-overlay-container, .main-nav .close-bar{';
	$_style_block .= $mobile_background_color_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'mobile' );
}

if ( $border_css ) {
	// --- start of CSS ---
	$_style_block = '.site-header{';
	$_style_block .= $border_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}

if ( $fixed_border_css ) {
	// --- start of CSS ---
	$_style_block = '.site-header.header-fixed{';
	$_style_block .= $fixed_border_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}


if ( $header_height_css ) {
	$header_height_classes = '.site-header .header-wrap, .header-cap';

	if ( $header_height_css['desktop'] ) {
		$_style_block = $header_height_classes . '{' . $header_height_css['desktop'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'desktop' );
	}
	if ( $header_height_css['tablet'] ) {
		$_style_block = $header_height_classes . '{' . $header_height_css['tablet'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'tablet' );
	}
	if ( $header_height_css['mobile'] ) {
		$_style_block = $header_height_classes . '{' . $header_height_css['mobile'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'mobile' );
	}
}

if ( $fixed_height_css ) {
	$fixed_height_classes = '.site-header.header-fixed .header-wrap';

	if ( $fixed_height_css['desktop'] ) {
		$_style_block = $fixed_height_classes . '{' . $fixed_height_css['desktop'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'desktop' );
	}
	if ( $fixed_height_css['tablet'] ) {
		$_style_block = $fixed_height_classes . '{' . $fixed_height_css['tablet'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'tablet' );
	}
	if ( $fixed_height_css['mobile'] ) {
		$_style_block = $fixed_height_classes . '{' . $fixed_height_css['mobile'] . '}';
		StockieLayout::append_to_dynamic_css_buffer( $_style_block, 'mobile' );
	}
}

if ( $sitename_typo_css ) {
	// --- start of CSS ---
	$_style_block = '#masthead.site-header .site-title a,.fullscreen-nav .site-title,.fullscreen-nav .site-title a{';
	$_style_block .= $sitename_typo_css;
	$_style_block .= '}';
	// --- end of CSS ---
	StockieLayout::append_to_dynamic_css_buffer( $_style_block );
}