<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php echo esc_attr( get_bloginfo( 'charset' ) ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php get_template_part( 'parts/elements/preloader' ); ?>
	<?php get_template_part( 'parts/elements/scroll-top' ); ?>
	<?php get_template_part( 'parts/elements/share-bar' ); ?>

	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#main"><?php esc_html_e( 'Skip to content', 'stockie' ); ?></a>

		<?php if ( StockieSettings::page_is_boxed() ) : ?>
		<div class="boxed-container">
		<?php endif; ?>

		<?php get_template_part( 'parts/headers/subheader' ); ?>

		<?php
			$header_menu_style = StockieSettings::header_menu_style();
			$show_header = ! StockieSettings::page_is( 'for_builder' );
			$append_header_cap = StockieSettings::header_cap_is_displayed();
			$append_subheader = StockieSettings::subheader_is_displayed();
			$show_search = ! StockieSettings::get( 'header_hide_search', 'global' );
			$header_cap_class = '';

			if ( $header_menu_style == 'style3' ) {
				$header_cap_class .= ' header-3';
			}
			if ( $append_subheader ) {
				$header_cap_class .= ' subheader_included';
			}

			if ( $show_header ) {
				switch ( $header_menu_style ) {
					case 'style1' :
						get_template_part( 'parts/headers/header', 'style-1' );
						break;
					case 'style3' :
						get_template_part( 'parts/headers/header', 'style-3' );
						break;
					case 'style4' :
						get_template_part( 'parts/headers/header', 'style-4' );
						break;
					case 'style5' :
						get_template_part( 'parts/headers/header', 'style-5' );
						break;
					case 'style6' :
						get_template_part( 'parts/headers/header', 'style-6' );
						break;
					case 'style7' :
						get_template_part( 'parts/headers/header', 'style-7' );
						break;
					default :
						get_template_part( 'parts/headers/header', 'style-1' );
						break;
				}
			}
		?>

		<?php if ( $show_search ) : ?>
		<div class="header-search">
			<div class="close close-bar">
				<div class="close-bar-btn btn-round round-animation" tabindex="0">
					<i class="ion ion-android-close"></i>
				</div>
			</div>
            <div class="search-wrap">
            <?php
            if (function_exists('get_product_search_form')) {
                get_product_search_form( true );
            } else {
                get_search_form();
            } ?>
            </div>
		</div>
		<?php endif; ?>

		<?php if ( $header_menu_style == 'style6' ) : ?>
		<div class="content-right">
		<?php endif; ?>

		<div id="content" class="site-content">
			<?php if ( $append_header_cap && $show_header ) : ?>
			<div class="header-cap<?php echo esc_attr( $header_cap_class ); ?>"></div>
			<?php endif; ?>