<?php
	get_header();

	// Settings
	$show_breadcrumbs = StockieSettings::breadcrumbs_is_displayed();
	$published_posts = $GLOBALS['wp_query']->found_posts;
	$pagination_page = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	$posts_per_page = $posts_per_page = StockieSettings::posts_per_page();
	$posts_offset = ( $pagination_page - 1 ) * $posts_per_page;
	$paginator_all = ceil( $published_posts / (int) $posts_per_page );

	$pagination_type = StockieSettings::get( 'blog_pagination_type', 'global' );
	if ( $pagination_type == NULL ){
		$pagination_type = 'simple';
	}

	$posts_show_from = $posts_offset + 1;
	$posts_show_to = $posts_offset + $posts_per_page;
	if ( $posts_show_to > $published_posts ) {
		$posts_show_to = $published_posts;
	}

	$sidebar_position = StockieSettings::get_archive_sidebar_position();
	$sidebar_page_class = '';
	if ( is_active_sidebar( 'stockie-sidebar-blog' ) ) {
		if ( $sidebar_position == 'left' ) {
			$sidebar_page_class = ' with-left-sidebar';
		} elseif ( $sidebar_position == 'right' ) {
			$sidebar_page_class = ' with-right-sidebar';
		}
	}
	$sidebar_layout = StockieSettings::page_sidebar_layout();
	$sidebar_class = '';
	if ( $sidebar_layout ) {
		$sidebar_class .= ' sidebar-' . $sidebar_layout;
	}

	$posts_grid = StockieSettings::get( 'blog_page_layout', 'global' );
	if ( ! $posts_grid ) { $posts_grid = 'masonry'; }
	$grid_style_class = ( $posts_grid == 'masonry' ) ? 'stockie-masonry blog-posts-masonry' : 'blog-posts-classic';

	$posts_layout_item = StockieSettings::get( 'blog_item_layout_type', 'global' );

	// Columns
	$columns_num = StockieSettings::get( 'blog_columns_in_row', 'global' );
	if ( $posts_grid == 'classic' ) { 
		$columns_num = '3-2-1-1'; 
	}
	if ( ! isset( $columns_num ) ) {
		$columns_num = '3-2-1-1';
	}
	$columns_class = StockieHelper::parse_columns_to_css( $columns_num, false );
	$columns_double_class = StockieHelper::parse_columns_to_css( $columns_num, true );


	$grid_item_style_class = '';
	$posts_without_paddings = StockieSettings::get( 'blog_items_without_padding' );
	if ( in_array( $posts_without_paddings, array( 'inherit', NULL ) ) ) {
		$posts_without_paddings = StockieSettings::get( 'blog_items_without_padding', 'global' );
	} else {
		$posts_without_paddings = ( $posts_without_paddings == 'yes' ) ? true : false;
	}
	if ( $posts_without_paddings ) {
		$grid_item_style_class .= ' post-offset';
	}
	
	$page_wrapped = StockieSettings::page_is_wrapped();

	$page_container_class = '';
	if ( !$show_breadcrumbs ) { 
		$page_container_class .= ' without-breadcrumbs'; 
	}
	if ( !$page_wrapped ) { 
		$page_container_class .= ' full'; 
	}

?>

<?php get_template_part( 'parts/elements/header-title' ); ?>

<?php get_template_part( 'parts/elements/breadcrumbs' ); ?>

<?php if ( have_posts() ) : ?>

<div class="page-container bottom-offset<?php echo esc_attr( $page_container_class ); ?>">
	<div id="primary" class="content-area">

		<?php if ( is_active_sidebar( 'stockie-sidebar-blog' ) && $sidebar_position == 'left' ) : ?>
		<div class="page-sidebar sidebar-left<?php echo esc_attr( $sidebar_class ); ?>">
			<aside id="secondary" class="widget-area">
				<?php dynamic_sidebar( 'stockie-sidebar-blog' ); ?>
			</aside>
		</div>
		<?php endif; ?>

		<div class="page-content<?php echo esc_attr( $sidebar_page_class ); ?>">
			<main id="main" class="site-main">
				<div class="vc_row <?php echo esc_attr( $grid_style_class ); ?>" data-lazy-container="posts">
					<?php
						$_post_i = 0;
						/* Start the Loop */
						while ( have_posts() ) : the_post();
							
							$parsed_post = StockieObjectParser::parse_to_post_object( $post, 'index', $_post_i + 1 );
							StockieHelper::set_storage_item_data( $parsed_post );

							$col_class = $columns_class;
							$grid_class = ' grid-item';

							if ( $parsed_post['grid_style'] == '2col' ) {
								$col_class = $columns_double_class;
								$grid_class = '';
							}

							// Animation calculating
							$_anim_attrs = '';
							if ( in_array( $parsed_post['animation_type'], array( 'sync', 'async' ) ) ) {
								$_anim_attrs .= ' data-aos-once="true"';
								$_anim_attrs .= ' data-aos="' . esc_attr( $parsed_post['animation_effect'] ) . '"';
								if ( $parsed_post['animation_type'] == 'async' ) {
									$columns_num = (int) substr( $columns_num, 0, 1);
									$_delay = ( 400 / $columns_num ) * ( $_post_i % $columns_num );
									$_delay = (int) $_delay - ( $_delay % 50 );
									$_anim_attrs .= ' data-aos-delay="' . esc_attr( $_delay ) . '"';
								}
							}

							echo '<div class="' . esc_attr( $col_class . $grid_class . $grid_item_style_class . ( ( $posts_grid == 'masonry' ) ? ' masonry-block blog-post-masonry' : '' ) ) . '"' . esc_attr( $_anim_attrs ) . ' data-lazy-item="" data-lazy-scope="posts">';

							switch ( $posts_layout_item ) {
								case 'simple':
									get_template_part( 'parts/blog-cards/simple' );
									break;
								case 'overlay':
									get_template_part( 'parts/blog-cards/overlay' );
									break;
								case 'classic':
								default:
									get_template_part( 'parts/blog-cards/classic' );
									break;
							}
							echo '</div>';

							$_post_i++;
						endwhile;
					?>
				</div>
	
				<?php
					if ( $paginator_all > 1 ) {
						$large_number = 10000000;
						$paginator_pattern = str_replace( $large_number, '{{page}}', get_pagenum_link( $large_number ) );

						switch ( $pagination_type ) {
							case 'simple':
								StockieLayout::the_paginator_layout( $pagination_page, $paginator_all );
								break;
						 	case 'lazy_scroll':
								echo '<div class="lazy-load loading font-titles" data-lazy-load="scroll" data-lazy-pages-count="' . esc_attr( $paginator_all ) . '" data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" data-lazy-load-scope="posts">';
								echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie' ) . '</span>';
								echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
								echo '</div>';
								break;
							case 'lazy_button':
								echo '<div class="lazy-load load-more font-titles" data-lazy-load="click" data-lazy-pages-count="' . esc_attr( $paginator_all ) . '" data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" data-lazy-load-scope="posts">';
								echo '<span class="loadmore-text">' . esc_html__( 'Load More', 'stockie' ) . '</span>';
								echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie' ) . '</span>';
								echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
								echo '</div>';
								break;
						}
					}
				?>
			</main>
		</div>

		<?php if ( is_active_sidebar( 'stockie-sidebar-blog' ) && $sidebar_position == 'right' ) : ?>
		<div class="page-sidebar sidebar-right<?php echo esc_attr( $sidebar_class ); ?>">
			<aside id="secondary" class="widget-area">
				<?php dynamic_sidebar( 'stockie-sidebar-blog' ); ?>
			</aside>
		</div>
		<?php endif; ?>
	</div>

	<?php else : ?>

	<?php get_template_part( 'parts/content', 'none' ); ?>

	<?php endif; ?>
	
</div>

<?php get_footer();