!function($) {

	function stockieColorpickerSerialize($block, $hidden_input) {
		var serialize_string = '';

		var color = $block.find('input[name="colorpicker"]').val();
		var brandColor = $block.find('input[name="brand-color"]')[0].checked;
	
		if( color || brandColor ) {
			serialize_string += ( brandColor ) ? 'brand' : color;
		}

		$hidden_input.val( serialize_string );
	}

	function stockieHideFields(){
		$('.stockie_extra_colorpicker_block input[name="brand-color"]').each(function(){
			var parent = $(this).closest('.stockie_extra_colorpicker_block');
			var color = parent.find('.color');
			
			if( $(this).length && this.checked ){
				color.addClass('disabled');
			} else {
				color.removeClass('disabled');
			}
		});
	}

	vc.atts.colorpicker.init( {}, '.stockie_extra_colorpicker_block' );

	$('#vc_ui-panel-edit-element').on(
		'change', 
		'.stockie_extra_colorpicker_block input, .stockie_extra_colorpicker_block select',
		function(e){
			var $closest = $(this).closest('.stockie_extra_colorpicker_block');
			var $value_hidden_input = $closest.find('.wpb_vc_param_value');
			stockieColorpickerSerialize( $closest, $value_hidden_input );
			stockieHideFields();
		}
	);

	$('.stockie_extra_colorpicker_block .wp-picker-clear').on('click', function(e){
		var $closest = $(this).closest('.stockie_extra_colorpicker_block');
		var $value_hidden_input = $closest.find('.wpb_vc_param_value');
		stockieColorpickerSerialize( $closest, $value_hidden_input );
		stockieHideFields();
	});


	stockieHideFields();

}(window.jQuery);