<?php

/**
* WPBakery Page Builder Stockie Video shortcode params
*/

vc_map( array(
	'name' => __( 'Video', 'stockie-extra' ),
	'description' => __( 'Popup video module', 'stockie-extra' ),
	'base' => 'stockie_video',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Video layout', 'stockie-extra' ),
			'param_name' => 'layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_076.svg',
					'key' => 'boxed_shape',
					'title' => __( 'Default', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_075.svg',
					'key' => 'with_preview',
					'title' => __( 'With Preview', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Video button layout', 'stockie-extra' ),
			'param_name' => 'button_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_073.svg',
					'key' => 'filled',
					'title' => __( 'Filled', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_074.svg',
					'key' => 'outline',
					'title' => __( 'Outline', 'stockie-extra' ),
				),
			),
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Preview image', 'stockie-extra' ),
			'param_name' => 'preview_image',
			'dependency' => array(
				'element' => 'layout',
				'value' => array(
					'with_preview'
				)
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Alignment', 'stockie-extra' ),
			'param_name' => 'alignment',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right'
			),
			'std' => 'center',
			'dependency' => array(
				'element' => 'layout',
				'value' => array(
					'boxed_shape',
					'outline'
				)
			),
		),
		array(
			'type' => 'textarea_raw_html',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Video title', 'stockie-extra' ),
			'param_name' => 'title',
			'value' => '',
			'description' => __( 'HTML allowed.', 'stockie-extra' )
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Video URL', 'stockie-extra' ),
			'param_name' => 'link',
			'value' => '',
			'description' => 'E.g. https://www.youtube.com/watch?v=YbJOTdZBX1g'
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'layout',
				'value' => array(
					'boxed_shape',
					'outline'
				)
			)
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
			'dependency' => array(
				'element' => 'layout',
				'value' => array(
					'boxed_shape',
					'outline'
				)
			)
		),
		
		// Style
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_button',
			'value' => __( 'Button', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Use "Call to action" animation?', 'stockie-extra' ),
			'param_name' => 'button_anim',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Button color', 'stockie-extra' ),
			'param_name' => 'button_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Button color on hover', 'stockie-extra' ),
			'param_name' => 'button_hover_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icon color', 'stockie-extra' ),
			'param_name' => 'icon_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icon color on hover', 'stockie-extra' ),
			'param_name' => 'icon_hover_color'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_typo',
			'value' => __( 'Typography', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Border color', 'stockie-extra' ),
			'param_name' => 'border_color',
			'dependency' => array(
				'element' => 'layout',
				'value' => array(
					'outline'
				)
			)
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );