<?php

/**
* WPBakery Page Builder Stockie Vertical Fullscreen Slider shortcode params
*/

vc_map( array(
	'name' => __( 'Vertical Slider', 'stockie-extra' ),
	'description' => __( 'Paged split view', 'stockie-extra' ),
	'base' => 'stockie_vertical_slider',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'holder' => '',
	'js_view' => 'VcStockieVerticalSliderView',
	'show_settings_on_create' => true,
	'content_element' => true,
	'is_container' => true,
	'as_parent' => array(
		'only' => 'stockie_vertical_slider_inner'
	),
	'default_content' => '[stockie_vertical_slider_inner][/stockie_vertical_slider_inner]',
	'params' => array(
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Show navigation buttons?', 'stockie-extra' ),
			'param_name' => 'navigation_show',
			'description' => __( 'Show navigation buttons on page' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Show slides pagination?', 'stockie-extra' ),
			'param_name' => 'pagination_show',
			'description' => __( 'Show pagination dots/numbers on page' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Pagination buttons type', 'stockie-extra' ),
			'param_name' => 'pagination_type',
			'value' => array(
				__( 'Bullets', 'stockie-extra' ) => 'bullets',
				__( 'Numbers', 'stockie-extra' ) => 'numbers'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Scroll animation duration', 'stockie-extra' ),
			'param_name' => 'animation_duration',
			'value' => array(
				__( 'Default', 'stockie-extra' ) => 'default',
				__( 'Fast', 'stockie-extra' ) => 'fast',
				__( 'Slow', 'stockie-extra' ) => 'slow'
			),
		),
		
		// Styles
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Pagination color', 'stockie-extra' ),
			'param_name' => 'elements_color'
		),

		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),
	)
) );

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Stockie_Vertical_Slider extends WPBakeryShortCodesContainer { }
}