<?php

/**
* WPBakery Page Builder Stockie Team Members Group shortcode params
*/

vc_map( array(
	'name' => __( 'Team Group', 'stockie-extra' ), 
	'description' => __( 'Team members group module', 'stockie-extra' ), 
	'base' => 'stockie_team_members_group',
	'category' => __( 'Stockie', 'stockie-extra' ), 
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'js_view' => 'VcStockieGroupColumnView',
	'show_settings_on_create' => false,
	'as_parent' => array(
		'only' => 'stockie_team_member_inner',
	),
	'default_content' => '[stockie_team_member_inner][/stockie_team_member_inner][stockie_team_member_inner][/stockie_team_member_inner][stockie_team_member_inner][/stockie_team_member_inner]',
	'params' => array(
		// Style
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'argenta_extra' ),
			'heading' => __( 'Content block background', 'argenta_extra' ),
			'param_name' => 'content_bg',
		),
		
		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Stockie_Team_Members_Group extends WPBakeryShortCodesContainer { }
}