<?php

/**
* WPBakery Page Builder Stockie Team Member shortcode params
*/

vc_map( array(
		'name' => __( 'Team Member', 'stockie-extra' ),
		'description' => __( 'Team member block', 'stockie-extra' ),
		'base' => 'stockie_team_member',
		'category' => __( 'Stockie', 'stockie-extra' ),
		'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
		'js_view' => 'VcStockieTeamMemberView',
		'custom_markup' => '{{title}}<div class="vc_stockie_team_member-container">
				<div class="_contain">
					<div class="photo" style="background-image: url(\'' . plugin_dir_url( __FILE__ ) . 'images/sc_gap_user.svg\');"></div>
					<div class="name">%%name%%</div>
					<div class="position"></div>
				</div>
				<div class="lines"><div class="line"></div><div class="line"></div></div>
			</div>',
		'params' => array(
			// General
			array(
				'type' => 'stockie_choose_box',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Team member layout', 'stockie-extra' ),
				'param_name' => 'block_type_layout',
				'value' => array(
					array(
						'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_062.svg',
						'key' => 'full',
						'title' => __( 'Card details', 'stockie-extra' ),
					),
					array(
						'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_063.svg',
						'key' => 'inner',
						'title' => __( 'Inner details', 'stockie-extra' ),
					)
				)
			),
			array(
				'type' => 'attach_image',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Team member photo', 'stockie-extra' ),
				'param_name' => 'photo',
				'description' => __( 'Choose member photo.', 'stockie-extra' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'em',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Name', 'stockie-extra' ),
				'param_name' => 'name',
				'description' => __( 'Team member name.', 'stockie-extra' ),
			),
			array(
				'type' => 'textfield',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Position', 'stockie-extra' ),
				'param_name' => 'position',
				'description' => __( 'For example, <em>Product manager</em>.', 'stockie-extra' ),
			),
			array(
				'type' => 'textarea',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Description', 'stockie-extra' ),
				'param_name' => 'description',
				'description' => __( 'Tell what this remarkable team member in your team.', 'stockie-extra' ),
			),

			// Social links
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-artstation"></i> ' . __( 'ArtStation', 'stockie-extra' ),
				'param_name' => 'artstation_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-behance"></i> ' . __( 'Behance', 'stockie-extra' ),
				'param_name' => 'behance_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-deviantart"></i> ' . __( 'DeviantArt', 'stockie-extra' ),
				'param_name' => 'deviantart_link',
			),
	        array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-digg"></i> ' . __( 'Digg', 'stockie-extra' ),
				'param_name' => 'digg_link',
			),
	        array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-discord"></i> ' . __( 'Discord', 'stockie-extra' ),
				'param_name' => 'discord_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-dribbble"></i> ' . __( 'Dribbble', 'stockie-extra' ),
				'param_name' => 'dribbble_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-facebook-f"></i> ' . __( 'Facebook', 'stockie-extra' ),
				'param_name' => 'facebook_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-flickr"></i> ' . __( 'Flickr', 'stockie-extra' ),
				'param_name' => 'flickr_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-github"></i> ' . __( 'GitHub', 'stockie-extra' ),
				'param_name' => 'github_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-houzz"></i> ' . __( 'Houzz', 'stockie-extra' ),
				'param_name' => 'houzz_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-instagram"></i> ' . __( 'Instagram', 'stockie-extra' ),
				'param_name' => 'instagram_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-kaggle"></i> ' . __( 'Kaggle', 'stockie-extra' ),
				'param_name' => 'kaggle_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-linkedin"></i> ' . __( 'LinkedIn', 'stockie-extra' ),
				'param_name' => 'linkedin_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-medium-m"></i> ' . __( 'Medium', 'stockie-extra' ),
				'param_name' => 'medium_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-mixer"></i> ' . __( 'Mixer', 'stockie-extra' ),
				'param_name' => 'mixer_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-pinterest"></i> ' . __( 'Pinterest', 'stockie-extra' ),
				'param_name' => 'pinterest_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-product-hunt"></i> ' . __( 'Product Hunt', 'stockie-extra' ),
				'param_name' => 'producthunt_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-quora"></i> ' . __( 'Quora', 'stockie-extra' ),
				'param_name' => 'quora_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-reddit"></i> ' . __( 'Reddit', 'stockie-extra' ),
				'param_name' => 'reddit_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-snapchat"></i> ' . __( 'Snapchat', 'stockie-extra' ),
				'param_name' => 'snapchat_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-soundcloud"></i> ' . __( 'SoundCloud', 'stockie-extra' ),
				'param_name' => 'soundcloud_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-spotify"></i> ' . __( 'Spotify', 'stockie-extra' ),
				'param_name' => 'spotify_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-teamspeak"></i> ' . __( 'TeamSpeak', 'stockie-extra' ),
				'param_name' => 'teamspeak_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-telegram"></i> ' . __( 'Telegram', 'stockie-extra' ),
				'param_name' => 'telegram_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-threads"></i> ' . __( 'Threads', 'stockie-extra' ),
				'param_name' => 'threads_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-tiktok"></i> ' . __( 'TikTok', 'stockie-extra' ),
				'param_name' => 'tiktok_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-tumblr"></i> ' . __( 'Tumblr', 'stockie-extra' ),
				'param_name' => 'tumblr_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-twitch"></i> ' . __( 'Twitch', 'stockie-extra' ),
				'param_name' => 'twitch_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-x-twitter"></i> ' . __( 'Twitter', 'stockie-extra' ),
				'param_name' => 'twitter_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-vimeo"></i> ' . __( 'Vimeo', 'stockie-extra' ),
				'param_name' => 'vimeo_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-vine"></i> ' . __( 'Vine', 'stockie-extra' ),
				'param_name' => 'vine_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-whatsapp"></i> ' . __( 'Whatsapp', 'stockie-extra' ),
				'param_name' => 'whatsapp_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-xing"></i> ' . __( 'Xing', 'stockie-extra' ),
				'param_name' => 'xing_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-youtube"></i> ' . __( 'YouTube', 'stockie-extra' ),
				'param_name' => 'youtube_link',
			),
			array(
				'type' => 'textfield',
				'group' => __( 'Social links', 'stockie-extra' ),
				'heading' => '<i class="fa-brands fa-500px"></i> ' . __( '500px', 'stockie-extra' ),
				'param_name' => 'fivehundred_link',
			),

			// Typography
			array(
				'type' => 'stockie_divider',
				'group' => __( 'Typography', 'stockie-extra' ),
				'param_name' => 'typo_tab_divider_name',
				'value' => __( 'Name', 'stockie-extra' ),
			),
			array(
				'type' => 'stockie_typography',
				'group' => __( 'Typography', 'stockie-extra' ),
				'param_name' => 'name_typo',
			),
			array(
				'type' => 'stockie_divider',
				'group' => __( 'Typography', 'stockie-extra' ),
				'param_name' => 'typo_tab_divider_position',
				'value' => __( 'Position', 'stockie-extra' ),
			),
			array(
				'type' => 'stockie_typography',
				'group' => __( 'Typography', 'stockie-extra' ),
				'param_name' => 'position_typo',
			),
			array(
				'type' => 'stockie_divider',
				'group' => __( 'Typography', 'stockie-extra' ),
				'param_name' => 'typo_tab_divider_description',
				'value' => __( 'Description', 'stockie-extra' ),
			),
			array(
				'type' => 'stockie_typography',
				'group' => __( 'Typography', 'stockie-extra' ),
				'param_name' => 'desription_typo',
			),

			// Color settings
			array(
				'type' => 'stockie_divider',
				'group' => __( 'Styles', 'stockie-extra' ),
				'param_name' => 'color_settings_title',
				'value' => __( 'Color settings', 'stockie-extra' ),
			),
			array(
				'type' => 'stockie_colorpicker',
				'group' => __( 'Styles', 'stockie-extra' ),
				'heading' => __( 'Overlay color', 'stockie-extra' ),
				'param_name' => 'overlay_color',
			),
			array(
				'type' => 'stockie_colorpicker',
				'group' => __( 'Styles', 'stockie-extra' ),
				'heading' => __( 'Name color', 'stockie-extra' ),
				'param_name' => 'name_color',
			),
			array(
				'type' => 'stockie_colorpicker',
				'group' => __( 'Styles', 'stockie-extra' ),
				'heading' => __( 'Position text color', 'stockie-extra' ),
				'param_name' => 'position_color',
			),
			array(
				'type' => 'stockie_colorpicker',
				'group' => __( 'Styles', 'stockie-extra' ),
				'heading' => __( 'Description color', 'stockie-extra' ),
				'param_name' => 'description_color',
			),
			array(
				'type' => 'stockie_colorpicker',
				'group' => __( 'Styles', 'stockie-extra' ),
				'heading' => __( 'Social buttons color', 'stockie-extra' ),
				'param_name' => 'social_color',
			),
			array(
				'type' => 'stockie_colorpicker',
				'group' => __( 'Styles', 'stockie-extra' ),
				'heading' => __( 'Social buttons hover color', 'stockie-extra' ),
				'param_name' => 'social_hover_color',
			),
			array(
				'type' => 'stockie_divider',
				'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_other',
			'value' => __( 'Other', 'stockie-extra' ),
		),
			
		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );