<?php

/**
* WPBakery Page Builder Stockie Split Screens shortcode params
*/

vc_map( array(
	'name' => __( 'Split Slider', 'stockie-extra' ),
	'description' => __( 'Split view in slides', 'stockie-extra' ),
	'base' => 'stockie_split_screens',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'holder' => '',
	'js_view' => 'VcStockieSplitScreensView',
	'show_settings_on_create' => false,
	'content_element' => true,
	'is_container' => true,
	'as_parent' => array(
		'only' => 'stockie_split_screen'
	),
	'default_content' => '[stockie_split_screen][/stockie_split_screen]',
	'params' => array(
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Scroll animation duration', 'stockie-extra' ),
			'param_name' => 'animation_duration',
			'value' => array(
				__( 'Default', 'stockie-extra' ) => 'default',
				__( 'Fast', 'stockie-extra' ) => 'fast',
				__( 'Slow', 'stockie-extra' ) => 'slow'
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Show navigation buttons?', 'stockie-extra' ),
			'param_name' => 'navigation_buttons',
			'description' => __( 'Show navigation dots on page' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Navigation buttons type', 'stockie-extra' ),
			'param_name' => 'navigation_type',
			'value' => array(
				__( 'Bullets', 'stockie-extra' ) => 'bullets',
				__( 'Numbers', 'stockie-extra' ) => 'numbers'
			),
			'dependency' => array(
				'element' => 'navigation_buttons',
				'value' => array(
					'1',
					true
				)
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Use full-height layout', 'stockie-extra' ),
			'param_name' => 'full_vh',
			'description' => __( 'Use this option, if you want to stretch the slider for the whole screen.', 'stockie-extra' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),

		// Styles
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Navigation buttons color', 'stockie-extra' ),
			'param_name' => 'navigation_color',
			'dependency' => array(
				'element' => 'navigation_buttons',
				'value' => array(
					'1',
					true
				)
			)
		),

		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),
	)
) );

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Stockie_Split_Screens extends WPBakeryShortCodesContainer { }
}