<?php

/**
* WPBakery Page Builder Stockie Recent Portfolio Projects shortcode
*/

add_shortcode( 'stockie_recent_projects', 'stockie_recent_projects_func' );

function stockie_recent_projects_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$projects_solid = isset( $projects_solid ) ? StockieExtraFilter::boolean( $projects_solid ) : false;
	$projects_category = isset( $projects_category ) ? StockieExtraFilter::string( $projects_category, 'attr', 'all' ) : 'all';

	$show_projects_filter = isset( $show_projects_filter ) ? StockieExtraFilter::boolean( $show_projects_filter ) : true;
	$filter_align = isset( $filter_align ) ? StockieExtraFilter::string( $filter_align, 'attr', 'center' ) : 'center';

	$columns_in_row = isset( $columns_in_row ) ? StockieExtraFilter::string( $columns_in_row, 'attr', '4-3-2-1' ) : '4-3-2-1';

	$card_layout = isset( $card_layout ) ? StockieExtraFilter::string( $card_layout, 'string', 'grid_1' ) : 'grid_1';
	switch ($card_layout){
        case 'grid_1':
            $portfolio_grid_hover = isset( $portfolio_grid_1_hover ) ? StockieExtraFilter::string( $portfolio_grid_1_hover, 'string', 'hover_1' ) : 'hover_1';

            break;
        case 'grid_2':
            $portfolio_grid_hover = isset( $portfolio_grid_2_hover ) ? StockieExtraFilter::string( $portfolio_grid_2_hover, 'string', 'hover_1' ) : 'hover_1';
            break;
    }

    $card_layout .= '_' . $portfolio_grid_hover;


	$metro_style = isset( $metro_style ) ? StockieExtraFilter::boolean( $metro_style ) : false;
	$grid_items_gap = isset( $grid_items_gap ) ? StockieExtraFilter::string( $grid_items_gap, 'string', '15px' ) : '15px';

	$use_pagination = isset( $use_pagination ) ? StockieExtraFilter::boolean( $use_pagination ) : false;

	if ($use_pagination) {
		$projects_in_block = isset( $projects_in_block_pagination ) ? StockieExtraFilter::string( $projects_in_block_pagination, 'attr', 4 ) : 4;
	} else {
		$projects_in_block = isset( $projects_in_block ) ? StockieExtraFilter::string( $projects_in_block, 'attr', 4 ) : 4;
	}

	$pagination_type = isset( $pagination_type ) ? StockieExtraFilter::string( $pagination_type, 'attr', 'simple' ) : 'simple';
    $pagination_position = isset( $pagination_position ) ? StockieExtraFilter::string( $pagination_position, 'attr', 'left' ) : 'left';

	$pagination_items_per_page = isset( $pagination_items_per_page ) ? StockieExtraFilter::string( $pagination_items_per_page, 'string', '6' ) : '6';

	$animation_type = isset( $animation_type ) ? StockieExtraFilter::string( $animation_type, 'string', 'default' ) : 'default';
	$animation_effect = isset( $animation_effect ) ? StockieExtraFilter::string( $animation_effect, 'string', 'fade-up' ) : 'fade-up';

	if ( $projects_category != 'all' ) {
		$_projects_category = $projects_category;
		$projects_category = array();
		foreach ( explode( ',', $_projects_category) as $category) {
			$projects_category[] = intval( trim( $category ) );
		}
	}

	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' ) : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false ) : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	$item_desktop = isset( $item_desktop ) ? StockieExtraFilter::string( $item_desktop, 'attr', '5' ) : '5';
	$item_tablet = isset( $item_tablet ) ? StockieExtraFilter::string( $item_tablet, 'attr', '3' ) : '3';
	$item_mobile = isset( $item_mobile ) ? StockieExtraFilter::string( $item_mobile, 'attr', '1' ) : '1';

	$overlay_color = isset( $overlay_color ) ? StockieExtraFilter::string( $overlay_color ) : false;
	$category_bg_color = isset( $category_bg_color ) ? StockieExtraFilter::string( $category_bg_color ) : false;
	$category_color = isset( $category_color ) ? StockieExtraFilter::string( $category_color ) : false;
	$title_color = isset( $title_color ) ? StockieExtraFilter::string( $title_color ) : false;
	$more_color = isset( $more_color ) ? StockieExtraFilter::string( $more_color ) : false;

	if ( $show_projects_filter ) {
		$css_class .= ' with-sorting';
	}

	$_tax_query = array();
	if ( $projects_category != 'all' ) {
		$_tax_query = array(
			array(
				'taxonomy' => 'stockie_portfolio_category',
				'terms'    => $projects_category
			)
		);
	}

	if (is_front_page()) {
		$paged = (get_query_var('page')) ? get_query_var('page') : 1;
	} else {
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	}

	$args = array(
	  'posts_per_page' 	=> intval( $projects_in_block ),
	  'orderby' 		=> 'date',
	  'order' 			=> 'DESC',
	  'post_type' 		=> 'stockie_portfolio',
	  'tax_query' 		=> $_tax_query,
	  'post_status' 	=> 'publish',
	  'paged'			=> $paged
	);
	$query = new WP_Query( $args );

	$projects_data = $query->posts;

	$column_class = StockieExtraParser::VC_columns_to_CSS( $columns_in_row );
	$column_double_class = StockieExtraParser::VC_columns_to_CSS( $columns_in_row, true );

	$columns_in_row = explode( '-', $columns_in_row );
	if ( is_array( $columns_in_row ) ) {
		$columns_in_row = intval( $columns_in_row[0] );
	}

	$is_slider = false;
	$is_splitscreen = false;
	$is_onepage = false;

	switch ( $card_layout ) {
		case 'grid_4':
		case 'grid_6':
			$is_slider = true;
			break;
		case 'grid_5':
			$is_splitscreen = true;
			break;
		case 'grid_7':
		case 'grid_8':
			$is_onepage = true;
			break;
	}

	// Styling
	$recent_projects_uniqid = uniqid( 'stockie-custom-' );
	$GLOBALS['stockie_icon_fonts'][] = 'my-icon-arr-out';

	if ( $card_layout == 'grid_4' || $card_layout == 'grid_6' ) {
		$grid_items_gap_css = 'padding-left: ' . $grid_items_gap . '; padding-right:' . $grid_items_gap . ';';
		$grid_row_css = 'margin-left: -' . ( $grid_items_gap ) . ';margin-right: -' . ( $grid_items_gap ) . ';';
	} else {
		$grid_items_gap_css = 'padding: ' . $grid_items_gap . ';';
		$grid_row_css = 'margin: -' . ( $grid_items_gap ) . ';';
	}


	switch ( $filter_align ) {
		case 'left':
			$filter_align_class = ' text-left';
			break;
		case 'right':
			$filter_align_class = ' text-right';
			break;
		default:
			$filter_align_class = '';
			break;
	}

	$overlay_css = ( $overlay_color ) ? 'background-color:' . $overlay_color . ';' : '';


	$more_css = '';
	$more_css_before = '';
	$more_class = '';
	if ( $more_color ) {
		switch ( $card_layout ) {
			case 'grid_1_hover_1':
			case 'grid_1_hover_2':
			case 'grid_1_hover_3':
				if ( $more_color == 'brand' ) {
					$more_class .= ' brand-color-i';
				} else {
					$more_css .= 'color:' . $more_color . ';';
				}
				break;
			case 'grid_2_hover_2':
				if ( $more_color == 'brand' ) {
					$more_class .= ' brand-color-i brand-border-color-i';
				} else {
					$more_css .= 'color:' . $more_color . ';border-color:' . $more_color . ';';
				}
				break;
			case 'grid_4':
			case 'grid_5':
			case 'grid_7':
			case 'grid_8':
				if ( $more_color == 'brand' ) {
					$more_class .= ' brand-color-i brand-bg-color-before-i';
				} else {
					$more_css .= 'color:' . $more_color . ';';
					$more_css_before .= 'background-color:' . $more_color . ';';
				}
				break;
		}
	}


	$category_css = '';
	$category_class = '';

	switch ( $card_layout ) {
		case 'grid_1_hover_1':
		case 'grid_1_hover_2':
		case 'grid_1_hover_3':
		case 'grid_3':
		case 'grid_4':
		case 'grid_5':
		case 'grid_7':
		case 'grid_8':
			if ( $category_color ) {
				if ( $category_color == 'brand' ) {
					$category_class .= ' brand-color-i';
				} else {
					$category_css .= 'color:' . $category_color . ';';
				}
			}
			if ( $category_bg_color ) {
				if ( $category_bg_color == 'brand' ) {
					$category_class .= ' brand-bg-color-i';
				} else {
					$category_css .= 'background-color: ' . $category_bg_color . ';';
				}
			}
			break;
		case 'grid_2_hover_1':
		case 'grid_2_hover_2':
		case 'grid_2_hover_3':
		case 'grid_6':
			if ( $category_color ) {
				if ( $category_color == 'brand' ) {
					$category_class .= ' brand-color-i';
				} else {
					$category_css .= 'color:' . $category_color . ';';
				}
			}
			break;
	}

	$title_css = ( $title_color && $title_color != 'brand' ) ? 'color:' . $title_color . ';' : '';
	$title_class = '';
	if ( $title_color == 'brand' ) {
		$title_class .= ' brand-color-i';
	}

	$pagination_class = $pagination_css = $pagination_hover_css = '';



	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'recent_projects__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'recent_projects__view.php' );
	return ob_get_clean();
}