<?php

/**
* WPBakery Page Builder Stockie Recent Posts shortcode params
*/

vc_map( array(
	'name' => __( 'Blog Posts', 'stockie-extra' ),
	'description' => __( 'Block with blog posts', 'stockie-extra' ),
	'base' => 'stockie_recent_posts',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(
		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Blog posts layout', 'stockie-extra' ),
			'param_name' => 'card_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_083.svg',
					'key' => 'classic',
					'title' => __( 'Classic', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_084.svg',
					'key' => 'simple',
					'title' => __( 'Simple', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_085.svg',
					'key' => 'overlay',
					'title' => __( 'Overlay', 'stockie-extra' )
				)
			)
		),
		array(
			'type' => 'stockie_post_types',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Blog posts categories', 'stockie-extra' ),
			'param_name' => 'post_category',
			'value' => ''
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Items boxed style', 'stockie-extra' ),
			'param_name' => 'card_boxed',
			'description' => __( 'Append box wrapper for post cards.', 'stockie-extra' ),
			'value' => array(
				__( 'Wrap in box', 'stockie-extra' ) => '1'
			),
			'dependency' => array(
				'element' => 'card_layout',
				'value' => array(
					'classic',
					'side_image',
					'striped'
				)
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Grid cards animation', 'stockie-extra' ),
			'param_name' => 'animation_type',
			'value' => array(
				__( 'Disable animation', 'stockie-extra' ) => 'default',
				__( 'Sync animation', 'stockie-extra' ) => 'sync',
				__( 'Async animation', 'stockie-extra' ) => 'async'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Cards animation effect', 'stockie-extra' ),
			'param_name' => 'animation_effect',
			'value' => array(
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'stockie_columns',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Columns in row', 'stockie-extra' ),
			'param_name' => 'columns_in_row',
			'std' => '4-3-2-1'
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Posts in the block', 'stockie-extra' ),
			'param_name' => 'posts_in_block',
			'description' => __( 'Chose number of last projects in the block.', 'stockie-extra' ),
			'value' => 12
		),
		
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Items gap', 'stockie-extra' ),
			'param_name' => 'card_gap',
			'description' => __( 'Use CSS value.', 'stockie-extra' ),
			'value' => '30px'
		),

		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_card_heading_typo',
			'value' => __( 'Card headline', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'heading_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_card_content_typo',
			'value' => __( 'Card content', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'text_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_card_info_typo',
			'value' => __( 'Card details', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'subtitle_typo',
		),

		// Pagination
		array(
			'type' => 'stockie_check',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Use pagination', 'stockie-extra' ),
			'param_name' => 'use_pagination',
			'description' => '',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Pagination type', 'stockie-extra' ),
			'param_name' => 'pagination_type',
			'value' => array(
				__( 'Simple', 'stockie-extra' ) => 'simple',
				__( 'Lazy load', 'stockie-extra' ) => 'lazy_scroll',
				__( 'Load more button', 'stockie-extra' ) => 'lazy_button',
			),
			'std' => 'simple',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'1'
				)
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Number of items per page', 'stockie-extra' ),
			'param_name' => 'pagination_items_per_page',
			'value' => '6',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'1'
				)
			)
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Card headline color', 'stockie-extra' ),
			'param_name' => 'card_heading_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Card content color', 'stockie-extra' ),
			'param_name' => 'card_text_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Card details color', 'stockie-extra' ),
			'param_name' => 'card_subtitle_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Card background color', 'stockie-extra' ),
			'param_name' => 'card_background_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Pagination color', 'stockie-extra' ),
			'param_name' => 'pagination_color',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => '1',
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Pagination hover and active color', 'stockie-extra' ),
			'param_name' => 'pagination_active_color',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => '1',
			)
		),

		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );